;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/tinsel/init.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; ===========================================================================

;                             T I N S E L

;                  "Tandem INterpreter for SELection"

;

;     A tandem case-frame semantic interpreter / selection component

;                       for the PROTEUS parser

;

;                          Kenneth Wauchope

;      Navy Center for Applied Research in Artificial Intelligence

;                             Code 5512

;                      Naval Research Laboratory

;                      Washington, DC 20375-5337

;                      wauchope@aic.nrl.navy.mil

; ======================================================================


(DEFUN LOAD-GRAMMARS (FILENAMES)
  (RELOAD-GRAMMARS
   (SETQ *GRAM-LIST*
         (CHECK-FILES FILENAMES *DEFAULT-GRAM-LISP-PATHNAME*))))

(DEFUN LOAD-DICTIONARIES (FILENAMES)
  (RELOAD-DICTIONARIES
   (SETQ *DICT-LIST*
         (CHECK-FILES FILENAMES *DEFAULT-DICTIONARY-PATHNAME*))))

(DEFUN LOAD-MODEL (FILENAME)
  (DECLARE (SPECIAL *FRAMES* *OUTER-ROLE-SPECS* *ROLES* *QUANTIFIERS*
            *PREDS* *NPREDS* *CONS*))
  (FOREACH F IN *FRAMES* DO (SETF (GET F 'ASI) NIL)
   (SETF (GET F 'ISA) NIL))
  (SETQ *FRAMES* NIL)
  (SETQ *OUTER-ROLE-SPECS* NIL)
  (SETQ *ROLES* NIL)
  (SETQ *QUANTIFIERS* NIL)
  (FOREACH P IN *PREDS* DO (SETF (GET P 'PRED-FRAME-SPECS) NIL)
   (SETF (GET P 'LEX) NIL))
  (SETQ *PREDS* NIL)
  (FOREACH N IN *NPREDS* DO (SETF (GET N 'NPRED-FRAME-SPECS) NIL)
   (SETF (GET N 'NLEX) NIL))
  (SETQ *NPREDS* NIL)
  (FOREACH C IN *CONS* DO (SETF (GET C 'CONSTANT-FRAMES) NIL))
  (SETQ *CONS* NIL)
  (LOAD FILENAME))

(UNLESS (FBOUNDP 'GETENV) (DEFUN GETENV (VAR) (SYSTEM:GETENV VAR)))

;; "[redefined]"
;; (DEFUN LOAD-FILE (DIR FILE)
;;   (LET ((P (PATHNAME (CONCATENATE 'STRING DIR FILE)))) (LOAD P)))

(SETQ *TINSEL-HOME* (CONCATENATE 'STRING (GETENV "TINSEL_HOME") "/"))

(SETQ *TINSEL-BINARY-HOME* *TINSEL-HOME*)

(LOAD-FILE *TINSEL-BINARY-HOME* "util")

(SETQ *SOURCE-PREFIX* *TINSEL-HOME*)

(SETQ *BINARY-PREFIX* *TINSEL-BINARY-HOME*)

(SETQ *SOURCE-SUFFIX* ".lisp")

(SETQ *BINARY-SUFFIX* ".fasl")

(LOAD-COMPILE "defmodel")
; model definition macros


(LOAD-COMPILE "globals")
; global values


(LOAD-COMPILE "tinsel")
; main TINSEL code


(LOAD-COMPILE "np-handler")
; NP-handling routines


(LOAD-COMPILE "preferences")
; preference rules


(LOAD-COMPILE "filter")
; post-parse TINSEL utility


(LOAD-COMPILE "misc")
; miscellaneous


(LOAD-COMPILE "tinterface")