;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/tinsel/misc.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; ======================================================================

; TINSEL miscellaneous code


(DEFUN SHOW-MODEL (ROOT) (SHOW-ROOT-AND-SUBTYPES ROOT 0) T)

(DEFUN SHOW-ROOT-AND-SUBTYPES (ROOT INDENT)
  (COND ((NULL ROOT) NIL)
        ((ATOM ROOT)
         (TERPRI)
         (DOTIMES (I INDENT) (PRINC " "))
         (PRINC ROOT)
         (FOREACH CHILD IN (GET ROOT 'ASI) DO
          (SHOW-ROOT-AND-SUBTYPES CHILD (+ INDENT 3))))))

(DEFMACRO TINSEL-CHECK (&REST NAMES &AUX DEFINED)
  `(PROGN (FOREACH N IN ',NAMES DO (SETQ DEFINED NIL)
           (FORMAT T "~%~A:~%" N)
           (WHEN (MEMBER N *FRAMES*)
             (SETQ DEFINED T)
             (LET ((ISA (GET N 'ISA)))
               (WHEN (CDR ISA) (SETQ ISA (LIST ISA)))
               (PRINT (IF ISA
                          `(DEFFRAME ,N :ISA ,@ISA
                            ,@(GET N 'SLOT-SPECS))
                        `(DEFFRAME ,N ,@(GET N 'SLOT-SPECS))))
               (TERPRI)))
           (WHEN (GET N 'PRED-FRAME-SPECS)
             (SETQ DEFINED T)
             (PRINT `(DEFPRED ,N ,@(GET N 'PRED-FRAME-SPECS)))
             (TERPRI))
           (WHEN (GET N 'NPRED-FRAME-SPECS)
             (SETQ DEFINED T)
             (PRINT `(DEFNPRED ,N ,@(GET N 'NPRED-FRAME-SPECS)))
             (TERPRI))
           (WHEN (GET N 'CONSTANT-FRAMES)
             (SETQ DEFINED T)
             (PRINT `(DEFCON ,N ,@(GET N 'CONSTANT-FRAMES)))
             (TERPRI))
           (WHEN (IS-ROLE N)
             (SETQ DEFINED T)
             (IF (MEMBER N *ROLES*)
                 (PRINT `(DEFROLE ,N))
               (FORMAT T "~%~A is assumed to be a ROLE~%" N)))
           (WHEN (IS-Q N)
             (SETQ DEFINED T)
             (IF (MEMBER N *QUANTIFIERS*)
                 (PROGN (PRINT `(DEFQ ,N)) (TERPRI))
               (FORMAT T "~%~A is assumed to be a Q~%" N)))
           (WHEN (MY-ASSOC N *OUTER-ROLE-SPECS*)
             (SETQ DEFINED T)
             (PRINT `(DEFADJUNCT ,@(MY-ASSOC N *OUTER-ROLE-SPECS*)))
             (TERPRI))
           (WHEN (NOT DEFINED)
             (FORMAT T "~%~A has no TINSEL definition~%" N)))
          T))