;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/tinsel/np-handler.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; ======================================================================

; TINSEL Noun Phrase Interpretation Functions


;; "[redefined]"
;; (DEFUN MAKE-NP-INDEX () (GENSYM "N"))

(DEFUN INTERPRET-CONSTANT (XN &AUX INTERPS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (WHEN *TRACE-SELECTION* (TRACE-MSG "Translation = ~A.~%" XN))
  (SETQ INTERPS
        (CASE XN
          (VAR (GET-VAR-HOSTS))
          (PRO (GET-PRO-HOSTS))
          (T
           (FOREACH S IN (GET XN 'CONSTANT-FRAMES) COLLECT
            (IF (GETF (GET XN 'WORD-DEFN) 'PRO)
                `(PRON ,(MAKE-NP-INDEX) (:CLASS ,S) ,XN)
              `(NAME ,(MAKE-NP-INDEX) (:CLASS ,S) ,XN))))))
  (WHEN *TRACE-SELECTION*
    (IF INTERPS
        (PP-TRACE-MSG "SIMPTERM interpretations =" INTERPS)
      (TRACE-MSG "No interpretations for ~A.~%" XN)))
  (IF (CDR INTERPS) (CONS 'ONEOF INTERPS) (CAR INTERPS)))

(DEFUN INTERPRET-EXPANDED-CONSTANT (XN &AUX INTERPS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (WHEN *TRACE-SELECTION* (TRACE-MSG "Translation = ~A.~%" XN))
  (LET* ((FLAG (FIRST XN))
         (VAR (SECOND XN))
         (NAME (THIRD XN))
         (APPOS (MY-ASSOC 'APPOS XN)))
    (SETQ INTERPS
          (FOREACH S IN (GET NAME 'CONSTANT-FRAMES) COLLECT
           (REVERSE `(,FLAG ,VAR (:CLASS ,S) ,NAME))))
    (WHEN (AND INTERPS APPOS)
      (SETQ INTERPS (INTERPRET-RN-APPOS-WFFS INTERPS (CDR APPOS))))
    (SETQ INTERPS (MAPCAR #'REVERSE INTERPS))
    (WHEN *TRACE-SELECTION*
      (IF INTERPS
          (PP-TRACE-MSG "SIMPTERM interpretations =" INTERPS)
        (TRACE-MSG "No interpretations for ~A.~%" XN)))
    (IF (CDR INTERPS) (CONS 'ONEOF INTERPS) (CAR INTERPS))))

(DEFUN INTERPRET-QUANT (XN &AUX INTERPS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (WHEN *TRACE-SELECTION* (TRACE-MSG "Translation = ~A.~%" XN))
  (LET* ((QUANT (FIRST XN))
         (VAR (SECOND XN))
         (NPRED (THIRD XN))
         (NUM (FOURTH XN))
         (ANSTG (MY-ASSOC 'AN-STG XN))
         (APPOS (MY-ASSOC 'APPOS XN))
         (RN
          (NTHCDR 4
                  (REMOVE APPOS (REMOVE ANSTG XN :TEST #'EQUAL)
                    :TEST #'EQUAL)))
         (CONFIGS
          (FOREACH SPEC IN (GET NPRED 'NPRED-FRAME-SPECS) COLLECT
           (LET ((FRAME-NAME (CAR SPEC)) (MAPPING (CDR SPEC)))
             (LIST (IF NUM
                       (LIST NUM (LIST :CLASS FRAME-NAME) VAR QUANT)
                     (LIST (LIST :CLASS FRAME-NAME) VAR QUANT))
                   (GET FRAME-NAME 'SLOT-SPECS) MAPPING)))))
    (SETQ INTERPS (CHECK-NP-MODIFIERS CONFIGS ANSTG RN APPOS))
    (SETQ INTERPS
          (FOREACH INTERP IN INTERPS JOIN (PROCESS-PARTITIVE INTERP)))
    (WHEN *TRACE-SELECTION*
      (IF INTERPS
          (PP-TRACE-MSG "SIMPTERM interpretations =" INTERPS)
        (TRACE-MSG "No interpretations for ~A.~%" XN)))
    (IF (CDR INTERPS) (CONS 'ONEOF INTERPS) (CAR INTERPS))))

(DEFUN PROCESS-PARTITIVE (INTERP)
  (LET* ((Q-OF-SLOT (MY-ASSOC :Q-OF INTERP))
         (Q-OF-VALS (CADR Q-OF-SLOT))
         (NEW-INTERP (REMOVE Q-OF-SLOT INTERP)))
    (IF (AND Q-OF-VALS (IS-ONEOF-INTERP Q-OF-VALS))
        (FOREACH VAL IN (CDR Q-OF-VALS) COLLECT
         `(,@NEW-INTERP (:Q-OF ,VAL)))
      (LIST INTERP))))

(DEFUN CHECK-NP-MODIFIERS (CONFIGS ANSTG RN APPOS)
  (CHECK-NP-MODIFIERS-1 CONFIGS ANSTG RN APPOS))

(DEFUN IGNORE-ANSTG ()
  (SETF (SYMBOL-FUNCTION 'CHECK-NP-MODIFIERS) #'CHECK-NP-MODIFIERS-1))

(DEFUN NOIGNORE-ANSTG ()
  (SETF (SYMBOL-FUNCTION 'CHECK-NP-MODIFIERS) #'CHECK-NP-MODIFIERS-2))

(DEFUN NOIGNORE-ADJS ()
  (SETF (SYMBOL-FUNCTION 'CHECK-NP-MODIFIERS) #'CHECK-NP-MODIFIERS-3))

(DEFUN CHECK-NP-MODIFIERS-1 (CONFIGS ANSTG RN APPOS &AUX INTERPS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "THIS CODE IGNORES ANSTG MODIFIERS...~%"))
  (SETQ INTERPS (CHECK-RN CONFIGS RN APPOS))
  (FOREACH I IN INTERPS COLLECT (REVERSE (IF ANSTG (CONS ANSTG I) I))))

(DEFUN CHECK-NP-MODIFIERS-2
    (CONFIGS ANSTG RN APPOS &AUX UNINTERPRETED-ANSTG-CONFIGS INTERPS
     AN-LIST)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (SETQ AN-LIST (REVERSE (CADR ANSTG)))
  (IF (AND CONFIGS AN-LIST) (SETQ CONFIGS (CHECK-LN CONFIGS AN-LIST)))
  (IF UNINTERPRETED-ANSTG-CONFIGS
      (SETQ CONFIGS (APPEND CONFIGS UNINTERPRETED-ANSTG-CONFIGS)))
  (WHEN CONFIGS
    (SETQ INTERPS (CHECK-RN CONFIGS RN APPOS))
    (WHEN (AND *TRACE-SELECTION* ANSTG)
      (TRACE-MSG "++++++++++++++++++++++++++++++++++++++~%"))
    (FOREACH I IN INTERPS COLLECT (REVERSE I))))

(DEFUN CHECK-NP-MODIFIERS-3
    (CONFIGS ANSTG RN APPOS &AUX INTERPS ASTG NASTG)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "THIS CODE IGNORES N PREMODIFIERS...~%"))
  (DO* ((ITEMS (SECOND ANSTG) (CDR ITEMS))
        (ITEM (CAR ITEMS) (CAR ITEMS)))
       ((OR (NULL ITEMS) (IS-LN-NOUN-FORM ITEM)) (SETQ NASTG ITEMS))
    (PUSH ITEM ASTG))
  (WHEN ASTG (SETQ CONFIGS (CHECK-LN CONFIGS ASTG)))
  (IF (AND CONFIGS NASTG)
      (SETQ CONFIGS
            (FOREACH C IN CONFIGS COLLECT
             (CONS (CONS (LIST 'AN-STG NASTG) (CAR C)) (CDR C)))))
  (WHEN CONFIGS
    (SETQ INTERPS (CHECK-RN CONFIGS RN APPOS))
    (WHEN (AND *TRACE-SELECTION* ANSTG)
      (TRACE-MSG "++++++++++++++++++++++++++++++++++++++~%"))
    (FOREACH I IN INTERPS COLLECT (REVERSE I))))

(DEFUN MAY-CONTAIN-MODIFIED-NOUNS (AN-LIST)
  (COND ((NULL AN-LIST) NIL) (T (CONTAINS-LN-NOUN-FORM (CDR AN-LIST)))))

(DEFUN CONTAINS-LN-NOUN-FORM (AN-LIST)
  (COND ((NULL AN-LIST) NIL)
        ((IS-LN-NOUN-FORM (CAR AN-LIST)) T)
        (T (CONTAINS-LN-NOUN-FORM (CDR AN-LIST)))))

(DEFUN CHECK-LN (CONFIGS LN)
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "++++++++++++++++++++++++++++++++++++++~%"))
  (SETQ CONFIGS
        (REMOVE NIL
                (COND ((IS-LN-NOUN-FORM (CAR LN))
                       (WHEN *TRACE-SELECTION*
                         (TRACE-MSG "Testing noun modifier ~A.~%"
                          (CAR LN)))
                       (FOREACH CONFIG IN CONFIGS JOIN
                        (INTERPRET-LN-N CONFIG (CAR LN))))
                      ((IS-LN-CONST-FORM (CAR LN))
                       (WHEN *TRACE-SELECTION*
                         (TRACE-MSG "Testing constant modifier ~A.~%"
                          (CAR LN)))
                       (FOREACH CONFIG IN CONFIGS JOIN
                        (INTERPRET-LN-CONST CONFIG (CAR LN))))
                      ((IS-LN-VING-FORM (CAR LN))
                       (WHEN *TRACE-SELECTION*
                         (TRACE-MSG "Testing ving modifier ~A.~%"
                          (CAR LN)))
                       (FOREACH CONFIG IN CONFIGS JOIN
                        (INTERPRET-LN-VING CONFIG (CAR LN))))
                      ((IS-LN-VEN-FORM (CAR LN))
                       (WHEN *TRACE-SELECTION*
                         (TRACE-MSG "Testing ven modifier ~A.~%"
                          (CAR LN)))
                       (FOREACH CONFIG IN CONFIGS JOIN
                        (INTERPRET-LN-ADJ CONFIG (CAR LN))))
                      ((IS-LN-ADJ-FORM (CAR LN))
                       (WHEN *TRACE-SELECTION*
                         (TRACE-MSG "Testing adj modifier ~A.~%"
                          (CAR LN)))
                       (FOREACH CONFIG IN CONFIGS JOIN
                        (INTERPRET-LN-ADJ CONFIG (CAR LN)))))))
  (IF CONFIGS (IF (CDR LN) (CHECK-LN CONFIGS (CDR LN)) CONFIGS)))

;; "[redefined]"
;; (DEFUN INTERPRET-LN-ADJ
;;     (CONFIG ADJ-FORM &AUX INTERP CLAUSE-INTERPS NOM-INTERPS *VAR-HOST*)
;;   (DECLARE (SPECIAL *VAR-HOST*))
;;   (SETQ INTERP (FIRST CONFIG))
;;   (SETQ *VAR-HOST* (REVERSE INTERP))
;;   (WHEN *TRACE-SELECTION*
;;     (TRACE-MSG "======================================~%"))
;;   (SETQ CLAUSE-INTERPS (INTERPRET-WFF `(,@ADJ-FORM VAR)))
;;   (WHEN CLAUSE-INTERPS
;;     (SETQ NOM-INTERPS
;;           (FOREACH R IN
;;            (IF (EQ (CAR CLAUSE-INTERPS) 'ONEOF)
;;                (CDR CLAUSE-INTERPS)
;;              (LIST CLAUSE-INTERPS))
;;            COLLECT
;;            (LIST (CONS R INTERP) (SECOND CONFIG) (THIRD CONFIG)))))
;;   NOM-INTERPS)

;; "[redefined]"
;; (DEFUN INTERPRET-LN-VING
;;     (CONFIG VING-FORM &AUX INTERP N-MODIFIER-INTERPS V-MODIFIER-INTERPS
;;      NOM-INTERPS *VAR-HOST*)
;;   (DECLARE (SPECIAL *VAR-HOST*))
;;   (SETQ INTERP (FIRST CONFIG))
;;   (SETQ *VAR-HOST* (REVERSE INTERP))
;;   (WHEN *TRACE-SELECTION*
;;     (TRACE-MSG "======================================~%")
;;     (TRACE-MSG "First analyzing as unary adjectival.~%"))
;;   (SETQ V-MODIFIER-INTERPS (INTERPRET-WFF `(,@VING-FORM VAR)))
;;   (WHEN (NOT V-MODIFIER-INTERPS)
;;     (WHEN *TRACE-SELECTION*
;;       (TRACE-MSG "No noun-modifier interpretations for ~A.~%"
;;        VING-FORM)
;;       (TRACE-MSG "======================================~%")
;;       (TRACE-MSG "Next analyzing as nominal.~%"))
;;     (SETQ N-MODIFIER-INTERPS (INTERPRET-LN-VING-N CONFIG VING-FORM)))
;;   (SETQ NOM-INTERPS
;;         (APPEND N-MODIFIER-INTERPS
;;                 (WHEN V-MODIFIER-INTERPS
;;                   (FOREACH R IN
;;                    (IF (EQ (CAR V-MODIFIER-INTERPS) 'ONEOF)
;;                        (CDR V-MODIFIER-INTERPS)
;;                      (LIST V-MODIFIER-INTERPS))
;;                    COLLECT
;;                    (LIST (CONS R INTERP) (SECOND CONFIG)
;;                          (THIRD CONFIG))))))
;;   NOM-INTERPS)

(DEFUN IS-LN-NOUN-FORM (FORM)
  (AND (CONSP FORM) (MEMBER (SECOND FORM) '(SINGULAR PLURAL)) FORM))

(DEFUN IS-LN-CONST-FORM (FORM) (SYMBOLP FORM))

(DEFUN IS-LN-VERB-FORM (FORM)
  (IF (OR (IS-LN-VING-FORM FORM) (IS-LN-VEN-FORM FORM)) FORM))

(DEFUN IS-LN-VING-FORM (FORM)
  (AND (CONSP FORM) (EQ (CAR FORM) 'PROG)
       (GET (CADR FORM) 'PRED-FRAME-SPECS)
       (NOT (MEMBER (CAR (LAST FORM)) '(SINGULAR PLURAL))) FORM))

(DEFUN IS-LN-VEN-FORM (FORM)
  (AND (CONSP FORM) (ATOM (CAR FORM))
       (GET (CAR FORM) 'PRED-FRAME-SPECS) (EQ (CADR FORM) 'ANYONE)
       FORM))

(DEFUN IS-LN-ADJ-FORM (FORM &AUX OP1S)
  (WHEN (CONSP FORM)
    (MULTIPLE-VALUE-SETQ (OP1S FORM) (SKIP-OP1S FORM))
    (IF (AND (GET (CAR FORM) 'PRED-FRAME-SPECS) (NULL (CDR FORM)))
        FORM)))

(DEFUN INTERPRET-LN-N (CONFIG NOUNFORM)
  (LET* ((INTERP (FIRST CONFIG))
         (FRAME-SPEC (SECOND CONFIG))
         (MAPPINGS (THIRD CONFIG))
         (POSSIBLE-ROLES (POSSIBLE-INNER-ROLES 'AN-STG MAPPINGS))
         (MODIFIER-VALUES
          (INTERPRET-QUANT `(NULL-QUANT ,(MAKE-NP-INDEX) ,@NOUNFORM))))
    (IF MAPPINGS
        (INNER-ROLE-INTERPRETATIONS INTERP FRAME-SPEC POSSIBLE-ROLES
         MAPPINGS MODIFIER-VALUES))))

(DEFUN INTERPRET-LN-VING-N (CONFIG VINGFORM)
  (LET* ((INTERP (FIRST CONFIG))
         (FRAME-SPEC (SECOND CONFIG))
         (MAPPINGS (THIRD CONFIG))
         (POSSIBLE-ROLES (POSSIBLE-INNER-ROLES 'AN-STG MAPPINGS))
         (HEAD (CADR VINGFORM))
         (MODIFIER-VALUES
          (LET ((CLASSES
                 (REMOVE-DUPLICATES
                    (FOREACH S IN (GET HEAD 'PRED-FRAME-SPECS) COLLECT
                     (CAR S)))))
            (FOREACH C IN CLASSES COLLECT
             (LIST 'NULL-QUANT (MAKE-NP-INDEX) (LIST :CLASS C)
                   'SINGULAR)))))
    (IF POSSIBLE-ROLES
        (INNER-ROLE-INTERPRETATIONS INTERP FRAME-SPEC POSSIBLE-ROLES
         MAPPINGS
         (IF (CDR MODIFIER-VALUES)
             (CONS 'ONEOF MODIFIER-VALUES)
           (CAR MODIFIER-VALUES))))))

(DEFUN INTERPRET-LN-CONST (CONFIG CONSTFORM)
  (LET* ((INTERP (FIRST CONFIG))
         (FRAME-SPEC (SECOND CONFIG))
         (MAPPINGS (THIRD CONFIG))
         (POSSIBLE-ROLES (POSSIBLE-INNER-ROLES 'AN-STG MAPPINGS))
         (MODIFIER-VALUES (INTERPRET-CONSTANT CONSTFORM)))
    (IF MAPPINGS
        (INNER-ROLE-INTERPRETATIONS INTERP FRAME-SPEC POSSIBLE-ROLES
         MAPPINGS MODIFIER-VALUES))))

(DEFUN CHECK-RN
    (CONFIGS RN APPOS &AUX RN-ROLETERMS RN-WFFS RN-ATTPS D-FORMS
     INTERPS POSSIBLE-PRED)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (FOREACH MOD IN RN DO
   (COND ((IS-ROLETERM MOD)
          (PUSH (LIST (CAR MOD) (GET-SEMANTICS (CADR MOD)))
                RN-ROLETERMS))
         ((IS-WFF MOD) (PUSH MOD RN-WFFS))
         ((IS-ADVERBIAL-FORM MOD) (PUSH MOD D-FORMS))
         (T
          (WHEN *TRACE-SELECTION*
            (TRACE-MSG "***UNRECOGNIZED MODIFIER: ~A.~%" MOD))
          (RETURN-FROM CHECK-RN NIL))))
  (SETQ INTERPS
        (INTERPRET-RN-ROLETERMS CONFIGS (REVERSE RN-ROLETERMS)))
  (WHEN (AND INTERPS RN-WFFS)
    (SETQ INTERPS (INTERPRET-RN-WFFS INTERPS (REVERSE RN-WFFS))))
  (WHEN (AND INTERPS APPOS)
    (SETQ INTERPS (INTERPRET-RN-APPOS-WFFS INTERPS (CDR APPOS))))
  (WHEN D-FORMS
    (SETQ INTERPS (FOREACH I IN INTERPS COLLECT (APPEND D-FORMS I))))
  INTERPS)

(DEFUN INTERPRET-RN-ROLETERMS
    (CONFIGS ROLETERMS &AUX ARG-INTERP-CONFIGS ROLEPRED-INTERP-CONFIGS
     BE-INTERP-CONFIGS WITH-OF-INTERP-CONFIGS
     COVERTPRED-INTERP-CONFIGS)
  (DO* ((RTS ROLETERMS (CDR RTS)) (RT (CAR RTS) (CAR RTS)))
       ((COND ((NULL CONFIGS) (RETURN NIL))
              ((NULL RTS)
               (WHEN *TRACE-SELECTION*
                 (TRACE-MSG "--------------------------------------~%")
                 (TRACE-MSG
                  "All RoleTerm modifiers have been matched.~%"))
               (RETURN (REMOVE NIL
                               (FOREACH
                                C
                                IN
                                CONFIGS
                                COLLECT
                                (IF
                                 (UNFILLED-OBLIGATORY-CASE
                                  (REVERSE (FIRST C))
                                  (THIRD C))
                                 NIL
                                 (FIRST C))))))))
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "--------------------------------------~%")
      (TRACE-MSG "Checking modifier = ~A.~%" RT)
      (TRACE-MSG "======================================~%")
      (TRACE-MSG "Trying to analyze ~A as Argument.~%" RT))
    (SETQ ARG-INTERP-CONFIGS
          (FOREACH C IN CONFIGS JOIN (INTERPRET-ARG C RT)))
    (WHEN *TRACE-SELECTION*
      (IF (NOT ARG-INTERP-CONFIGS)
          (TRACE-MSG "No interpretations.~%")))
    (SETQ ROLEPRED-INTERP-CONFIGS
          (FOREACH C IN CONFIGS JOIN (INTERPRET-OUTER-ROLE C RT)))
    (IF (GET 'BE 'PRED-FRAME-SPECS)
        (SETQ BE-INTERP-CONFIGS
              (FOREACH C IN CONFIGS JOIN (INTERPRET-BE-WFF C RT)))
      (WHEN *TRACE-SELECTION*
        (TRACE-MSG "======================================~%")
        (TRACE-MSG
         "BE has no defpreds: not attempting expansion as BE Relative Clause.~%")))
    (IF (GET 'HAVE 'PRED-FRAME-SPECS)
        (SETQ WITH-OF-INTERP-CONFIGS
              (FOREACH C IN CONFIGS JOIN (INTERPRET-WITH-OF C RT)))
      (WHEN *TRACE-SELECTION*
        (TRACE-MSG "======================================~%")
        (TRACE-MSG
         "HAVE has no defpreds: not attempting expansion as HAVE Relative Clause.~%")))
    (IF (GET 'COVERT-PRED 'PRED-FRAME-SPECS)
        (SETQ COVERTPRED-INTERP-CONFIGS
              (FOREACH C IN CONFIGS JOIN (INTERPRET-COVERTPRED C RT)))
      (WHEN *TRACE-SELECTION*
        (TRACE-MSG "======================================~%")
        (TRACE-MSG
         "COVERT-PRED has no defpreds: not attempting expansion as COVERT-PRED Relative Clause.~%")))
    (SETQ CONFIGS
          (APPEND ARG-INTERP-CONFIGS ROLEPRED-INTERP-CONFIGS
                  BE-INTERP-CONFIGS WITH-OF-INTERP-CONFIGS
                  COVERTPRED-INTERP-CONFIGS))
    (WHEN (AND *TRACE-SELECTION* (NOT CONFIGS))
      (TRACE-MSG "No role for ~A.~%" RT))))

(DEFUN INTERPRET-OUTER-ROLE (CONFIG ROLETERM &AUX INTERPS)
  (LET ((INTERP (FIRST CONFIG))
        (SPECS (SECOND CONFIG))
        (MAPPING (THIRD CONFIG)))
    (SETQ INTERPS
          (REMOVE NIL
                  (FOREACH S IN (OUTER-ROLE-SPECS (CAR ROLETERM))
                   COLLECT
                   (SATISFIES-OUTER-ROLE-SPEC INTERP S
                    (CADR ROLETERM)))))
    (FOREACH I IN INTERPS COLLECT (LIST I SPECS MAPPING))))

(DEFUN INTERPRET-BE-WFF (CONFIG ROLETERM &AUX INTERPS)
  (LET ((INTERP (FIRST CONFIG))
        (SPECS (SECOND CONFIG))
        (MAPPING (THIRD CONFIG)))
    (SETQ INTERPS (BE-WFF-INTERPRETATIONS INTERP ROLETERM))
    (FOREACH I IN INTERPS COLLECT (LIST I SPECS MAPPING))))

;; "[redefined]"
;; (DEFUN BE-WFF-INTERPRETATIONS
;;     (INTERP FLAGGED-ARG &AUX RESULTS *VAR-HOST*)
;;   (DECLARE (SPECIAL *VAR-HOST* *TRACE-SELECTION*))
;;   (WHEN *TRACE-SELECTION*
;;     (TRACE-MSG "======================================~%")
;;     (TRACE-MSG "Trying to analyze ~A as Relative Clause.~%"
;;      FLAGGED-ARG))
;;   (SETQ *VAR-HOST* (REVERSE INTERP))
;;   (SETQ RESULTS (LIST (INTERPRET-WFF `(BE VAR ,FLAGGED-ARG))))
;;   (FOREACH R IN (REMOVE NIL RESULTS) COLLECT (CONS R INTERP)))

(DEFUN INTERPRET-WITH-OF (CONFIG ROLETERM &AUX INTERPS)
  (LET ((INTERP (FIRST CONFIG))
        (SPECS (SECOND CONFIG))
        (MAPPING (THIRD CONFIG)))
    (SETQ INTERPS (WITH-OF-INTERPRETATIONS INTERP ROLETERM))
    (FOREACH I IN INTERPS COLLECT (LIST I SPECS MAPPING))))

;; "[redefined]"
;; (DEFUN WITH-OF-INTERPRETATIONS
;;     (INTERP ROLETERM &AUX RESULTS *VAR-HOST*)
;;   (DECLARE (SPECIAL *VAR-HOST*))
;;   (WHEN *TRACE-SELECTION*
;;     (TRACE-MSG "======================================~%")
;;     (TRACE-MSG "Trying to analyze ~A as Relative Clause.~%" ROLETERM))
;;   (SETQ *VAR-HOST* (REVERSE INTERP))
;;   (SETQ RESULTS
;;         (CASE (CAR ROLETERM)
;;           (OF (LIST (INTERPRET-WFF `(HAVE ,(CADR ROLETERM) VAR))))
;;           (WITH (LIST (INTERPRET-WFF `(HAVE VAR ,(CADR ROLETERM)))))
;;           (WITHOUT
;;            (LIST (INTERPRET-WFF `(NOT HAVE VAR ,(CADR ROLETERM)))))))
;;   (FOREACH R IN (REMOVE NIL RESULTS) COLLECT (CONS R INTERP)))

(DEFUN INTERPRET-COVERTPRED (CONFIG ROLETERM &AUX INTERPS)
  (LET ((INTERP (FIRST CONFIG))
        (SPECS (SECOND CONFIG))
        (MAPPING (THIRD CONFIG)))
    (SETQ INTERPS (COVERTPRED-INTERPRETATIONS INTERP ROLETERM))
    (FOREACH I IN INTERPS COLLECT (LIST I SPECS MAPPING))))

(DEFUN COVERTPRED-INTERPRETATIONS
    (INTERP ROLETERM &AUX RESULTS *VAR-HOST*)
  (DECLARE (SPECIAL *VAR-HOST*))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "======================================~%")
    (TRACE-MSG "Trying to analyze ~A as Relative Clause.~%" ROLETERM))
  (SETQ *VAR-HOST* (REVERSE INTERP))
  (SETQ RESULTS (LIST (INTERPRET-WFF `(COVERT-PRED VAR ,ROLETERM))))
  (FOREACH R IN (REMOVE NIL RESULTS) COLLECT (CONS R INTERP)))

(DEFUN INTERPRET-RN-WFFS (INTERPS WFFS)
  (COND ((NULL WFFS) INTERPS)
        ((SETQ INTERPS (INTERPRET-RN-WFF INTERPS (CAR WFFS)))
         (INTERPRET-RN-WFFS INTERPS (CDR WFFS)))))

(DEFUN INTERPRET-RN-APPOS-WFFS (INTERPS APPOS)
  (COND ((NULL APPOS) INTERPS)
        ((SETQ INTERPS (INTERPRET-RN-APPOS-WFF INTERPS (CAR APPOS)))
         (INTERPRET-RN-APPOS-WFFS INTERPS (CDR APPOS)))))

;; "[redefined]"
;; (DEFUN INTERPRET-RN-WFF (INTERPS WFF &AUX RESULTS *VAR-HOST*)
;;   (DECLARE (SPECIAL *VAR-HOST*))
;;   (FOREACH INTERP IN INTERPS JOIN
;;    (WHEN *TRACE-SELECTION*
;;      (TRACE-MSG "======================================~%")
;;      (TRACE-MSG "Checking relative clause against ~A.~%"
;;       (REVERSE INTERP)))
;;    (SETQ *VAR-HOST* (REVERSE INTERP))
;;    (SETQ RESULTS
;;          (INTERPRET-WFF
;;           (IF (IS-LAMBDA-FORM WFF)
;;               (SIMPLIFY (LIST WFF 'VAR) NIL)
;;             WFF)))
;;    (WHEN RESULTS
;;      (FOREACH R IN
;;       (IF (EQ (CAR RESULTS) 'ONEOF) (CDR RESULTS) (LIST RESULTS))
;;       COLLECT (CONS R INTERP)))))

(DEFUN INTERPRET-RN-APPOS-WFF (INTERPS WFF &AUX RESULTS *VAR-HOST*)
  (DECLARE (SPECIAL *VAR-HOST*))
  (FOREACH INTERP IN INTERPS JOIN
   (WHEN *TRACE-SELECTION*
     (TRACE-MSG "======================================~%")
     (TRACE-MSG "Checking relative clause against ~A.~%"
      (REVERSE INTERP)))
   (SETQ *VAR-HOST* (REVERSE INTERP))
   (SETQ RESULTS
         (INTERPRET-WFF
          (IF (IS-LAMBDA-FORM WFF)
              (SIMPLIFY (LIST WFF 'VAR) NIL)
            WFF)))
   (WHEN RESULTS
     (FOREACH R IN
      (IF (EQ (CAR RESULTS) 'ONEOF) (CDR RESULTS) (LIST RESULTS))
      COLLECT (CONS (CONS 'APPOS R) INTERP)))))

(DEFUN INTERPRET-VING-QUANT (XN &AUX INTERPS *MODIFIER-FORMS*)
  (DECLARE (SPECIAL *TRACE-SELECTION* *MODIFIER-FORMS*))
  (WHEN *TRACE-SELECTION* (TRACE-MSG "Translation = ~A.~%" XN))
  (LET* ((DET (FIRST XN))
         (VAR (SECOND XN))
         (PROG (THIRD XN))
         (PRED (FOURTH XN))
         (NEXT (FIFTH XN))
         (ANSTG (MY-ASSOC 'AN-STG XN))
         (APPOS (MY-ASSOC 'APPOS XN))
         (RN
          (NTHCDR 4
                  (REMOVE APPOS (REMOVE ANSTG XN :TEST #'EQUAL)
                    :TEST #'EQUAL)))
         (FLAGGED-OPERANDS (FLAG-OPERANDS RN))
         (CONFIGS
          (FOREACH SPEC IN (GET PRED 'PRED-FRAME-SPECS) COLLECT
           (LET ((FRAME-NAME (CAR SPEC)) (MAPPING (CDR SPEC)))
             (LIST (LIST (LIST :CLASS FRAME-NAME) PROG VAR DET)
                   (GET FRAME-NAME 'SLOT-SPECS)
                   (GENERATE-PROGRESSIVE-MAPPINGS MAPPING))))))
    (WHEN (AND RN (NOT FLAGGED-OPERANDS))
      (RETURN-FROM INTERPRET-VING-QUANT NIL))
    (SETQ INTERPS
          (REMOVE-DUPLICATES
             (CHECK-NP-MODIFIERS CONFIGS ANSTG RN APPOS)
            :TEST #'EQUAL))
    (WHEN *TRACE-SELECTION*
      (IF INTERPS
          (PP-TRACE-MSG "SIMPTERM interpretations =" INTERPS)
        (TRACE-MSG "No interpretations for ~A.~%" XN)))
    (IF (CDR INTERPS) (CONS 'ONEOF INTERPS) (CAR INTERPS))))

(DEFUN GENERATE-PROGRESSIVE-MAPPINGS (MAPPING &AUX ROLES)
  (COND ((NULL MAPPING) NIL)
        (T
         (SETQ ROLES (CADR MAPPING))
         (PUSHNEW '& ROLES)
         (WHEN (MEMBER 'S ROLES)
           (SETQ ROLES (APPEND '(OF BY GEN) (REMOVE 'S ROLES))))
         (WHEN (MEMBER 'O ROLES)
           (SETQ ROLES (APPEND '(OF GEN AN-STG) (REMOVE 'O ROLES))))
         (WHEN (MEMBER 'IO ROLES) (SETQ ROLES (REMOVE 'IO ROLES)))
         (CONS (CAR MAPPING)
               (CONS ROLES
                     (GENERATE-PROGRESSIVE-MAPPINGS (CDDR MAPPING)))))))