;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/tinsel/preferences.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; ======================================================================

; TINSEL Semantic Preference Functions


(DEFUN APPLY-PREFERENCES ()
  (DECLARE (SPECIAL *PARSELIST*))
  (WHEN (AND (OR *TREE-PRINT-SWITCH* *XN-PRINT-SWITCH*
                 *LF-PRINT-SWITCH*)
             (CDR *PARSELIST*))
    (SETQ I 0)
    (FOREACH PARSE IN *PARSELIST* DO (SETQ I (1+ I))
     (DISPLAY-PARSE PARSE I)))
  (WHEN (OR (CDR *PARSELIST*) (NULL (GET-LF (CAR *PARSELIST*))))
    (FORMAT T "~%Applying preferences...~%")
    (APPLY-MAIN-PREFERENCES)
    (APPLY-ADDITIONAL-PREFERENCES)
    (FORMAT T "~D parse~:P obtained.~%" (LENGTH *PARSELIST*))))

(DEFUN APPLY-MAIN-PREFERENCES ()
  (DELETE-NULL-XNS)
  (DELETE-DUPLICATE-XNS)
  (DELETE-POSTPONED-INTERPS)
  (PREFER-ASSERTION-TO-SFRAGMENT)
  (PREFER-VERBAL-SFRAGMENT-TO-NSTG-SFRAGMENT)
  (PREFER-CONJOINED-SIMILAR-SEMANTICS))
; 5.


;; "[redefined]"
;; (DEFUN APPLY-ADDITIONAL-PREFERENCES () NIL)

(DEFUN DELETE-NULL-XNS ()
  (DECLARE (SPECIAL *PARSELIST*))
  (SETQ *PARSELIST*
        (REMOVE-IF
           #'(LAMBDA (HERE)
               (AND (EQUAL (GET (NODE-NAME HERE) 'SEMANTIC-TYPE)
                           'PREDNODE)
                    (MEMBER 'CONJOMIT (NODE-ATTRIBUTES HERE))
                    (NULL (GETF (NODE-ATTRIBUTES HERE) 'XN))))
           *PARSELIST*)))

(DEFUN DELETE-POSTPONED-INTERPS ()
  (DECLARE (SPECIAL *PARSELIST*))
  (AND (CDR *PARSELIST*)
       (WHEN (FIND-IF #'HAS-INTERP *PARSELIST*)
         (SETQ *PARSELIST* (REMOVE-IF-NOT #'HAS-INTERP *PARSELIST*)))))

(DEFUN DELETE-DUPLICATE-XNS ()
  (DECLARE (SPECIAL *PARSELIST*))
  (SETQ *PARSELIST* (DELETE-DUPE-XNS *PARSELIST*)))

(DEFUN DELETE-DUPE-XNS (PARSES)
  (COND ((NULL PARSES) NIL)
        ((FIND-IF
            #'(LAMBDA (TREE)
                (EQUAL-XN-STRUCTURE (GET-LF (CAR PARSES))
                 (GET-LF TREE)))
            (CDR PARSES))
         (DELETE-DUPE-XNS (CDR PARSES)))
        (T (CONS (CAR PARSES) (DELETE-DUPE-XNS (CDR PARSES))))))

(DEFUN EQUAL-XN-STRUCTURE (X1 X2)
  (COND ((AND (NULL X1) (NULL X2)) T)
        ((AND (ATOM X1) (ATOM X2))
         (IF (IS-VAR X1) (IS-VAR X2) (EQ X1 X2)))
        ((AND (CONSP X1) (CONSP X2))
         (AND (EQUAL-XN-STRUCTURE (CAR X1) (CAR X2))
              (EQUAL-XN-STRUCTURE (CDR X1) (CDR X2))))))

(DEFUN PREFER-ASSERTION-TO-SFRAGMENT ()
  (DECLARE (SPECIAL *PARSELIST*))
  (AND (CDR *PARSELIST*)
       (WHEN (FIND-IF #'IS-ASSERTION *PARSELIST*)
         (SETQ *PARSELIST*
               (REMOVE-IF #'CONTAINS-SFRAGMENT *PARSELIST*)))))

(DEFUN PREFER-VERBAL-SFRAGMENT-TO-NSTG-SFRAGMENT ()
  (DECLARE (SPECIAL *PARSELIST*))
  (AND (CDR *PARSELIST*)
       (WHEN (FIND-IF #'IS-VERBAL-SFRAGMENT *PARSELIST*)
         (SETQ *PARSELIST*
               (REMOVE-IF #'CONTAINS-NSTG-SFRAGMENT *PARSELIST*)))))

(DEFUN IS-ASSERTION (HERE &AUX DAUGHTERS)
  (OR (STARTAT (STARTAT HERE 'CENTER) 'ASSERTION)
      (LET ((CENTER (STARTAT HERE 'CENTER)))
        (AND CENTER (CONSP (SETQ DAUGHTERS (NODE-DAUGHTERS CENTER)))
             (EQUAL (NODE-NAME (FIRST DAUGHTERS)) 'SCOPE-WORD)
             (IS-ASSERTION (SECOND DAUGHTERS))
             (IS-ASSERTION (FOURTH DAUGHTERS))))))

(DEFUN CONTAINS-SFRAGMENT (HERE)
  (OR (STARTAT (STARTAT HERE 'CENTER) 'SFRAGMENT)
      (LET ((DAUGHTERS (NODE-DAUGHTERS (STARTAT HERE 'CENTER))))
        (AND (EQUAL (NODE-NAME (FIRST DAUGHTERS)) 'SCOPE-WORD)
             (OR (CONTAINS-SFRAGMENT (SECOND DAUGHTERS))
                 (CONTAINS-SFRAGMENT (FOURTH DAUGHTERS)))))))

(DEFUN IS-VERBAL-SFRAGMENT (HERE &AUX DAUGHTERS)
  (OR (STARTAT (STARTAT (STARTAT HERE 'CENTER) 'SFRAGMENT) 'S-BE-OBJ)
      (STARTAT (STARTAT (STARTAT HERE 'CENTER) 'SFRAGMENT) 'TVO)
      (LET ((CENTER (STARTAT HERE 'CENTER)))
        (AND CENTER (CONSP (SETQ DAUGHTERS (NODE-DAUGHTERS CENTER)))
             (EQUAL (NODE-NAME (FIRST DAUGHTERS)) 'SCOPE-WORD)
             (IS-VERBAL-SFRAGMENT (SECOND DAUGHTERS))
             (IS-VERBAL-SFRAGMENT (FOURTH DAUGHTERS))))))

(DEFUN CONTAINS-NSTG-SFRAGMENT (HERE &AUX DAUGHTERS)
  (OR (STARTAT (STARTAT (STARTAT HERE 'CENTER) 'SFRAGMENT) 'NSTG)
      (LET ((CENTER (STARTAT HERE 'CENTER)))
        (AND CENTER (CONSP (SETQ DAUGHTERS (NODE-DAUGHTERS CENTER)))
             (EQUAL (NODE-NAME (FIRST DAUGHTERS)) 'SCOPE-WORD)
             (OR (CONTAINS-NSTG-SFRAGMENT (SECOND DAUGHTERS))
                 (CONTAINS-NSTG-SFRAGMENT (FOURTH DAUGHTERS)))))))

(DEFUN PREFER-CONJOINED-SIMILAR-SEMANTICS (&AUX RATED-PARSES HIGHEST)
  (DECLARE (SPECIAL *PARSELIST*))
  (WHEN (AND (CDR *PARSELIST*)
             (CONTAINS-AND (GET-LF (CAR *PARSELIST*))))
    (SETQ RATED-PARSES
          (SORT
             (FOREACH P IN *PARSELIST* COLLECT
              (LIST (SIMILARITY-METRIC P) P))
             #'(LAMBDA (X Y) (< (CAR X) (CAR Y)))))
    (SETQ HIGHEST (CAAR RATED-PARSES))
    (SETQ *PARSELIST*
          (REMOVE NIL
                  (FOREACH R IN RATED-PARSES COLLECT
                   (IF (= (CAR R) HIGHEST) (CADR R)))))))

(DEFUN SIMILARITY-METRIC (TREE)
  (LET ((CONJOINING (CONTAINS-AND (GET-LF TREE))))
    (OR (MIN-LINK-SEPARATION (SECOND CONJOINING) (THIRD CONJOINING))
        99)))

(DEFUN MIN-LINK-SEPARATION (QUANT1 QUANT2)
  (COND ((EQ (CAR QUANT1) 'ONEOF)
         (MIN (MIN-LINK-SEPARATION (SECOND QUANT1) QUANT2)
              (MIN-LINK-SEPARATION (THIRD QUANT1) QUANT2)))
        ((EQ (CAR QUANT2) 'ONEOF)
         (MIN (MIN-LINK-SEPARATION QUANT1 (SECOND QUANT2))
              (MIN-LINK-SEPARATION QUANT1 (THIRD QUANT2))))
        (T
         (LINK-SEPARATION (SECOND (MY-ASSOC :CLASS QUANT1))
          (SECOND (MY-ASSOC :CLASS QUANT2))))))

(DEFUN LINK-SEPARATION (CLASS1 CLASS2)
  (COND ((NULL CLASS2) NIL)
        ((HAS-TYPE CLASS1 CLASS2))
        (T
         (FOREACH CLASS IN (GET CLASS2 'ISA) THEREIS
          (LET ((LINKS (LINK-SEPARATION CLASS1 CLASS)))
            (IF LINKS (RETURN-FROM LINK-SEPARATION (1+ LINKS))))))))

(DEFUN CONTAINS-AND (FORM)
  (COND ((ATOM FORM) NIL)
        ((EQ (CAR FORM) 'AND) FORM)
        (T (OR (CONTAINS-AND (CAR FORM)) (CONTAINS-AND (CDR FORM))))))

(DEFUN GET-LF (HERE) (GETF (NODE-ATTRIBUTES HERE) 'XN))