;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/tinsel/specify.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; SPECIFY code

;;; Ken Wauchope 3/31/94


(DEFUN INTERPRET-OP2-FORM (XN &AUX OPS OP2 ARG1 ARG2)
  (MULTIPLE-VALUE-SETQ (OPS XN) (SKIP-OP1S XN))
  (SETQ OP2 (FIRST XN))
  (SETQ ARG1 (GET-SEMANTICS (ARG1 XN)))
  (WHEN ARG1
    (IF (EQ OP2 'ASKWH)
        (LET ((*VAR-HOST* NIL)
              (*VAR-ROLE* NIL)
              (*VAR-CLASSES* NIL)
              (RESULTS NIL))
          (DECLARE (SPECIAL *VAR-HOST* *VAR-ROLE* *VAR-CLASSES*))
          (IF (IS-ROLETERM ARG1)
              (SETQ *VAR-ROLE* (FIRST ARG1) ARG1 (SECOND ARG1)))
          (SETQ RESULTS
                (FOREACH SEM IN
                 (IF (EQ (CAR ARG1) 'ONEOF) (CDR ARG1) (LIST ARG1))
                 JOIN (SETQ *VAR-HOST* SEM)
                 (WHEN (SETQ ARG2 (GET-SEMANTICS (ARG2 XN)))
                   (COMPOSE-RESULT OP2 SEM ARG2))))
          (WHEN RESULTS
            (IF (CDR RESULTS) (CONS 'ONEOF RESULTS) (CAR RESULTS))))
      (WHEN (SETQ ARG2 (GET-SEMANTICS (ARG2 XN)))
        (LIST OP2 ARG1 ARG2)))))

;; "[redefined]"
;; (DEFUN COMPOSE-RESULT (OP2 SEM ARG2)
;;   (DECLARE (SPECIAL *VAR-ROLE* *VAR-CLASSES*))
;;   (FOREACH VAL IN (IF (EQ (CAR ARG2) 'ONEOF) (CDR ARG2) (LIST ARG2))
;;    JOIN
;;    (LET ((VARCLASSES (FIND-VARCLASSES SEM VAL)))
;;      (IF (AND VARCLASSES (NOT (CDR VARCLASSES)))
;;          (FOREACH V IN VARCLASSES COLLECT
;;           (LET ((S (COPY-TREE SEM)))
;;             (SETF (SECOND (MY-ASSOC :CLASS S)) V)
;;             (LIST OP2 S VAL)))
;;        (LIST (LIST OP2 SEM VAL))))))

(DEFUN COMPOSE-RESULT (OP2 SEM ARG2)
  (DECLARE (SPECIAL *VAR-ROLE* *VAR-CLASSES*))
  (FOREACH VAL IN (IF (EQ (CAR ARG2) 'ONEOF) (CDR ARG2) (LIST ARG2))
   JOIN
   (LET ((VARCLASSES (FIND-VARCLASSES SEM VAL)))
     (FOREACH V IN VARCLASSES COLLECT
      (LET ((S (COPY-TREE SEM)))
        (SETF (SECOND (MY-ASSOC :CLASS S)) V)
        (LIST OP2 S VAL))))))

(DEFUN INTERPRET-RN-WFF
    (INTERPS WFF &AUX RESULTS *VAR-HOST* *VAR-ROLE* *VAR-CLASSES*)
  (DECLARE (SPECIAL *VAR-HOST* *VAR-ROLE* *VAR-CLASSES*
            *TRACE-SELECTION*))
  (FOREACH INTERP IN INTERPS JOIN
   (WHEN *TRACE-SELECTION*
     (TRACE-MSG "======================================~%")
     (TRACE-MSG "Checking relative clause against ~A.~%"
      (REVERSE INTERP)))
   (SETQ *VAR-HOST* (REVERSE INTERP))
   (IF (IS-LAMBDA-FORM WFF) (SETQ WFF (SIMPLIFY (LIST WFF 'VAR) NIL)))
   (SETQ RESULTS (INTERPRET-WFF WFF))
   (WHEN RESULTS
     (SETQ RESULTS
           (IF (EQ (CAR RESULTS) 'ONEOF) (CDR RESULTS) (LIST RESULTS)))
     (FOREACH R IN RESULTS JOIN
      (LET ((VARCLASSES (FIND-VARCLASSES *VAR-HOST* R)))
        (IF (AND VARCLASSES (NOT (CDR VARCLASSES)))
            (FOREACH V IN VARCLASSES COLLECT
             (LET ((NEW-INTERP (COPY-TREE INTERP)))
               (SETF (CADR (MY-ASSOC :CLASS NEW-INTERP)) V)
               (CONS R NEW-INTERP)))
          (LIST (CONS R INTERP))))))))

(DEFUN BE-WFF-INTERPRETATIONS
    (INTERP FLAGGED-ARG &AUX RESULTS *VAR-HOST* *VAR-ROLE*
     *VAR-CLASSES*)
  (DECLARE (SPECIAL *VAR-HOST* *VAR-ROLE* *VAR-CLASSES*
            *TRACE-SELECTION*))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "======================================~%")
    (TRACE-MSG "Trying to analyze ~A as Relative Clause.~%"
     FLAGGED-ARG))
  (SETQ *VAR-HOST* (REVERSE INTERP))
  (SETQ RESULTS (INTERPRET-WFF `(BE VAR ,FLAGGED-ARG)))
  (WHEN RESULTS
    (FOREACH R IN (LIST RESULTS) JOIN
     (LET ((VARCLASSES (FIND-VARCLASSES *VAR-HOST* R)))
       (FOREACH V IN VARCLASSES COLLECT
        (LET ((NEW-INTERP (COPY-TREE INTERP)))
          (SETF (CADR (MY-ASSOC :CLASS NEW-INTERP)) V)
          (CONS R NEW-INTERP)))))))

(DEFUN INTERPRET-LN-ADJ
    (CONFIG ADJ-FORM &AUX INTERP CLAUSE-INTERPS NOM-INTERPS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (SETQ INTERP (FIRST CONFIG))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "======================================~%"))
  (SETQ CLAUSE-INTERPS
        (INTERPRET-RN-WFF (LIST INTERP) `(,@ADJ-FORM VAR)))
  (WHEN CLAUSE-INTERPS
    (SETQ NOM-INTERPS
          (FOREACH R IN CLAUSE-INTERPS COLLECT
           (LIST R (SECOND CONFIG) (THIRD CONFIG)))))
  NOM-INTERPS)

(DEFUN INTERPRET-LN-VING
    (CONFIG VING-FORM &AUX INTERP N-MODIFIER-INTERPS V-MODIFIER-INTERPS
     NOM-INTERPS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (SETQ INTERP (FIRST CONFIG))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "======================================~%")
    (TRACE-MSG "First analyzing as unary adjectival.~%"))
  (SETQ V-MODIFIER-INTERPS
        (INTERPRET-RN-WFF (LIST INTERP) `(,@VING-FORM VAR)))
  (WHEN (NOT V-MODIFIER-INTERPS)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "No noun-modifier interpretations for ~A.~%"
       VING-FORM)
      (TRACE-MSG "======================================~%")
      (TRACE-MSG "Next analyzing as nominal.~%"))
    (SETQ N-MODIFIER-INTERPS (INTERPRET-LN-VING-N CONFIG VING-FORM)))
  (SETQ NOM-INTERPS
        (APPEND N-MODIFIER-INTERPS
                (WHEN V-MODIFIER-INTERPS
                  (FOREACH R IN V-MODIFIER-INTERPS COLLECT
                   (LIST R (SECOND CONFIG) (THIRD CONFIG))))))
  NOM-INTERPS)

(DEFUN WITH-OF-INTERPRETATIONS
    (INTERP ROLETERM &AUX RESULTS *VAR-HOST* *VAR-ROLE*)
  (DECLARE (SPECIAL *TRACE-SELECTION* *VAR-HOST* *VAR-ROLE*))
  (WHEN *TRACE-SELECTION*
    (TRACE-MSG "======================================~%")
    (TRACE-MSG "Trying to analyze ~A as Relative Clause.~%" ROLETERM))
  (SETQ *VAR-HOST* (REVERSE INTERP))
  (SETQ RESULTS
        (CASE (CAR ROLETERM)
          (OF (LIST (INTERPRET-WFF `(HAVE ,(CADR ROLETERM) VAR))))
          (WITH (LIST (INTERPRET-WFF `(HAVE VAR ,(CADR ROLETERM)))))
          (WITHOUT
           (LIST (INTERPRET-WFF `(NOT HAVE VAR ,(CADR ROLETERM)))))))
  (WHEN RESULTS
    (FOREACH R IN (REMOVE NIL RESULTS) JOIN
     (LET ((VARCLASSES (FIND-VARCLASSES *VAR-HOST* R)))
       (FOREACH V IN VARCLASSES COLLECT
        (LET ((NEW-INTERP (COPY-TREE INTERP)))
          (SETF (CADR (MY-ASSOC :CLASS NEW-INTERP)) V)
          (CONS R NEW-INTERP)))))))

(DEFUN INTERPRET-VAR (CONSTRAINT)
  (DECLARE (SPECIAL *VAR-HOST* *VAR-CLASSES*))
  (WHEN (BOUNDP '*VAR-HOST*)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "Host entity for VAR = ~A.~%" *VAR-HOST*))
    (TEST-CONSTRAINT *VAR-HOST* CONSTRAINT)))

(DEFUN TEST-CONSTRAINT (VAL CONSTRAINT &AUX MATCHED-CONSTRAINTS CLASS)
  (COND ((IS-REFLEXIVE-VAR VAL)
         (IF (PASSES-CONSTRAINT
              (SECOND (MY-ASSOC :CLASS (GET-REFLEX-HOST VAL)))
              CONSTRAINT)
             (LIST VAL)))
        ((IS-OP2-FORM VAL) (TEST-OP2-FORM VAL CONSTRAINT))
        ((NUMBERP VAL)
         (IF (PASSES-CONSTRAINT VAL CONSTRAINT) (LIST VAL)))
        ((SETQ CLASS (IS-PARTITIVE-CLASS (TINSEL-CLASS-OF VAL)))
         (LET ((Q-OF-VAL (CADR (MY-ASSOC :Q-OF VAL))))
           (IF Q-OF-VAL (SETQ CLASS (TINSEL-CLASS-OF Q-OF-VAL)))
           (COND ((PASSES-CONSTRAINT CLASS CONSTRAINT) (LIST VAL))
                 (T
                  (SETQ MATCHED-CONSTRAINTS
                        (CONSTRAINT-PASSES CLASS CONSTRAINT))
                  (FOREACH M IN MATCHED-CONSTRAINTS COLLECT
                   (LET ((V (COPY-TREE VAL)))
                     (SETF (CADR (MY-ASSOC :CLASS V)) M)
                     V))))))
        ((PASSES-CONSTRAINT (TINSEL-CLASS-OF VAL) CONSTRAINT)
         (LIST VAL))
        ((SETQ MATCHED-CONSTRAINTS
               (CONSTRAINT-PASSES (TINSEL-CLASS-OF VAL) CONSTRAINT))
         (FOREACH M IN MATCHED-CONSTRAINTS COLLECT
          (LET ((V (COPY-TREE VAL)))
            (SETF (CADR (MY-ASSOC :CLASS V)) M)
            V)))))

(DEFUN PASSES-CONSTRAINT (VALUE-CLASS CONSTRAINT-CLASS)
  (DECLARE (SPECIAL *FRAMES*))
  (COND ((OR (NULL VALUE-CLASS) (NULL CONSTRAINT-CLASS)) NIL)
        ((SYMBOLP CONSTRAINT-CLASS)
         (HAS-TYPE VALUE-CLASS CONSTRAINT-CLASS))
        (T
         (OR (PASSES-CONSTRAINT VALUE-CLASS (CAR CONSTRAINT-CLASS))
             (PASSES-CONSTRAINT VALUE-CLASS (CDR CONSTRAINT-CLASS))))))

(DEFUN CONSTRAINT-PASSES (VALUE-CLASS CONSTRAINT-CLASS)
  (DECLARE (SPECIAL *FRAMES*))
  (COND ((OR (NULL VALUE-CLASS) (NULL CONSTRAINT-CLASS)) NIL)
        ((SYMBOLP CONSTRAINT-CLASS)
         (IF (HAS-TYPE CONSTRAINT-CLASS VALUE-CLASS)
             (LIST CONSTRAINT-CLASS)
           (LET ((SUBCLASSES
                  (FOREACH W IN *FRAMES* JOIN
                   (IF (AND (CDR (GET W 'ISA)) (HAS-TYPE W VALUE-CLASS)
                            (HAS-TYPE W CONSTRAINT-CLASS))
                       (LIST W)))))
             (WHEN SUBCLASSES
               (IF (CDR SUBCLASSES)
                   (LIST CONSTRAINT-CLASS)
                 SUBCLASSES)))))
        (T
         (REMOVE-SUPERCLASSES
          (APPEND (CONSTRAINT-PASSES VALUE-CLASS
                   (CAR CONSTRAINT-CLASS))
                  (CONSTRAINT-PASSES VALUE-CLASS
                   (CDR CONSTRAINT-CLASS)))))))

(DEFUN REMOVE-SUPERCLASSES (LIST)
  (LET ((ITEM (FIRST LIST)) (REST (REST LIST)))
    (COND ((NULL ITEM) NIL)
          ((FIND-IF #'(LAMBDA (ELT) (HAS-TYPE ELT ITEM)) REST)
           (REMOVE-SUPERCLASSES REST))
          (T (CONS ITEM (REMOVE-SUPERCLASSES REST))))))

(DEFUN FIND-VARCLASSES (WH PRED)
  (LET* ((INDEX (SECOND WH))
         (CLASS (SECOND (THIRD WH)))
         (CLASSES (FIND-VARCLASS-SUB INDEX PRED CLASS)))
    (IF (CONSP CLASSES) (REMOVE-DUPLICATES CLASSES) (LIST CLASSES))))

;; "[redefined]"
;; (DEFUN FIND-VARCLASS-SUB (INDEX PRED)
;;   (IF (CONSP PRED)
;;       (COND ((KEYWORDP (FIRST PRED))
;;              (LET ((ARG (OR (THIRD PRED) (SECOND PRED))))
;;                (WHEN (CONSP ARG)
;;                  (COND ((EQ (SECOND ARG) INDEX)
;;                         (PROG1 (LIST (SECOND (MY-ASSOC :CLASS ARG)))
;;                                (SETF (SECOND PRED) INDEX)))
;;                        ((AND (EQ (FIRST ARG) 'ONEOF)
;;                              (EQ (SECOND (SECOND ARG)) INDEX))
;;                         (PROG1 (MAPCAR
;;                                 #'(LAMBDA
;;                                    (X)
;;                                    (SECOND (MY-ASSOC :CLASS X)))
;;                                 (REST ARG))
;;                                (SETF (SECOND PRED) INDEX)))))))
;;             (T
;;              (APPEND (FIND-VARCLASS-SUB INDEX (FIRST PRED))
;;                      (FIND-VARCLASS-SUB INDEX (REST PRED)))))))

(DEFUN FIND-VARCLASS-SUB (INDEX FORM CLASS &AUX ELT)
  (WHEN (CONSP FORM)
    (IF (CONSP (SETQ ELT (FIRST FORM)))
        (COND ((MEMBER INDEX ELT)
               (IF (KEYWORDP (FIRST ELT))
                   CLASS
                 (PROGN (SETF (FIRST FORM) INDEX)
                        (SECOND (MY-ASSOC :CLASS ELT)))))
              ((FIND-VARCLASS-SUB INDEX ELT CLASS))
              (T (FIND-VARCLASS-SUB INDEX (REST FORM) CLASS)))
      (FIND-VARCLASS-SUB INDEX (REST FORM) CLASS))))