;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/tinsel/tinsel.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; ===========================================================================

;

;                             T I N S E L

;                  "Tandem INterpreter for SELection"

;

;     A tandem case-frame semantic interpreter / selection component

;                       for the PROTEUS parser

;

;                          Kenneth Wauchope

;      Navy Center for Applied Research in Artificial Intelligence

;                             Code 5512

;                      Naval Research Laboratory

;                      Washington, DC 20375-5337

;                      wauchope@aic.nrl.navy.mil

;

; ===========================================================================


(DEFMACRO TRACE-MSG (&REST ARGS) `(FORMAT T ,@ARGS))

(SETF (GET 'ONEOF 'LOGICAL-TYPE) 'OP2)

(DEFUN CHECK-SELECTION ()
  (DECLARE (SPECIAL HERE *DO-SELECTION*))
  (IF *DO-SELECTION*
      (SETF (GETF (NODE-ATTRIBUTES HERE) 'XN)
            (BOTTOM-UP-INTERPRET (GETF (NODE-ATTRIBUTES HERE) 'XN)))
    T))

(DEFUN BOTTOM-UP-INTERPRET (XN &AUX NODE-NAME)
  (DECLARE (SPECIAL *TRACE-SELECTION* HERE))
  (SETQ NODE-NAME (NODE-NAME HERE))
  (WHEN (CONSP XN)
    (MULTIPLE-VALUE-SETQ (OPS REST) (SKIP-OP1S XN))
    (WHEN (AND OPS (EQ (FIRST REST) 'ONEOF))
      (SETQ XN
            (CONS (FIRST REST)
                  (FOREACH ARG IN (CDR REST) COLLECT
                   (APPEND OPS ARG))))))
  (COND ((OR (NULL XN) (HAS-SEMANTICS XN)) XN)
        (T
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "*******************************")
           (TRACE-MSG "*******************************~%")
           (TRACE-MSG "Computing interpretation for node ~A.~%"
            NODE-NAME))
         (INTERPRET XN))))

(DEFUN INTERPRET (XN)
  (DECLARE (SPECIAL *PRO-HOST*))
  (COND ((OR (NULL XN) (HAS-SEMANTICS XN)) XN)
        ((HAS-UNINTERPRETED-ADJUNCTS XN)
         (INTERPRET-REMAINING-ADJUNCTS XN))
        ((IS-LAMBDA-FORM XN)
         (COND ((NOT (BOUNDP '*PRO-HOST*))
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG "Translation = ~A.~%" XN)
                  (TRACE-MSG "Postponing until later.~%"))
                XN)
               (T (INTERPRET-LAMBDA-FORM XN))))
        ((IS-OP2-FORM XN) (INTERPRET-OP2-FORM XN))
        ((IS-SIMPLE-WFF XN)
         (COND ((OR (AND (NOT (BOUNDP '*PRO-HOST*)) (MEMBER 'PRO XN))
                    (AND (NOT (BOUNDP '*VAR-HOST*))
                         (CONTAINS-UNBOUND-VAR XN)))
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG "Translation = ~A.~%" XN)
                  (TRACE-MSG "Postponing until later.~%"))
                XN)
               (T (INTERPRET-WFF XN))))
        ((SYMBOLP XN)
         (IF (IS-REFLEXIVE XN)
             (COND ((NOT (BOUNDP '*REFLEX-HOSTS*))
                    (WHEN *TRACE-SELECTION*
                      (TRACE-MSG "Translation = ~A.~%" XN)
                      (TRACE-MSG "Postponing until later.~%"))
                    XN)
                   (T (INTERPRET-REFLEXIVE XN)))
           (INTERPRET-CONSTANT XN)))
        ((IS-EXPANDED-CONSTANT XN) (INTERPRET-EXPANDED-CONSTANT XN))
        ((IS-QUANT XN)
         (COND ((AND (NOT (BOUNDP '*VAR-HOST*))
                     (CONTAINS-UNBOUND-RN-VAR XN))
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG "Translation = ~A.~%" XN)
                  (TRACE-MSG "Postponing until later.~%"))
                XN)
               ((AND (NOT (BOUNDP '*REFLEX-HOSTS*))
                     (CONTAINS-UNBOUND-RN-REFLEX XN))
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG "Translation = ~A.~%" XN)
                  (TRACE-MSG "Postponing until later.~%"))
                XN)
               (T (INTERPRET-QUANT XN))))
        ((IS-VING-QUANT XN)
         (COND ((AND (NOT (BOUNDP '*VAR-HOST*))
                     (CONTAINS-UNBOUND-RN-VAR XN))
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG "Translation = ~A.~%" XN)
                  (TRACE-MSG "Postponing until later.~%"))
                XN)
               (T (INTERPRET-VING-QUANT XN))))
        ((IS-ROLETERM XN) (LIST (FIRST XN) (INTERPRET (SECOND XN))))
        (T
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "***UNRECOGNIZED FORM: ~A.~%" XN)))))

(DEFUN GET-SEMANTICS (XN)
  (COND ((OR (NULL XN) (HAS-SEMANTICS XN)) XN)
        (T (TOP-DOWN-INTERPRET XN))))

(DEFUN TOP-DOWN-INTERPRET (XN)
  (PROG2 (WHEN *TRACE-SELECTION*
           (TRACE-MSG
            "This term does not yet have an interpretation: ~A.~%" XN)
           (TRACE-MSG "==> Pushing to interpret term.~%"))
         (INTERPRET XN)
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "<== Popping from interpreting operand.~%"))))

(DEFUN HAS-SEMANTICS (FORM)
  (OR (NUMBERP FORM) (STRINGP FORM) (IS-VARIABLE FORM)
      (IS-REFLEXIVE FORM) (IS-VAR FORM) (IS-REFLEXIVE-VAR FORM)
      (AND (IS-ONEOF-INTERP FORM) (HAS-SEMANTICS (SECOND FORM))
           (HAS-SEMANTICS (THIRD FORM)))
      (AND (IS-OP2-FORM FORM) (HAS-SEMANTICS (ARG1 FORM))
           (HAS-SEMANTICS (ARG2 FORM)))
      (AND (CONSP FORM) (MY-ASSOC :CLASS FORM) (NOT (MEMBER 'VAR FORM))
           (NOT (MY-ASSOC 'S-A FORM)))))
;[2]


(DEFUN HAS-UNINTERPRETED-ADJUNCTS (FORM)
  (AND (CONSP FORM) (MY-ASSOC :CLASS FORM) (MY-ASSOC 'S-A FORM)))

(DEFUN INTERPRET-REMAINING-ADJUNCTS (WFF &AUX INTERP INTERPS SA)
  (SETQ INTERP
        (REVERSE (REMOVE (SETQ SA (MY-ASSOC 'S-A WFF)) WFF
                   :TEST #'EQUAL)))
  (SETQ INTERPS
        (FOREACH I IN (INTERPRET-ADJUNCTS (LIST INTERP) (CDR SA))
         COLLECT (REVERSE I)))
  (IF (CDR INTERPS) (CONS 'ONEOF INTERPS) (CAR INTERPS)))

(DEFUN MY-ASSOC (ITEM LIST)
  (FIND-IF #'(LAMBDA (X) (AND (CONSP X) (EQ (CAR X) ITEM))) LIST))

(DEFUN CONTAINS-UNBOUND-VAR (WFF)
  (WHEN (IS-LAMBDA-FORM WFF) (SETQ WFF (SIMPLIFY (CADDR WFF) NIL)))
  (OR (FOREACH OPERAND IN WFF THEREIS
       (OR (EQ OPERAND 'VAR)
           (AND (IS-ROLETERM OPERAND) (EQ (SECOND OPERAND) 'VAR))
           (AND (IS-SATERM OPERAND)
                (FOREACH ARG IN (CDR OPERAND) THEREIS
                 (OR (EQ ARG 'VAR)
                     (AND (IS-ROLETERM ARG)
                          (EQ (SECOND ARG) 'VAR)))))))
      (LET ((OBJECT (GET-OBJECT WFF)))
        (OR (AND (IS-WFF OBJECT) (CONTAINS-UNBOUND-VAR OBJECT))
            (AND (OR (IS-QUANT OBJECT) (IS-VING-QUANT OBJECT))
                 (CONTAINS-UNBOUND-RN-VAR OBJECT))))))

(DEFUN CONTAINS-UNBOUND-RN-VAR (QUANT)
  (FOREACH OPERAND IN QUANT THEREIS
   (AND (IS-ROLETERM OPERAND) (EQ (FIRST OPERAND) 'OF)
        (OR (EQ (SECOND OPERAND) 'VAR)
            (AND (OR (IS-QUANT (SECOND OPERAND))
                     (IS-VING-QUANT (SECOND OPERAND)))
                 (CONTAINS-UNBOUND-RN-VAR (SECOND OPERAND)))))))

(DEFUN CONTAINS-UNBOUND-RN-REFLEX (QUANT)
  (FOREACH OPERAND IN QUANT THEREIS
   (AND (IS-ROLETERM OPERAND)
        (OR (IS-REFLEXIVE (SECOND OPERAND))
            (AND (OR (IS-QUANT (SECOND OPERAND))
                     (IS-VING-QUANT (SECOND OPERAND)))
                 (CONTAINS-UNBOUND-RN-REFLEX (SECOND OPERAND)))))))

(DEFUN GET-SUBJECT (WFF &AUX OPS REST)
  (MULTIPLE-VALUE-SETQ (OPS REST) (SKIP-OP1S WFF))
  (IF (IS-SIMPTERM-OR-WFF (SECOND REST)) (SECOND REST)))

(DEFUN GET-OBJECT (WFF &AUX OPS REST)
  (MULTIPLE-VALUE-SETQ (OPS REST) (SKIP-OP1S WFF))
  (IF (IS-SIMPTERM-OR-WFF (FOURTH REST)) (FOURTH REST) (THIRD REST)))

(DEFUN INTERPRET-WFF
    (XN &AUX CONFIGS OPS FORM PRED FLAGGED-OPERANDS *MODIFIER-FORMS*
     *D-FORMS* *REFLEX-HOSTS* INTERPS)
  (DECLARE (SPECIAL *MODIFIER-FORMS* *D-FORMS* *TRACE-SELECTION*
            *REFLEX-HOSTS*))
  (WHEN *TRACE-SELECTION* (TRACE-MSG "Translation = ~A.~%" XN))
  (COND ((IS-OP2-FORM XN) (INTERPRET-OP2-FORM XN))
        ((IS-SIMPLE-WFF XN)
         (MULTIPLE-VALUE-SETQ (OPS FORM) (SKIP-OP1S XN))
         (SETQ PRED (CAR FORM)
               FLAGGED-OPERANDS (FLAG-OPERANDS (CDR FORM)))
         (WHEN (AND (CDR FORM) (NOT FLAGGED-OPERANDS))
           (RETURN-FROM INTERPRET-WFF NIL))
         (SETQ CONFIGS
               (FOREACH SPEC IN (GET PRED 'PRED-FRAME-SPECS) COLLECT
                (MAKE-WFF-FRAME-CONFIG SPEC OPS)))
         (SETQ INTERPS (INTERPRET-OPERANDS CONFIGS FLAGGED-OPERANDS))
         (WHEN (AND INTERPS *MODIFIER-FORMS*)
           (SETQ INTERPS
                 (INTERPRET-ADJUNCTS INTERPS *MODIFIER-FORMS*)))
         (WHEN (AND INTERPS *D-FORMS*)
           (SETQ INTERPS
                 (FOREACH I IN INTERPS COLLECT (APPEND *D-FORMS* I))))
         (SETQ INTERPS (FOREACH I IN INTERPS COLLECT (REVERSE I)))
         (WHEN *TRACE-SELECTION*
           (COND (INTERPS
                  (PP-TRACE-MSG "WFF interpretations =" INTERPS))
                 (T (TRACE-MSG "No interpretations for ~A.~%" XN))))
         (IF (CDR INTERPS) (CONS 'ONEOF INTERPS) (CAR INTERPS)))))

(DEFUN MAKE-WFF-FRAME-CONFIG (SPEC OPS)
  (LET ((FRAME-NAME (CAR SPEC)) (MAPPING (CDR SPEC)))
    (LIST (CONS (LIST :CLASS FRAME-NAME) (CONS (MAKE-VP-INDEX) OPS))
          (GET FRAME-NAME 'SLOT-SPECS) MAPPING)))
; mapping


(DEFUN MAKE-VP-INDEX () (GENSYM "V"))

(DEFUN IS-UNMARKED-OPERAND (OP)
  (AND OP (OR (HAS-SEMANTICS OP) (IS-SIMPTERM-OR-WFF OP))
       (NOT (IS-ROLETERM-VARIABLE OP))))

(DEFUN FLAG-OPERANDS
    (ARGS &AUX NEXT SUBJECT OBJECT DOBJECT IOBJECT SUBJECT-SEMS
     DOBJECT-SEMS IOBJECT-SEMS FLAGGED-INNER-ARGS NOT-FORM)
  (DECLARE (SPECIAL *MODIFIER-FORMS* *D-FORMS* *TRACE-SELECTION*
            *VAR-ROLE*))
  (WHEN ARGS
    (SETQ NEXT (CAR ARGS))
    (WHEN (IS-UNMARKED-OPERAND NEXT)
      (SETQ SUBJECT NEXT ARGS (CDR ARGS) NEXT (CAR ARGS))
      (WHEN (IS-UNMARKED-OPERAND NEXT)
        (SETQ OBJECT NEXT ARGS (CDR ARGS) NEXT (CAR ARGS))
        (IF (IS-UNMARKED-OPERAND NEXT)
            (SETQ IOBJECT OBJECT DOBJECT (CAR ARGS) ARGS (CDR ARGS))
          (SETQ DOBJECT OBJECT))))
    (FOREACH A IN ARGS DO
     (COND ((IS-SATERM A)
            (FOREACH ARG IN (CDR A) DO
             (IF (IS-ROLETERM ARG)
                 (PUSH (LIST (CAR ARG) (GET-SEMANTICS (CADR ARG)))
                       *MODIFIER-FORMS*)
               (IF (IS-ROLETERM-VARIABLE ARG)
                   (PUSH (LIST *VAR-ROLE* ARG) *MODIFIER-FORMS*)
                 (PUSH ARG *D-FORMS*)))))
           ((IS-ROLETERM A)
            (PUSH (LIST (CAR A) (GET-SEMANTICS (CADR A)))
                  FLAGGED-INNER-ARGS))
           ((IS-ROLETERM-VARIABLE A)
            (PUSH (LIST *VAR-ROLE* (GET-SEMANTICS A))
                  FLAGGED-INNER-ARGS))
           ((IS-LAMBDA-FORM A)
            (WHEN *TRACE-SELECTION*
              (TRACE-MSG "NOTE: LAMBDA IN POST-OBJECT POSITION.~%")))
           ((IS-ADVERBIAL-FORM A) (PUSH A *D-FORMS*))
           (T
            (WHEN *TRACE-SELECTION*
              (TRACE-MSG "***UNRECOGNIZED OPERAND: ~A.~%" A))
            (RETURN-FROM FLAG-OPERANDS NIL))))
    (WHEN SUBJECT (SETQ SUBJECT-SEMS (GET-SEMANTICS SUBJECT)))
    (WHEN IOBJECT (SETQ IOBJECT-SEMS (GET-SEMANTICS IOBJECT)))
    (WHEN DOBJECT
      (SETQ DOBJECT-SEMS
            (IF (IS-WFF DOBJECT)
                DOBJECT
              (IF (AND (IS-QUANT DOBJECT)
                       (CONTAINS-UNBOUND-RN-REFLEX DOBJECT))
                  DOBJECT
                (GET-SEMANTICS DOBJECT)))))
    (APPEND (WHEN SUBJECT (LIST (LIST 'S SUBJECT-SEMS))) NOT-FORM
            (WHEN IOBJECT (LIST (LIST 'IO IOBJECT-SEMS)))
            (WHEN DOBJECT (LIST (LIST 'O DOBJECT-SEMS)))
            (REVERSE FLAGGED-INNER-ARGS))))

(DEFUN INTERPRET-LAMBDA-FORM (FORM)
  (INTERPRET-WFF (SIMPLIFY (LIST FORM 'PRO) NIL)))

(DEFUN INTERPRET-OPERANDS (CONFIGS FLAGGED-OPERANDS)
  (DECLARE (SPECIAL *TRACE-SELECTION* *REFLEX-HOSTS*))
  (DO* ((OPERANDS FLAGGED-OPERANDS (CDR OPERANDS))
        (OPERAND (CAR OPERANDS) (CAR OPERANDS)))
       ((COND ((NULL CONFIGS) (RETURN NIL))
              ((NULL OPERANDS)
               (WHEN *TRACE-SELECTION*
                 (TRACE-MSG "--------------------------------------~%")
                 (TRACE-MSG "All operands have been matched.~%"))
               (RETURN (REMOVE NIL
                               (FOREACH
                                C
                                IN
                                CONFIGS
                                COLLECT
                                (IF
                                 (UNFILLED-OBLIGATORY-CASE
                                  (REVERSE (FIRST C))
                                  (THIRD C))
                                 NIL
                                 (FIRST C))))))))
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "--------------------------------------~%")
      (TRACE-MSG "Checking argument = ~A.~%" OPERAND))
    (UNLESS (HAS-SEMANTICS (SECOND OPERAND))
      (SETQ OPERAND
            (LIST (FIRST OPERAND) (GET-SEMANTICS (SECOND OPERAND)))))
    (SETQ CONFIGS
          (COND ((AND (IS-PRO-CONTAINING-WFF
                       (SECOND (SECOND OPERANDS)))
                      (IS-ONEOF-INTERP (SECOND OPERAND)))
                 (FOREACH C IN CONFIGS JOIN
                  (FOREACH TERM IN (CDR (SECOND OPERAND)) JOIN
                   (INTERPRET-ARG C (LIST (CAR OPERAND) TERM)))))
                (T
                 (FOREACH C IN CONFIGS JOIN
                  (INTERPRET-ARG C OPERAND)))))
    (WHEN (AND *TRACE-SELECTION* (NOT CONFIGS))
      (TRACE-MSG "No role for ~A.~%" OPERAND))))

(DEFUN IS-PRO-CONTAINING-WFF (TERM)
  (AND (IS-WFF TERM) (MEMBER 'PRO TERM)))

(DEFUN UNFILLED-OBLIGATORY-CASE (INTERP SLOT-SPECS)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (COND ((NULL SLOT-SPECS) NIL)
        ((NOT (MEMBER '& (CADR SLOT-SPECS)))
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "Rejecting ~A:~%" INTERP)
           (TRACE-MSG "   the obligatory role ~A remains unfilled.~%"
            (CAR SLOT-SPECS)))
         T)
        (T (UNFILLED-OBLIGATORY-CASE INTERP (CDDR SLOT-SPECS)))))

(DEFUN INTERPRET-ARG (CONFIG FLAGGED-ARG)
  (DECLARE (SPECIAL *VAR-HOST* *PRO-HOST* *REFLEX-HOSTS*))
  (LET* ((INTERP (FIRST CONFIG))
         (FRAME-SPEC (SECOND CONFIG))
         (MAPPINGS (THIRD CONFIG))
         (ROLE (FIRST FLAGGED-ARG))
         (POSSIBLE-ROLES (POSSIBLE-INNER-ROLES ROLE MAPPINGS))
         (VALUES (SECOND FLAGGED-ARG))
         (PREVIOUS-OPERAND-VALUE
          (IF (AND (CONSP (CAR INTERP)) (KEYWORDP (CAAR INTERP))
                   (NOT (EQUAL (CAAR INTERP) :CLASS)))
              (CADAR INTERP))))
    (WHEN (AND *TRACE-SELECTION* MAPPINGS)
      (TRACE-MSG "/// Using mapping ~A ///~%" MAPPINGS))
    (WHEN (IS-WFF VALUES)
      (LET ((*PRO-HOST*
             (IF (IS-VAR PREVIOUS-OPERAND-VALUE)
                 (IF (BOUNDP '*VAR-HOST*) *VAR-HOST* *PRO-HOST*)
               PREVIOUS-OPERAND-VALUE)))
        (DECLARE (SPECIAL *PRO-HOST*))
        (SETQ VALUES (GET-SEMANTICS VALUES))))
    (WHEN VALUES
      (WHEN (IF (MEMBER 'PASSIVE CONFIG) (EQ ROLE 'O) (EQ ROLE 'S))
        (UNLESS (EQ VALUES 'PRO) (SETQ *SA-PRO-HOST* VALUES)))
      (INNER-ROLE-INTERPRETATIONS INTERP FRAME-SPEC POSSIBLE-ROLES
       MAPPINGS VALUES))))

(DEFUN INNER-ROLE-INTERPRETATIONS
    (INTERP FRAME-SPEC POSSIBLE-ROLES MAPPINGS VALUES)
  (DECLARE (SPECIAL *REFLEX-HOSTS*))
  (COND ((NULL POSSIBLE-ROLES) NIL)
        (T
         (LET* ((ROLE (CAR POSSIBLE-ROLES))
                (NEW-INTERP
                 (CAN-FILL-ROLE INTERP FRAME-SPEC ROLE VALUES)))
           (IF NEW-INTERP
               (PROGN (WHEN (BOUNDP '*REFLEX-HOSTS*)
                        (LET ((HOST (SECOND (FIRST NEW-INTERP))))
                          (PUSHNEW HOST *REFLEX-HOSTS*)))
                      (CONS (LIST NEW-INTERP FRAME-SPEC
                                  (REMAINING-MAPPINGS ROLE MAPPINGS))
                            (INNER-ROLE-INTERPRETATIONS INTERP
                             FRAME-SPEC (CDR POSSIBLE-ROLES) MAPPINGS
                             VALUES)))
             (INNER-ROLE-INTERPRETATIONS INTERP FRAME-SPEC
              (CDR POSSIBLE-ROLES) MAPPINGS VALUES))))))

(DEFUN REMAINING-MAPPINGS (ROLE MAPPINGS)
  (COND ((NULL MAPPINGS) NIL)
        ((EQ ROLE (CAR MAPPINGS)) (CDDR MAPPINGS))
        (T
         (CONS (CAR MAPPINGS)
               (CONS (CADR MAPPINGS)
                     (REMAINING-MAPPINGS ROLE (CDDR MAPPINGS)))))))

(DEFUN POSSIBLE-INNER-ROLES (FLAG MAPPINGS)
  (COND ((NULL MAPPINGS) NIL)
        ((MEMBER FLAG (CADR MAPPINGS))
         (CONS (CAR MAPPINGS)
               (POSSIBLE-INNER-ROLES FLAG (CDDR MAPPINGS))))
        (T (POSSIBLE-INNER-ROLES FLAG (CDDR MAPPINGS)))))

(DEFUN CAN-FILL-ROLE (INTERP FRAME-SPEC SLOTNAME VALUES)
  (WHEN (GETF FRAME-SPEC SLOTNAME)
    (MEETS-CONSTRAINT (GETF FRAME-SPEC SLOTNAME) VALUES
     (TINSEL-CLASS-OF INTERP) SLOTNAME INTERP)))

(DEFUN MEETS-CONSTRAINT
    (CONSTRAINT VALUES CLASS SLOTNAME INTERP &AUX NEW-INTERP OK-VALUES)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (COND ((NOT (MY-ASSOC SLOTNAME INTERP))
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "Trying ~A slot of predicate ~A.~%" SLOTNAME
            CLASS)
           (TRACE-MSG "Type constraint on slot is ~A.~%" CONSTRAINT)
           (TRACE-MSG "Values being tested = ~A.~%" VALUES))
         (SETQ OK-VALUES
               (COND ((EQUAL VALUES 'VAR) (INTERPRET-VAR CONSTRAINT))
                     ((EQUAL VALUES 'PRO) (INTERPRET-PRO CONSTRAINT))
                     ((IS-REFLEXIVE VALUES)
                      (FOREACH VAL IN (INTERPRET-REFLEXIVE VALUES) JOIN
                       (TEST-CONSTRAINT VAL CONSTRAINT)))
                     ((SYMBOLP VALUES)
                      (LET ((VALS (INTERPRET-CONSTANT VALUES)))
                        (WHEN VALS
                          (FOREACH VAL IN
                           (IF (EQ (CAR VALS) 'ONEOF)
                               (CDR VALS)
                             (LIST VALS))
                           JOIN (TEST-CONSTRAINT VAL CONSTRAINT)))))
                     ((OR (STRINGP VALUES) (NUMBERP VALUES))
                      (IF (FINDIF-TYPEP VALUES CONSTRAINT)
                          (LIST VALUES)))
                     ((EQ (CAR VALUES) 'ONEOF)
                      (FOREACH VAL IN (CDR VALUES) JOIN
                       (TEST-CONSTRAINT VAL CONSTRAINT)))
                     (T (TEST-CONSTRAINT VALUES CONSTRAINT))))
         (COND (OK-VALUES
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG
                   "Values that passed type constraint = ~A.~%"
                   OK-VALUES))
                (SETQ OK-VALUES
                      (IF (CDR OK-VALUES)
                          (CONS 'ONEOF OK-VALUES)
                        (CAR OK-VALUES)))
                (SETQ NEW-INTERP
                      (CONS (LIST SLOTNAME OK-VALUES) INTERP))
                NEW-INTERP)
               (T
                (WHEN *TRACE-SELECTION*
                  (TRACE-MSG "Item failed type constraint.~%")))))
        (T
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "inner role ~A has already been filled.~%"
            SLOTNAME)))))

(DEFUN FINDIF-TYPEP (VALUES CONSTRAINT)
  (LET ((CONS (IF (CONSP CONSTRAINT) CONSTRAINT (LIST CONSTRAINT))))
    (FIND-IF
       #'(LAMBDA (CON)
           (AND (MEMBER CON '(STRING FIXNUM NUMBER RATIO))
                (TYPEP VALUES CON)))
       CONS)))

;; "[redefined]"
;; (DEFUN INTERPRET-VAR (CONSTRAINT)
;;   (DECLARE (SPECIAL *VAR-HOST*))
;;   (WHEN (BOUNDP '*VAR-HOST*)
;;     (WHEN *TRACE-SELECTION*
;;       (TRACE-MSG "Host entity for VAR = ~A.~%" *VAR-HOST*))
;;     (IF (TEST-CONSTRAINT *VAR-HOST* CONSTRAINT)
;;         (LIST (GET-ID *VAR-HOST*)))))

(DEFUN INTERPRET-PRO (CONSTRAINT)
  (DECLARE (SPECIAL *PRO-HOST*))
  (WHEN (BOUNDP '*PRO-HOST*)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "Host entity for PRO = ~A.~%" *PRO-HOST*))
    (AND (CONSP *PRO-HOST*)
         (FOREACH V IN
          (IF (EQ (CAR *PRO-HOST*) 'ONEOF)
              (CDR *PRO-HOST*)
            (LIST *PRO-HOST*))
          JOIN (IF (TEST-CONSTRAINT V CONSTRAINT) (LIST (GET-ID V)))))))

(DEFUN GET-VAR-HOSTS ()
  (DECLARE (SPECIAL *VAR-HOST*))
  (WHEN (BOUNDP '*VAR-HOST*)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "Host entity for VAR = ~A.~%" *VAR-HOST*))
    (IF (EQ (CAR *VAR-HOST*) 'ONEOF)
        (CDR *VAR-HOST*)
      (LIST *VAR-HOST*))))

(DEFUN GET-PRO-HOSTS ()
  (DECLARE (SPECIAL *PRO-HOST*))
  (WHEN (BOUNDP '*PRO-HOST*)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "Host entity for PRO = ~A.~%" *PRO-HOST*))
    (AND (CONSP *PRO-HOST*)
         (IF (EQ (CAR *PRO-HOST*) 'ONEOF)
             (CDR *PRO-HOST*)
           (LIST *PRO-HOST*)))))

(DEFUN INTERPRET-REFLEXIVE (PRO &AUX RESULT)
  (DECLARE (SPECIAL *REFLEX-HOSTS*))
  (WHEN (BOUNDP '*REFLEX-HOSTS*)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "Translation = ~A.~%" PRO)
      (TRACE-MSG "Reflex hosts = ~A.~%" *REFLEX-HOSTS*))
    (LET* ((FIRST-HOST (FIRST *REFLEX-HOSTS*))
           (FIRST-HOST-ID (REFLEX-MATCHES-HOST PRO FIRST-HOST))
           (FIRST-HOST-CLASS
            (IF (EQ (FIRST FIRST-HOST) 'AND)
                (THIRD (SECOND FIRST-HOST))
              (THIRD FIRST-HOST)))
           (SECOND-HOST (SECOND *REFLEX-HOSTS*))
           (SECOND-HOST-ID (REFLEX-MATCHES-HOST PRO SECOND-HOST)))
      (WHEN FIRST-HOST-ID
        (IF (EQ PRO 'EACH-OTHER)
            (PUSH `(PRON ,(MAKE-NP-INDEX) ,FIRST-HOST-CLASS ,PRO)
                  RESULT)
          (PUSH FIRST-HOST RESULT)))
      (WHEN SECOND-HOST-ID (PUSH SECOND-HOST RESULT))
      (WHEN *TRACE-SELECTION*
        (TRACE-MSG "Interpretation = ~A.~%" RESULT))
      RESULT)))

(DEFUN INTERPRET-REFLEXIVE (PRO &AUX RESULT)
  (DECLARE (SPECIAL *REFLEX-HOSTS*))
  (WHEN (BOUNDP '*REFLEX-HOSTS*)
    (WHEN *TRACE-SELECTION*
      (TRACE-MSG "Translation = ~A.~%" PRO)
      (TRACE-MSG "Reflex hosts = ~A.~%" *REFLEX-HOSTS*))
    (LET* ((FIRST-HOST (FIRST *REFLEX-HOSTS*))
           (FIRST-MATCH (REFLEX-MATCHES-HOST PRO FIRST-HOST))
           (FIRST-HOST-ID
            (UNLESS (MEMBER (FIRST FIRST-MATCH) '(AND OR))
              (SECOND FIRST-MATCH)))
           (FIRST-HOST-CLASS
            (IF (MEMBER (FIRST FIRST-MATCH) '(AND OR))
                (THIRD (SECOND FIRST-MATCH))
              (THIRD FIRST-MATCH)))
           (SECOND-HOST (SECOND *REFLEX-HOSTS*))
           (SECOND-MATCH (REFLEX-MATCHES-HOST PRO SECOND-HOST))
           (SECOND-HOST-ID
            (UNLESS (MEMBER (FIRST SECOND-MATCH) '(AND OR))
              (SECOND SECOND-MATCH)))
           (SECOND-HOST-CLASS
            (IF (MEMBER (FIRST SECOND-MATCH) '(AND OR))
                (THIRD (SECOND SECOND-MATCH))
              (THIRD SECOND-MATCH))))
      (WHEN FIRST-MATCH
        (PUSH `(PRON ,FIRST-HOST-ID ,FIRST-HOST-CLASS ,PRO) RESULT))
      (WHEN SECOND-MATCH
        (PUSH `(PRON ,SECOND-HOST-ID ,SECOND-HOST-CLASS ,PRO) RESULT))
      (WHEN *TRACE-SELECTION*
        (TRACE-MSG "Interpretation = ~A.~%" RESULT))
      RESULT)))

(DEFUN GET-REFLEX-HOST (ID)
  (DECLARE (SPECIAL *REFLEX-HOSTS* *PRO-HOST* *VAR-HOST*))
  (WHEN (IS-REFLEXIVE-VAR ID) (SETQ ID (SECOND ID)))
  (OR (FIND-IF
         #'(LAMBDA (FORM) (AND (CONSP FORM) (EQ (SECOND FORM) ID)))
         *REFLEX-HOSTS*)
      (IF (BOUNDP '*PRO-HOST*)
          (IF (EQ (SECOND *PRO-HOST*) ID) *PRO-HOST*))
      (IF (BOUNDP '*VAR-HOST*)
          (IF (EQ (SECOND *VAR-HOST*) ID) *VAR-HOST*))))

(DEFUN REFLEX-MATCHES-HOST (PRO HOST)
  (DECLARE (SPECIAL *PRO-HOST* *REFLEX-HOSTS*))
  (WHEN (IS-VAR HOST)
    (IF (BOUNDP '*PRO-HOST*)
        (SETQ HOST *PRO-HOST*)
      (SETQ HOST (GET-REFLEX-HOST HOST))))
  (AND HOST (REFLEX-CLASS-MATCHES PRO HOST)
       (REFLEX-NUMBER-MATCHES PRO HOST)
       (REFLEX-GENDER-MATCHES PRO HOST) HOST))

(DEFUN IS-PRON-FORM (FORM) (AND (CONSP FORM) (EQ (FIRST FORM) 'PRON)))

(DEFUN REFLEX-CLASS-MATCHES (PRO HOST)
  (CASE PRO
    ((YOURSELF YOURSELVES) (EQ (FOURTH HOST) 'YOU))
    (OURSELVES (MEMBER (FOURTH HOST) '(WE US)))
    (MYSELF (MEMBER (FOURTH HOST) '(ME I)))
    ((HIMSELF HERSELF THEMSELVES EACH-OTHER)
     (IF (IS-PRON-FORM HOST)
         (MEMBER (FOURTH HOST) '(HIM HER HE SHE THEY THEM YOU))
       (TEST-CONSTRAINT HOST (FIRST (GET PRO 'CONSTANT-FRAMES)))))
    (ITSELF
     (IF (IS-PRON-FORM HOST)
         (EQ (FOURTH HOST) 'IT)
       (TEST-CONSTRAINT HOST (FIRST (GET PRO 'CONSTANT-FRAMES)))))))

(DEFUN REFLEX-NUMBER-MATCHES (PRO HOST)
  (LET ((HOSTNUM (FOURTH HOST)))
    (IF (IS-SINGULAR-REFLEXIVE PRO)
        (OR (EQ (FIRST HOST) 'NAME) (EQ (FIRST HOST) 'OR)
            (EQ HOSTNUM 'SINGULAR) (IS-SINGULAR-PRO HOSTNUM))
      (IF (IS-PLURAL-REFLEXIVE PRO)
          (OR (EQ (FIRST HOST) 'AND) (EQ HOSTNUM 'PLURAL)
              (IS-PLURAL-PRO HOSTNUM))))))

(DEFUN REFLEX-GENDER-MATCHES (PRO HOST)
  (LET ((HOSTNUM (FOURTH HOST)))
    (IF (EQ PRO 'HIMSELF)
        (NOT (MEMBER HOSTNUM '(SHE HER)))
      (IF (EQ PRO 'HERSELF) (NOT (MEMBER HOSTNUM '(HE HIM))) T))))

;; "[redefined]"
;; (DEFUN TEST-CONSTRAINT (VAL CONSTRAINT &AUX CLASS PCLASS)
;;   (COND ((OR (IS-VAR VAL) (IS-REFLEXIVE-VAR VAL))
;;          (IF (PASSES-CONSTRAINT
;;               (SECOND (MY-ASSOC :CLASS (GET-REFLEX-HOST VAL)))
;;               CONSTRAINT)
;;              (LIST VAL)))
;;         ((IS-OP2-FORM VAL)
;;          (IF (STRINGP (SECOND VAL))
;;              (AND (TEST-CONSTRAINT (SECOND VAL) CONSTRAINT)
;;                   (TEST-CONSTRAINT (THIRD VAL) CONSTRAINT))
;;            (TEST-OP2-FORM VAL CONSTRAINT)))
;;         ((NUMBERP VAL)
;;          (IF (PASSES-CONSTRAINT VAL CONSTRAINT) (LIST VAL)))
;;         ((STRINGP VAL) (IF (FINDIF-TYPEP VAL CONSTRAINT) (LIST VAL)))
;;         ((PASSES-CONSTRAINT (TINSEL-CLASS-OF VAL) CONSTRAINT)
;;          (LIST VAL))))

(DEFUN IS-PARTITIVE-CLASS (CLASS) (GETF (GET CLASS 'SLOT-SPECS) :Q-OF))

(DEFUN TEST-OP2-FORM
    (VAL CONSTRAINT &AUX FILLER VALS ARG1-VALS ARG2-VALS)
  (SETQ FILLER (ARG1 VAL)
        VALS
        (IF (AND (CONSP FILLER) (EQ (CAR FILLER) 'ONEOF))
            (CDR FILLER)
          (LIST FILLER))
        ARG1-VALS
        (FOREACH V IN VALS JOIN (TEST-CONSTRAINT V CONSTRAINT)))
  (WHEN ARG1-VALS
    (SETQ FILLER (ARG2 VAL)
          VALS
          (IF (AND (CONSP FILLER) (EQ (CAR FILLER) 'ONEOF))
              (CDR FILLER)
            (LIST FILLER))
          ARG2-VALS
          (FOREACH V IN VALS JOIN (TEST-CONSTRAINT V CONSTRAINT)))
    (WHEN ARG2-VALS
      (LIST (LIST (FIRST VAL)
                  (IF (CDR ARG1-VALS)
                      (CONS 'ONEOF ARG1-VALS)
                    (CAR ARG1-VALS))
                  (IF (CDR ARG2-VALS)
                      (CONS 'ONEOF ARG2-VALS)
                    (CAR ARG2-VALS)))))))

(DEFUN TINSEL-CLASS-OF (INTERP)
  (DECLARE (SPECIAL *VAR-HOST* *REFLEX-HOSTS*))
  (CADR (MY-ASSOC :CLASS
         (IF (IS-VAR INTERP)
             (IF (BOUNDP '*VAR-HOST*)
                 *VAR-HOST*
               (GET-REFLEX-HOST INTERP))
           INTERP))))

;; "[redefined]"
;; (DEFUN PASSES-CONSTRAINT (VALUE-CLASS CONSTRAINT-CLASS)
;;   (DECLARE (SPECIAL *FRAMES*))
;;   (COND ((OR (NULL VALUE-CLASS) (NULL CONSTRAINT-CLASS)) NIL)
;;         ((SYMBOLP CONSTRAINT-CLASS)
;;          (OR (HAS-TYPE VALUE-CLASS CONSTRAINT-CLASS)
;;              (HAS-TYPE CONSTRAINT-CLASS VALUE-CLASS)
;;              (FOREACH W IN *FRAMES* JOIN
;;               (IF (AND (CDR (GET W 'ISA)) (HAS-TYPE W VALUE-CLASS)
;;                        (HAS-TYPE W CONSTRAINT-CLASS))
;;                   (LIST W)))))
;;         (T
;;          (OR (PASSES-CONSTRAINT VALUE-CLASS (CAR CONSTRAINT-CLASS))
;;              (PASSES-CONSTRAINT VALUE-CLASS (CDR CONSTRAINT-CLASS))))))

(DEFUN HAS-TYPE (SOURCE TARGET)
  (COND ((CONSP SOURCE)
         (OR (HAS-TYPE (FIRST SOURCE) TARGET)
             (HAS-TYPE (CDR SOURCE) TARGET)))
        ((NOT (ATOM SOURCE)) NIL)
        ((CONSP TARGET)
         (OR (HAS-TYPE SOURCE (FIRST TARGET))
             (HAS-TYPE SOURCE (REST TARGET))))
        ((EQUAL SOURCE TARGET) 0)
        ((STRINGP SOURCE) (IF (EQ TARGET 'STRING) 0))
        ((NUMBERP SOURCE) (IF (EQ (TYPE-OF SOURCE) TARGET) 0))
        ((SYMBOLP SOURCE)
         (FOREACH P IN (GET SOURCE 'ISA) THEREIS
          (LET ((VAL (HAS-TYPE P TARGET)))
            (IF VAL (RETURN-FROM HAS-TYPE (1+ VAL))))))))

(DEFUN INTERPRET-ADJUNCTS (INTERPS ROLETERMS)
  (DECLARE (SPECIAL *VAR-ROLE*))
  (IF (NULL ROLETERMS)
      INTERPS
    (LET* ((R (CAR ROLETERMS))
           (ROLE (IF (CONSP R) (FIRST R) *VAR-ROLE*))
           (VAL (IF (CONSP R) (SECOND R) R)))
      (IF (SETQ INTERPS
                (WFF-OUTER-ROLE-INTERPRETATIONS INTERPS
                 (OUTER-ROLE-SPECS ROLE) VAL))
          (INTERPRET-ADJUNCTS INTERPS (CDR ROLETERMS))))))

(DEFUN OUTER-ROLE-SPECS (FLAG)
  (DECLARE (SPECIAL *OUTER-ROLE-SPECS*))
  (CDR (MY-ASSOC FLAG *OUTER-ROLE-SPECS*)))

(DEFUN WFF-OUTER-ROLE-INTERPRETATIONS (INTERPS SPECS VALUES)
  (FOREACH INTERP IN INTERPS JOIN
   (REMOVE NIL
           (FOREACH SPEC IN SPECS COLLECT
            (SATISFIES-OUTER-ROLE-SPEC INTERP SPEC VALUES)))))

(DEFUN SATISFIES-OUTER-ROLE-SPEC
    (INTERP SPEC VALUES &AUX PREDICATE INTERP-CONSTRAINT VAL-CONSTRAINT
     OK-VALUES)
  (DECLARE (SPECIAL *TRACE-SELECTION*))
  (SETQ PREDICATE (FIRST SPEC)
        INTERP-CONSTRAINT (SECOND SPEC)
        VAL-CONSTRAINT (THIRD SPEC))
  (WHEN (TEST-CONSTRAINT INTERP INTERP-CONSTRAINT)
    (SETQ OK-VALUES
          (COND ((EQUAL VALUES 'VAR) (INTERPRET-VAR VAL-CONSTRAINT))
                ((AND (CONSP VALUES) (EQ (CAR VALUES) 'ONEOF))
                 (FOREACH VAL IN (CDR VALUES) JOIN
                  (TEST-CONSTRAINT VAL VAL-CONSTRAINT)))
                ((AND (CONSP VALUES) (EQ (FIRST VALUES) 'LAMBDA))
                 (LET ((*PRO-HOST* *SA-PRO-HOST*))
                   (DECLARE (SPECIAL *PRO-HOST*))
                   (TEST-CONSTRAINT (INTERPRET-LAMBDA-FORM VALUES)
                    VAL-CONSTRAINT)))
                (T (TEST-CONSTRAINT VALUES VAL-CONSTRAINT)))))
  (COND (OK-VALUES
         (SETQ OK-VALUES
               (IF (CDR OK-VALUES)
                   (CONS 'ONEOF OK-VALUES)
                 (CAR OK-VALUES)))
         (CONS (LIST (CAR SPEC) (GET-ID INTERP) OK-VALUES) INTERP))
        (T
         (WHEN *TRACE-SELECTION*
           (TRACE-MSG "Cannot interpret ~A as Adjunct ~A.~%" VALUES
            SPEC)))))

(DEFUN GET-ID (INTERP) (FOREACH X IN INTERP THEREIS (IS-VAR X)))

;; "[redefined]"
;; (DEFUN INTERPRET-OP2-FORM (XN &AUX OPS OP2 ARG1 ARG2)
;;   (DECLARE (SPECIAL *VAR-HOST* *VAR-ROLE*))
;;   (MULTIPLE-VALUE-SETQ (OPS XN) (SKIP-OP1S XN))
;;   (SETQ OP2 (FIRST XN))
;;   (SETQ ARG1 (GET-SEMANTICS (ARG1 XN)))
;;   (WHEN ARG1
;;     (IF (EQ OP2 'ASKWH)
;;         (LET ((*VAR-HOST* NIL) (*VAR-ROLE* NIL) (RESULTS NIL))
;;           (DECLARE (SPECIAL *VAR-HOST* *VAR-ROLE*))
;;           (IF (IS-ROLETERM ARG1)
;;               (SETQ *VAR-ROLE* (FIRST ARG1) ARG1 (SECOND ARG1)))
;;           (SETQ RESULTS
;;                 (FOREACH SEM IN
;;                  (IF (EQ (CAR ARG1) 'ONEOF) (CDR ARG1) (LIST ARG1))
;;                  JOIN (SETQ *VAR-HOST* SEM)
;;                  (WHEN (SETQ ARG2 (GET-SEMANTICS (ARG2 XN)))
;;                    (COMPOSE-RESULT OP2 SEM ARG2))))
;;           (WHEN RESULTS
;;             (IF (CDR RESULTS) (CONS 'ONEOF RESULTS) (CAR RESULTS))))
;;       (WHEN (SETQ ARG2 (GET-SEMANTICS (ARG2 XN)))
;;         (LIST OP2 ARG1 ARG2)))))

;; "[redefined]"
;; (DEFUN COMPOSE-RESULT (OP2 SEM ARG2)
;;   (DECLARE (SPECIAL *VAR-ROLE*))
;;   (LIST (LIST OP2 SEM ARG2)))

(DEFUN IS-SIMPTERM (FORM)
  (OR (IS-CONSTANT FORM) (IS-EXPANDED-CONSTANT FORM) (IS-VARIABLE FORM)
      (IS-QUANT FORM) (IS-VING-QUANT FORM) (IS-OP2-SIMPTERM FORM)))

(DEFUN IS-CONSTANT (FORM)
  (AND (ATOM FORM) (OR (NUMBERP FORM) (GET FORM 'CONSTANT-FRAMES))))

(DEFUN IS-REFLEXIVE (FORM)
  (OR (IS-SINGULAR-REFLEXIVE FORM) (IS-PLURAL-REFLEXIVE FORM)))

(DEFUN IS-SINGULAR-REFLEXIVE (PRO)
  (MEMBER PRO '(HIMSELF HERSELF ITSELF YOURSELF MYSELF)))

(DEFUN IS-PLURAL-REFLEXIVE (PRO)
  (MEMBER PRO '(YOURSELVES THEMSELVES OURSELVES EACH-OTHER)))

(DEFUN IS-SINGULAR-PRO (PRO) (MEMBER PRO '(HE HIM SHE HER IT YOU I ME)))

(DEFUN IS-PLURAL-PRO (PRO) (MEMBER PRO '(YOU THEM THEY US WE)))

(DEFUN IS-REFLEXIVE-VAR (FORM)
  (AND (CONSP FORM) (EQ (FIRST FORM) 'RFLX) (IS-VAR (SECOND FORM))))

(DEFUN IS-EACH-OTHER (FORM)
  (AND (CONSP FORM) (EQ (FOURTH FORM) 'EACH-OTHER)))

(DEFUN IS-EXPANDED-CONSTANT (FORM)
  (AND (CONSP FORM) (MEMBER (FIRST FORM) '(CONST NAME PRON PROX))
       (IS-VAR (SECOND FORM)) (IS-CONSTANT (THIRD FORM))))

(DEFUN IS-VARIABLE (FORM) (MEMBER FORM '(VAR PRO)))

(DEFUN IS-ROLETERM-VARIABLE (FORM)
  (DECLARE (SPECIAL *VAR-ROLE*))
  (AND (EQ FORM 'VAR) (BOUNDP '*VAR-ROLE*) *VAR-ROLE*))

(DEFUN IS-QUANT (FORM)
  (AND (CONSP FORM) (IS-Q (FIRST FORM)) (IS-VAR (SECOND FORM))
       (IS-NPRED (THIRD FORM)) (IS-NUMBER (FOURTH FORM))))

(DEFUN IS-Q (SYMBOL)
  (DECLARE (SPECIAL *QUANTIFIERS*))
  (OR (IS-DETERMINER SYMBOL) (MEMBER SYMBOL *QUANTIFIERS*)))

(DEFUN IS-DETERMINER (FORM)
  (AND (SYMBOLP FORM) (GETF (GET FORM 'WORD-DEFN) 'T)))

(DEFUN IS-VAR (FORM)
  (AND (SYMBOLP FORM)
       (OR (NOT (SYMBOL-PACKAGE FORM))
           (LET ((STRING (STRING FORM)))
             (AND (ALPHA-CHAR-P (ELT STRING 0)) (> (LENGTH STRING) 1)
                  (NUMERIC-CHAR-P (ELT STRING 1)))))))

(DEFUN NUMERIC-CHAR-P (CHAR)
  (AND (ALPHANUMERICP CHAR) (NOT (ALPHA-CHAR-P CHAR))))

(DEFUN IS-NPRED (FORM) (AND (ATOM FORM) (GET FORM 'NPRED-FRAME-SPECS)))

(DEFUN IS-NUMBER (FORM)
  (OR (MEMBER FORM '(SINGULAR PLURAL NOCOUNT)) (NULL FORM)))

(DEFUN IS-VING-QUANT (FORM)
  (AND (CONSP FORM) (IS-Q (FIRST FORM)) (IS-VAR (SECOND FORM))
       (EQ (THIRD FORM) 'PROG) (IS-PRED (FOURTH FORM))))

(DEFUN IS-ONEOF-INTERP (FORM &AUX OPS)
  (WHEN (CONSP FORM)
    (MULTIPLE-VALUE-SETQ (OPS FORM) (SKIP-OP1S FORM))
    (EQ (FIRST FORM) 'ONEOF)))

(DEFUN IS-ROLETERM (FORM)
  (AND (CONSP FORM) (IS-ROLE (FIRST FORM))
       (OR (HAS-SEMANTICS (SECOND FORM))
           (IS-SIMPTERM-OR-WFF (SECOND FORM)))
       (NULL (CDDR FORM))))

(DEFUN IS-ROLE (SYMBOL)
  (DECLARE (SPECIAL *ROLES*))
  (OR (IS-PREPOSITION SYMBOL) (IS-IDIOMATIC-PREPOSITION SYMBOL)
      (IS-SUBORDINATING-CONJUNCTION SYMBOL) (MEMBER SYMBOL *ROLES*)))

(DEFUN IS-PREPOSITION (FORM)
  (AND (ATOM FORM) (GETF (GET FORM 'WORD-DEFN) 'P)))

(DEFUN IS-IDIOMATIC-PREPOSITION (FORM)
  (FIND-IF
     #'(LAMBDA (IDIOM)
         (LET* ((DEFN (SECOND IDIOM)) (P (GETF DEFN 'P)))
           (AND P (EQ FORM (GETF (CDR P) 'XN)))))
     *IDIOMS*))

(DEFUN IS-SUBORDINATING-CONJUNCTION (FORM)
  (AND (ATOM FORM)
       (FOREACH CS IN '(CS0 CS1 CS2 CS3 CS4 CS5 CS6 CS7) THEREIS
        (GETF (GET FORM 'WORD-DEFN) CS))))

(DEFUN IS-SATERM (FORM) (AND (CONSP FORM) (EQ (CAR FORM) 'S-A)))

(IMPORT 'FIXNUMP)

(DEFUN IS-ROLE-ATTRIBUTE-PAIR (FORM)
  (AND (CONSP FORM) (IS-ROLE (FIRST FORM)) (FIXNUMP (SECOND FORM))))

(DEFUN IS-SIMPTERM-OR-WFF (FORM) (OR (IS-SIMPTERM FORM) (IS-WFF FORM)))

(DEFUN IS-WFF (FORM)
  (OR (IS-LAMBDA-FORM FORM) (IS-SIMPLE-WFF FORM) (IS-OP2-WFF FORM)))

(DEFUN IS-LAMBDA-FORM (FORM) (AND (CONSP FORM) (EQ (CAR FORM) 'LAMBDA)))

(DEFUN IS-SIMPLE-WFF (FORM &AUX OPS NEWFORM)
  (WHEN (AND (CONSP FORM) (ATOM (CAR FORM)))
    (MULTIPLE-VALUE-SETQ (OPS NEWFORM) (SKIP-OP1S FORM))
    (IS-PRED (CAR NEWFORM))))

(DEFUN IS-OP1 (SYM) (EQUAL (GET SYM 'LOGICAL-TYPE) 'OP1))

(DEFUN SKIP-OP1S (WFF &AUX OPS)
  (DO ((FORM WFF (CDR FORM)))
      ((COND ((NULL FORM) (RETURN NIL))
             ((NOT (SYMBOLP (CAR FORM))) (RETURN NIL))
             ((NOT (IS-OP1 (CAR FORM))) (RETURN (VALUES OPS FORM)))))
    (PUSH (CAR FORM) OPS)))

(DEFUN IS-PRED (FORM) (AND (ATOM FORM) (GET FORM 'PRED-FRAME-SPECS)))

(DEFUN IS-POSSIBLE-SIMPLE-WFF (FORM &AUX OPS NEWFORM)
  (WHEN (AND (CONSP FORM) (ATOM (CAR FORM)))
    (MULTIPLE-VALUE-SETQ (OPS NEWFORM) (SKIP-OP1S FORM))
    (AND (ATOM (CAR NEWFORM)) (CAR NEWFORM))))

(DEFUN IS-OP2-FORM (FORM &AUX OPS NEWFORM)
  (WHEN (CONSP FORM)
    (MULTIPLE-VALUE-SETQ (OPS NEWFORM) (SKIP-OP1S FORM))
    (AND (SYMBOLP (CAR NEWFORM))
         (EQUAL (GET (CAR NEWFORM) 'LOGICAL-TYPE) 'OP2) (ARG1 NEWFORM)
         (ARG2 NEWFORM))))

(DEFUN IS-OP2-SIMPTERM (FORM)
  (AND (IS-OP2-FORM FORM)
       (OR (IS-SIMPTERM (ARG1 FORM)) (IS-OP2-SIMPTERM (ARG1 FORM)))))

(DEFUN IS-OP2-WFF (FORM) (AND (IS-OP2-FORM FORM) (IS-WFF (ARG1 FORM))))

(DEFUN ARG1 (OP2-FORM) (SECOND OP2-FORM))

(DEFUN ARG2 (OP2-FORM) (THIRD OP2-FORM))

(DEFUN IS-ADVERBIAL-FORM (FORM) (IS-NOT-FORM FORM))

(DEFUN IS-NOT-FORM (FORM)
  (AND (CONSP FORM) (EQ (FIRST FORM) 'NOT) (IS-VAR (SECOND FORM))
       (NULL (CDDR FORM))))

(DEFUN PP-TRACE-MSG (COMMENT FORM)
  (FORMAT T COMMENT)
  (PPRINT FORM)
  (TERPRI))