;;; Release: CMUCL_standalone_port (1.3)
;;; File: pprint-parse.lisp,v
;;; File date: 2003/07/16 18:45:04 (UTC)
;;; Author: SCT

;; Utilities for pprinting

(in-package nlp)

(defun extract-elts (p)
  (if (consp p)
      (list* (second p)
	     (mapcar 'extract-elts (fifth p)))
    p))

(defun print-parse (p)
  (pprint (extract-elts p)))

(defun print-parses (ps)
  (dolist (p ps ps)
	  (print-parse p)))

(defparameter *pprint-parses* nil)

(defun trace-parses ()
  (setq *pprint-parses* t))

(defun pprint-parse? (p)
  (cond (*pprint-parses*
	 (format t "~%parse=~%")
	 (print-parses p)
	 (format t "~%")))
  p)

