;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; predicates.lisp,v 1.8 2003/07/14 19:06:11 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   "config"
		   "state"
		   "prediscr"
		   ))

(in-package :NLP)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; predicates
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



(defun p-closest (&key obj)
  obj)

(defun position-indicator (object position)
  (if (physobj-p object)
      (physobj-position-indicator object position)
    (setf (get object :direction) position)))

(defun physobj-position-indicator (object position)
  (case position
    ((your-right my-left)(and (member :right (obj-dir object)) :right))
    ((your-left my-right)(and (member :left (obj-dir object)) :left))
    (:behind (and (member :REAR (obj-dir object)) :behind))
    (:in-front-of (and (member :in-front-of (obj-dir object)) :in-front-of))
    (otherwise (warn (format nil "Unknown position ~A" position)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; assert the position of something (object location) relative to the observer
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defstruct pred name args)

(defparameter *foos* nil)		;store timestamp too?

(defparameter *kbt* (make-hash-table))

(defun unquerify (form)
  (let ((tail (member :query form)))
    (append (ldiff form tail)
	    (cddr tail))))

(defparameter *locations* '(
			    (:across-from-loc . |ACROSS FROM|)
			    (:at-loc . at)
			    (:behind-loc . behind)
			    (:down-loc . down)
			    (:in-loc . in)
			    (:to-loc . to)
			    (:in-front-of-loc . |IN FRONT OF|)
			    (:near-loc . near)
			    (:next-to-loc . |NEXT TO|)
			    (:on-loc . on)
			    (:under . under)
			    )) ;... TODO

(defun broadcast-locations (&rest rest &key theme &allow-other-keys)
  (mapl #'(lambda (tail)
	    (cond ((member (car tail) *locations* :key 'car)
		   (publish-is-located theme 
				       (cdr (assoc (car tail) *locations*))
				       (cadr tail)))))
	rest))
				       
;; Used to be BE-AT-POSITION
;; we ignore opposite and at-loc
(defun p-be (&rest rest 
             &key theme position loc query in-front-of-loc on where-at
	     in-loc on-loc command cotheme
	     &allow-other-keys )
  (declare (special current-context))
  (cond (query
	 (cond (where-at nil)
	       ((and cotheme theme (eq cotheme theme)) t)		
	       (t
		(if (car (member (unquerify rest) ;(list :theme theme :loc loc)
				 (gethash (quote p-be) *kbt*)
				 :test (quote equal)))
		    t))))
	((assertion-p (context-lfs current-context)) 
					;ASSERTION-P now out of date (SCT)
	 (assert-direction-2 :direction nloc))
	((and (has-type theme 'object) 
	      NIL)			;SCT TODO
	 (position-indicator theme loc))
	(command nil)
	(t
	 (apply 'broadcast-locations rest)
	 (pushnew rest (gethash 'p-be *kbt*))
	 nil)))

(defun p-location (&key theme at-loc &allow-other-keys)
  (declare (special current-context))
  (cond ((and (null at-loc)
	      (bind-previous-isa-request)
	      (eql (getf (context-args *previous-context*) :cotheme) theme)
	      (negation-p (context-lfs current-context)))
	 (Deny))
	((and (null at-loc)
      	      (bind-previous-isa-request)
	      (eql (getf (context-args *previous-context*) :cotheme) theme))
	 (Confirm))
	((and (has-type at-loc	'goal-direction)		;goal direction
	      (has-type theme 'thing)
	      (assertion-p (context-lfs current-context)))
	 (assert-direction))
	((and (has-type at-loc 'there)
	      (has-type theme 'thing))	;should be bind-previous-isa-request?
	 (Done))
	((and at-loc
	      (bind-previous-location-request))
	 (Confirm))))

(defun be-near (&key theme referent &allow-other-keys)
  (declare (special current-context))
   (if (not (assertion-p (context-lfs current-context)))
       (setf (get theme :direction) :near))
   (assert-direction-1 :theme theme :referent referent :direction :near))

(defun be-behind (&key theme referent &allow-other-keys)
    (declare (special current-context))
   (if (not (assertion-p (context-lfs current-context)))
       (setf (get theme :direction) :behind))
   (assert-direction-1 :theme theme :referent referent :direction :behind))

(defun be-in-front-of (&key theme referent &allow-other-keys)
    (declare (special current-context))
   (if (not (assertion-p (context-lfs current-context)))
       (setf (get theme :direction) :in-front-of))
   (assert-direction-1 :theme theme :referent referent :direction :in-front-of))

(defun be-opposite (&key theme referent &allow-other-keys)
    (declare (special current-context))
   (if (not (assertion-p (context-lfs current-context)))
       (setf (get theme :direction) :opposite))
   (assert-direction-1 :theme theme :referent referent :direction :opposite))



;; this assumes that the observer is in front of the robot

(defun right (&key relative-to agent)
  (declare (ignore agent) (special *self* *others*))
  (cond ((has-type relative-to 'r-observer) 'my-right)
	((eql relative-to *self*) 'your-right)
	((has-type (get relative-to 'type) 'object)
	 (setf (get relative-to :to-loc) :RIGHT)
	 ;;relative-to			;<- SCT was this
	 (list 'right :relative-to relative-to))
	((null relative-to) 'your-right)))

(defun left (&key relative-to agent)
  (declare (ignore agent) (special *self* *others*))
  (cond ((has-type relative-to 'r-observer) 'my-left)
	((eql relative-to *self*) 'your-left)
	((has-type (get relative-to 'type) 'object)
	  (setf (get relative-to :to-loc) :LEFT)
	  relative-to)
	((null relative-to) 'your-left)))

(defun front (&key relative-to )
  (setf (get relative-to :direction) :front)
  relative-to)

(defun center (&key relative-to)
  (setf (get relative-to :direction) :center)
  relative-to)

(defun behind (&key relative-to agent)
  (declare (ignore agent))
  (cond ((has-type relative-to 'r-observer) :behind)
	((eql relative-to *self*) :behind)
	((has-type (get relative-to 'type) 'object)
	  (setf (get relative-to :to-loc) :behind)
	  relative-to)
	((null relative-to) :behind)))

(defun in-front-of (&key relative-to agent)
  (declare (ignore agent))
  (cond ((has-type relative-to 'r-observer) :in-front-of)
	((eql relative-to *self*) :in-front-of)
	((has-type (get relative-to 'type) 'object)
	  (setf (get relative-to :to-loc) :in-front-of)
	  relative-to)
	((null relative-to) :in-front-of)))

(defun see-description (theme behind position in-front-of)
  (let ((descrip (get theme :description)))
    (cond (position
	   (setf descrip (hl-description position)))
	  (behind
	   (setf descrip (hl-description 'behind)))
	  (in-front-of
	   (setf descrip (hl-description 'in-front-of))))
    (if (string-equal descrip "NONE")
	(setf (get theme :description)
	      (format nil "I don't sense anything ~:[~;in that direction ~]"
		      (or position behind in-front-of)))
      (setf (get theme :description) descrip))))

(defun p-see (&key agent theme near behind position in-front-of command
		   query)
  (declare (ignore agent)
	   (ignore command))
  (and 
   (cond ((description-p theme)
	  (see-description theme behind position in-front-of)
	  theme)
	 ((and (physobj-p theme)
	       position)
	  (be-at-position :theme theme :position position))
	 ((and (physobj-p theme)
	       behind)
	  (be-behind :theme theme))
	 ((and (physobj-p theme)
	       in-front-of)
	  (be-in-front-of :theme theme))
	 ((and (physobj-p theme)
	       near)
	  (be-near :theme theme))
	 ((physobj-p theme) theme))
   (or (get theme :distance)
       (and (description-p theme)	;TODO get rid of this!
	    (not (equalp (see-description theme behind position in-front-of)
			 "I don't sense anything "))))
   theme))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; p-isa
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun p-isa (&key theme cotheme query &allow-other-keys)
  (declare (special current-context))
  (cond (query
	 (has-type theme cotheme))
	(*strict-02*
	 (cond
	  ((null theme)
	   (talk-and-echo "Sorry, there is no such thing."))
	  ((negation-p (context-lfs current-context))
	   (Deny)
	   nil)				; return nil to terminate immediately
	  ((eql theme cotheme)
	   (Confirm)			;SCT why confirm?
	   (DestinationReached cotheme)) ;hope that works
	  ((has-type cotheme 'state)
	   (Done))
	  ((has-type cotheme 'location)
	   (DestinationReached cotheme))
	  ((eql cotheme 'object-gap)
	   (Confirm))))
	(t
	 (pushnew (list :theme theme :cotheme cotheme)
		  (gethash 'p-isa *kbt*)
		  :test 'equal))))

(defun have-attribute (&key agent state &allow-other-keys)
  (declare (special current-context))
  (cond ((and (eql agent *self*)
	     (assertion-p (context-lfs current-context)))
	 (Done))
	((and (eql agent *self*)
	      (negation-p (context-lfs current-context)))
	 (Deny))))
	      
(defun p-exist (&key theme to-loc goal)
  (declare (ignore to-loc goal))
  (physobj-p theme))

(defun assign-object (from to)
  (setf (get to :id) (get from :id))
  (setf (get to :direction) (get from :direction))
  (setf (get to :description) (get from :direction))
  (setf (get to :x-coord) (get from :x-coord))
  (setf (get to :y-coord) (get from :y-coord)))

;(defun p-location-check (direction at-loc)
;  (cond ((and (consp direction)
;              (member at-loc direction))
;         at-loc)
;        ((and (consp direction)
;              (member (intern (symbol-name at-loc) 'keyword) direction))
;         at-loc )
;        ((and (symbolp direction)
;              (eql direction at-loc))
;         at-loc)))
;
;(defun p-location (&key theme at-loc)
;  (declare (special current-context))
;  (if (assertion-p (context-lfs current-context))
;    (setf (get theme :direction) at-loc)      
;      (p-location-check (get theme :direction) at-loc)))


;; no verb
;; forward 4 inches
;; clarification to previous command?

(defun p-dummy-vp (&rest args &key theme command &allow-other-keys)
  (declare (special current-context))
  (setf (context-command current-context) 'p-dummy-vp)
  (setf (context-args current-context) args)
  (setf (context-success current-context) t)
  (cond ((has-type theme 'attention)
	 (talk-and-echo "Good to go.")
	 (setf *attention-var* t))
	((has-type theme 'at-ease)
	 (talk-and-echo "I'm at eesze.")
	 (setf *attention-var* nil))
	((and (bind-exit-command)
	      (negation-p (context-lfs current-context)))
	 (clear-history *previous-context*))
	((bind-exit-command)
	 (shut-down))
	((bind-unsuccessful-command)
	 (apply (context-command *previous-context*)
		(merge-keywords args
				(context-args *previous-context*))))
	((and (bind-uncertain-vv-parse)
	      (negation-p (context-lfs current-context))) ;do nothing
	 (clear-history *previous-context*))
	((negation-p (context-lfs current-context))
	 (Deny))
	((bind-uncertain-vv-parse)
	 (clear-history *previous-context*)
	 (process-sentence-in-earnest
	  (string-left-trim '(#\?) (context-mesg *previous-context*))
	  (check-for-my-name (context-mesg *previous-context*))))
	((bind-end-of-sequence)
	 (Done))
	((bind-previous-isa-request)
	 (Confirm))
	((bind-previous-ami-request)
	 (Confirm))
	((bind-previous-location-request)
	 (Confirm))
	((and (null theme)
	      command
	      (bind-unparsed-request))
	 (Confirm));it's a yes
	((and (null theme)
	      (null command)
	      (bind-unparsed-request))
	 (Deny)) ; it's a no
	(t (clear-gesture)
	   (talk-and-echo "What?"))))

(defun p-know (&rest r &key agent theme query &allow-other-keys)
  )

(defparameter *my-wants* '(proceedings badge))
(defparameter *my-preferences* '(digitial-form))

(defun p-prefer-or-desire (&rest r &key agent theme co-theme 
				 command query &allow-other-keys)
  ;; hard copy or CD  TODO
  (cond (query
	 (if (equalp (string agent) *robot-name*)
	     (setq *be-polite-now* t))
	 (cond ((member ;;??theme 
		 (list :agent agent :theme theme)
		 (gethash 'p-prefer-or-desire *kbt*)
		 :test 'equal)
		t)
	       ((p-have :agent agent :theme theme :query t)
		(pushnew (list 'say-statement
			       (format nil "I already have~(~{ ~s~}~)"
				       (add-determiner theme) ))
			 *also-say*
			 :test 'equal)
		nil)
	       (t nil)))
	((consp theme)
	 (pushnew theme ;;(eval (append theme (list :formal t)))
		  (gethash 'p-prefer-or-desire *kbt*)
		  :test 'equal)
	 nil)
	(t
	 (pushnew (list :agent agent :theme theme)
		  (gethash 'p-prefer-or-desire *kbt*)
		  :test 'equal)
	 nil)))

(defun p-stative (&rest r &key agent theme co-theme
			command query &allow-other-keys)
  (cond (query 
	 (cond ((has-type co-theme 'time)
		(cond ((null theme) co-theme)
		      ((has-type theme 'event)
		       (get theme 'time))
		      ;; "Sorry, I don't know the time of that"))
		      (t
		       ;; TODO don't keep saying this
		       ;;(say-statement 
		       ;; "Sorry, the time of what?")
		       ;;     ;; (get theme 'plural))
		       nil
		       )))
	       (t
		(if (member theme (gethash 'p-stative *kbt*)
			    :test 'equal)
		    t))))
	(command nil)
	(t (pushnew theme 
		    (gethash 'p-stative *kbt*)
		    :test 'equal)
	   nil)))

(defun p-come-from (&key agent loc query &allow-other-keys)
  (cond (query
	 (if (member (list :agent agent :loc loc)
		     (gethash 'p-come-from *kbt*)
		     :test 'equal)
	     t))
	(t (pushnew (list :agent agent :loc loc)
		    (gethash 'p-come-from *kbt*)
		    :test 'equal)
	   nil)))

(defun p-register (&rest r &key agent loc
			 command query formal &allow-other-keys)
  (cond (query t)			;TODO no past means T is okay
	(command nil)
	(formal (append (list 'p-register) 
			(ldiff r (member :form r))
			(cddr (member :form r))))
	(t (pushnew (list :agent agent :loc loc)
		    (gethash 'p-register *kbt*)
		    :test 'equal)
					;what if loc is eg 'downstairs'
					;which floor downstairs?
	   nil)))

(let ((table (make-hash-table :test 'eq)))
  (defun c-talk (&rest r &key relative-to &allow-other-keys)
    (let ((which-talk (gethash relative-to table)))
      (or which-talk
	  (let ((sym (gentemp "TALK")))
	    (setf (get sym :relative-to) 
		  relative-to)
	    (setf (gethash relative-to table)
		  sym))))))

(defun p-eat (&key agent theme meal query command)
  (cond (query 
	 (if (member (list :agent agent :theme theme :meal meal)
		     (gethash 'p-eat *kbt*)
		     :test 'equal)
	     t))
	(command nil)
	(t (pushnew (list :agent agent :theme theme :meal meal)
		    (gethash 'p-eat *kbt*)
		    :test 'equal)
	   nil)))

(defun p-eat-meal (&key agent 
			(meal nil)	;should be a generic meal (TODO)
			query command)
  (p-eat :agent agent :meal meal :query query :command command))

(defun p-attribute-have-value (&rest r) )

(defun c-name (&key relative-to) 
  (if relative-to
      (intern (format nil "~@(~s~)" relative-to))
    '|Unknown|))
  
(defun c-time (&rest r)
  'the-time-now)

(defun p-tell (&key agent theme goal command query &allow-other-keys)
  (cond (command (say-statement (format nil "~a" theme)))
	(query t)
	(t nil)))			;TODO
	 

(defun p-have (&key agent theme co-theme command query &allow-other-keys)
  (cond (command nil)			;TODO
	(query 
	 (if (member (list :agent agent :theme theme :co-theme co-theme)
		     (gethash 'p-have *kbt*)
		     :test 'equal)
	     t))
	(t (pushnew (list :agent agent :theme theme :co-theme co-theme)
		    (gethash 'p-have *kbt*)
		    :test 'equal)
	   (if (member ;;??theme 
		(list :agent agent :theme theme)
		(gethash 'p-prefer-or-desire *kbt*)
		:test 'equal)
	       (setf (gethash 'p-prefer-or-desire *kbt*)
		     (remove
		      (list :agent agent :theme theme)
		      (gethash 'p-prefer-or-desire *kbt*)
		      :test 'equal)))
	   nil)))

