;;
;; prediscr.lisp,v 1.4 2003/07/14 17:15:39 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules  "packages"
		    "state"
		    ))

(in-package nlp)

;;; (SCT) There is now an *NAMED-ADDRESSEE* rebound in TRAV-MAIN when an
;;; utterance has an explicit addressee (e.g. "Grace, we are done.")
;;; Leave it as initialized (NIL) at all other times.

(defvar *named-addressee* nil)

(defun is-me (npelt)
  (and (is-np-form npelt)
       (member (forth npelt) '(i me myself))))

(defun found-me (det val type)
  (let* ((me-type (most-specific-type nil nil)))))

;;; From ~nlp/focal/prediscr.lisp

;;; PREDISCR
;;; Original code and comments by Gina-Anne Levow, MIT

;;; [KW] prefix for KW comments; my code changes all in upper case

;;; SCT added special binding for *named-addressee*

(defun trav-main (list1 &AUX *WFF)
  (DECLARE (SPECIAL *YOU* *WFF))
;;; [KW] Special *WFF is so process-conjoined-np can insert index
  (SETQ *WFF LIST1)
  (if (null list1)
      nil
    (if (equal (car list1) 'askwh)
	(let ((val (trav-vp (SETQ *WFF (third list1)) nil))
	      (WH (SECOND LIST1)))

;;; [KW] Allow the plural WH in WHICH FIGHTERS ARE MOVING?  to match a
;;; singleton referent. ["NOCOUNT" is a don't care NP number.]

	  (WHEN (EQ (FOURTH WH) 'PLURAL)
		(SETF (FOURTH WH) 'NOCOUNT))

;;; [KW] The WH is not necessarily indexed in the top-level wff that
;;; follows, e.g.  WHICH FIGHTER DID JOHN WANT FRED TO WATCH =
;;; (askwh (which x fighter)(want john (watch fred x))).

;;; 	  (APPEND (trav-np (list (cons (get-pro-slot *WFF)
;;; 				       (list WH)))
;;; 			   (get-verb *WFF))
;;; 		  val)

;;;	  (LET ((WH-WFF (FIND-WH-WFF *WFF (SECOND WH))))
;;;	    (APPEND (TRAV-NP (LIST (CONS (GET-PRO-SLOT WH-WFF (SECOND WH))
;;;					 (LIST WH)))
;;;			     (GET-VERB WH-WFF))
;;;		    VAL)

;;; [KW] Reversing focus order of the WH and other arguments

	  (LET ((WH-WFF (FIND-WH-WFF *WFF (SECOND WH))))
	    (APPEND VAL (TRAV-NP (LIST (CONS (GET-PRO-SLOT WH-WFF (SECOND WH))
					     (LIST WH)))
				 (GET-VERB WH-WFF)))
	    ))
      (if (eq (car list1) 'tellif)
	  (trav-vp (second list1) nil)
	(if (MEMBER (car list1) '(AND OR))      ; if this is a conjunction
	    (meld (trav-vp (second list1) nil)
;;; [KW] Arg2 could be a conjunction as well (we force right-branching)
		  (TRAV-MAIN (third list1)))
	  (IF (EQ (CAR LIST1) 'ADDRESS)
	      (LET ((YOU (TRAV-NP (LIST (CONS (GET-YOU-SLOT (THIRD LIST1))
					      (LIST (SECOND LIST1))))
				  (GET-VERB (THIRD LIST1)))))
		 (let ((*you*))		;SCT added
					;Deprecating *YOU*
		   (SETQ *YOU* (LAST (FIRST YOU)))
		   (IF (CONSP (FIRST *YOU*))
		       (SETQ *YOU* (FIRST *YOU*)))
		   (set-named-addressee :to *you*)	;SCT
		   (let ((*named-addressee* *you*))     ;"
		     (APPEND YOU (TRAV-MAIN (THIRD LIST1))))))
	    (trav-vp list1 nil)))))))

;; SCT replaced *YOU* by (LAST-NAMED-ADDRESSEE)
;;
(defun found-you (det val type)
  ;; (declare (special *you*))
  (let* ((last-you (last-named-addressee))
	 (you-type (most-specific-type last-you nil))
	 (result (if (or (match type you-type)
			 (match you-type type)) 
		     last-you)))
    (if (process-det-and-number result det val type nil t) 
	last-you)))

;; SCT
(defun make-object-of-type (type)
  ;; (declare (special *objlist*))
  (case type
	(c-name (list '|John Slash Jane Doe|))	;TODO!
	(c-time (multiple-value-bind
		 (second minute hour day month year etc1 etc2 etc3)
		 (get-decoded-time)
		 (declare (ignore second)
			  (ignore day)
			  (ignore month)
			  (ignore year)
			  (ignore etc1)
			  (ignore etc2)
			  (ignore etc2))
		 (let ((sym (intern
			     (format nil "~s ~a ~s"
				     (if (> hour 12)
					 (- hour 12)
				       hour)
				     (if (> minute 9)
					 minute
				       (if (> minute 0)
					   (format nil "oh ~s" minute)
					 ""))
				     (if (>= hour 12)
					 'pm
				       'am)))))
		   (setf (get sym 'type) 'c-time)
		   (setf (get sym 'isa) (list type))
		   (setf (get sym 'military-hour) hour)
		   (setf (get sym 'hour) (if (> hour 12)
					     (- hour 12)
					   hour))
		   (setf (get sym 'minute) minute) 
		   (setf (get sym 'am/pm) (if (>= hour 12)
					      'pm
					    'am))
		   ;; (pushnew sym *objlist*) ;TODO 1) too slow! 2 is it saved?
		   sym)))
	(t nil)))

;; process-det-and-number (result det number type &optional no-error you)

(defun process-det-and-number (result det number type &optional no-error you
				      &aux type-name)
  (setq type-name (type-name type))
  (if (null result)
      (if no-error nil 
	(if you (reference-error (format nil "You aren't addressing ~A"
					 type-name))
	  (or (make-object-of-type type) 
	      (progn 
		;;was: (reference-error 
		;;      (format nil "No such ~A exists" type-name))))))
		(push `(say-statement 
			,(format nil "No such ~A exists" type-name))
		      *yet-to-say*)
		(throw 'reference-error 'error)))))
    (if (cdr result)
        (case det
;;; [KW] PLURAL REFERENT, DEFINITE NP
	      ((THE NULL-DET)
;;; [KW] 1/23/96: BUG: in "what kind of fighter" we want the embedded NP
;;; (NULL-DET SINGULAR) to be interpreted as INdefinite (same as SOME),
;;; not definite.  For now not fixed here, but ad hoc fix in interviewer.
	       (if (and (eq number 'SINGULAR) NIL) ;SCT NIL
		   (if no-error nil
		     (PROGN (GENERATE-DE-FOR-SET RESULT)
			    (reference-error
			     (format nil "More than one such ~A exists"
				     type-name))))
		 (pick-one (cons det result))))
;;; [KW] PLURAL REFERENT, INDEFINITE NP
	      ((SOME NO ONE)(pick-one (cons det result)))
;;; [KW] PLURAL REFERENT, WH DETERMINER
	      ((WHICH MUCH WHERE-AT-WHICH) result) ;WHERE-AT-WHICH: SCT
;;; [KW] PLURAL REFERENT, UNIVERSAL DETERMINER
	      (ALL result)
;;; [KW] PLURAL REFERENT, NAME/PRONOUN
	      ((THAT THOSE) result)
	      (t (if (eq number 'SINGULAR)
		     (if no-error nil
		       (PROGN (GENERATE-DE-FOR-SET RESULT)
			      (reference-error 
			       (format nil "More than one such ~A exists"
				       type-name))))
		   result)))
      (if (eq number 'PLURAL)
;;; [KW] SINGLE REFERENT, PLURAL NP
	  (if (eq det 'THE)
	      (if (or (numberp (first result))
		      (and (symbolp (first result))
			   (get (first result) 'collective)))
		  result
		(if no-error nil
		  (PROGN (GENERATE-DE-FOR-SET RESULT)
			 (reference-error
			  (format nil "Only one such ~A exists"
				  type-name)))))
	    result)
;;; [KW] SINGLE REFERENT, SINGULAR NP
	(if (eq number 'SINGULAR)
	    (if (and (symbolp (first result))
		     (get (first result) 'collective))
;;; [KW] for example *SHOW THE AIRCRAFT TRAIL (collectives MUST be plural NPs)
;;;		(if no-error nil
;;;		  (PROGN
;;;		   (GENERATE-DE-FOR-SET RESULT)
;;;		   (reference-error
;;;		    (format nil "More than one such ~A exists"
;;;			    type-name))))
;;; [KW] disabling the above for now, just returning result
		result
	      result)
	  result)))))


