;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :NLP)

(defparameter *stypes* '(NOT IMPER PRESENT REQUEST ASKWH))


(defun apply-additional-preferences ()
  ;;prefer "simple" parses than "complex" ones
  (prefer-most-specific)
  (prefer-first-one))

;;force disambiguation
(defun prefer-first-one ()
  (declare (special *parselist*))
  (when (cdr *parselist*)
    (setf *parselist* (list (first *parselist*)))))

;;find the members with the max value
(defun mostn (fn lst)
  (if (null lst)
      (values nil nil)
      (let ((result (list (car lst)))
            (max (funcall fn (car lst))))
        (dolist (obj (cdr lst))
          (let ((score (funcall fn obj)))
            (cond ((> score max)
                   (setq max    score
                         result (list obj)))
                  ((= score max)
                   (push obj result)))))
        (values (nreverse result) max))))

;;if every parse maps to the same type (right now just imper),
;;get the most specific one
(defun prefer-most-specific ()
  (declare (special *parselist*))
  (when (and (cdr *parselist*)
	     (same-pragma *parselist*))
    (setf *parselist*
	  (mostn  #'(lambda (parse)
		      (length (get-lf-parse parse))) *parselist*))))


(defun same-pragma (parses)
  (let ((firstpragma (get-pragma (first parses))))
    (every #'(lambda (other-parse)
	       (eql (get-pragma other-parse) firstpragma))
	   (cdr parses))))

;;return any one of the sentence type
(defun get-lf-parse (parse)
  (dolist (stype *stypes*)
    (when-bind (subparse (my-assoc stype (get-lf parse)))
	  (return subparse))))
			 

(defun get-pragma (parse)
  (first (get-lf-parse parse)))



















