;;; Release: CMUCL_standalone_port (1.7)
;;; File: process-sentence.lisp,v
;;; File date: 2003/07/16 18:45:04 (UTC)
;;; Author: SCT

;;; Error handlers. Covers for TALK-AND-ECHO called for any kind of error

;;; Requires Steele 2 Common Lisp or later

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "environment"
		   "state"
		   "lexical-lookup"
		   "pprint-parse"
		   ))

(in-package nlp)


(defun safely-parse (w x y z)
  (handler-case (pprint-parse? (parse w x y z))
   (error (e)
	  ;;(print-object e *standard-output*)
	  (format t "~%ERROR: ")
	  (write e :escape nil)
	  (error 'does-not-parse))))

(let* ((inputs (list nil nil)))
  (defun save-input (input)
    (setf (cadr inputs) (car inputs))
    (setf (car inputs) input))
  (defun last-input () (car inputs)))
	  
(defun process-sentence (sentence-string &aux words-and-cats)
  (declare (special *sentence* *topcat* *parselist* *do-selection*))
  #|(handler-case (print (list (type-of current-context)
			     (context-lfs current-context)
			     3
			     ;;(setf (context-lfs current-context) '!)
			     )
		       )
		(error (e) (write e :escape nil)))
|#
  (setq *sentence* (with-input-from-string (stream sentence-string)
					   (read-sentence stream)))
  (setq words-and-cats (lexical-lookup *sentence*))
  (when words-and-cats
	(setq *parselist* (safely-parse *topcat* 
					(car words-and-cats) 
					(cadr words-and-cats)
					'english-parser))
	(when (and *parselist* *do-selection*)
	  (apply-preferences))
	(cond (*parselist* 
	       (save-input (car words-and-cats))
	       (process-parses *parselist*))
	      (t (format t "~%Can't parse~%")
		 (cond ((equalp (last-input) (car words-and-cats))
			(say-statement "Sorry.")
			(say-statement "I hear what you're saying.")
			(say-statement "But I don't understand.")))
		 (save-input (car words-and-cats))))))

(defun try-process-sentence (str to-me?)		
  "Wraps PROCESS-SENTENCE with error handler"
  #|  (handler-case (print (list (type-of current-context)
			     (context-lfs current-context)
			     2
			     (setf (context-lfs current-context) '!)
			     )
		       )
		(error (e) (invoke-debugger e)))
|#
  (handler-bind 
    ((undefined-function #'(lambda (condition) 
			     (cond ((and (consp command)
					 (eq (first command) 'command))
				    (error 'bad-command))
				   (t			;other tests here?
				    (let ((fname (cell-error-name condition)))
				      (store-value
				       (default-function fname) condition)))
				   ;;(t
				   ;;  (error 'bad-utterance)))
				   )))
     (bad-command #'(lambda (c)
		      (if to-me? (format nil "Sorry, I don't know how to do that."))
		      (if (not *debug*)
			  (return-from try-process-sentence))))
     ;; Or get command string with
     ;; (let ((offset (search *robot-name* str)))
     ;;   (cond ((null offset) str) ;no robot name
     ;;         ((= Offset (position-if #'alphanumericp str))
     ;;          (subseq str (position-if #'alphanumericp str
     ;;             :start (+ offset (length *robot-name*)))))
     ;;         (t str))))))
     (does-not-parse #'(lambda (c)
			 (if to-me?
			     (say-statement "Sorry, I can't parse that."))
			 (if (not *debug*)
			     (return-from try-process-sentence))))
     (bad-utterance #'(lambda (c)
			(if to-me? 
			    (say-statement
			     "Sorry, I don't know how to respond to that."))
			(if (not *debug*)
			    (return-from try-process-sentence)
			  (invoke-debugger c))))	
     (ambiguity #'(lambda (c)
		    (if to-me? 
			(say-statement
			 "Sorry. That's ambiguous."))
		    (return-from try-process-sentence)))
     ;;(if *debug*
     ;;  (cerror "conntinue computation" c)))
     (error #'(lambda (c)
		(if to-me?
		    (say-statement 
		     (format nil "Sorry, I'm unable to respond to that.")))
		(cond ((not *debug*)
		       (format t "~%ERROR: ")
		       (write c :escape nil)
		       (return-from try-process-sentence))
		      (t
		       (invoke-debugger c))))))
    (let ((*have-spoken* nil)
	  (*yet-to-say* nil)
	  (*also-say* nil))
      (process-sentence str)
      (if (and (not *have-spoken*)
	       *yet-to-say*)
	  (eval (cons 'progn *yet-to-say*)))
      (if *also-say*
	  (eval (cons 'progn *also-say*))))))



