; KW 3/30/87: the following are for the "fulltrace" option

;(SETF *HARDCODED-FNS* '(WORD TESTNODENAME TESTNODETYPE TESTATTRIBUTE
;				     ATTRIBUTE FIRST-ELEMENT FIRST-COELEMENT
;				     LAST-ELEMENT NAME SENTENCE-WORD
;				     IS-TERMINAL EMPTY TERMCAT NULLCAT
;				     SET-ATTRB ERASE-ATTRB SUBSUME
;				     FIRST-WORD LAST-WORD CONJ-COPY))

(defmacro defrestr (name housing body)
  (DECLARE (SPECIAL *RESTR-LIST*))
  (setq rname name)
  (let ((newbody (add-rname name body)))
  `(progn 
     (WHEN (GET ',NAME 'HOUSING)
	   (UNHOUSE ',NAME (GET ',NAME 'HOUSING)))
     (SETF (GET ',NAME 'HOUSING) ',HOUSING)
     (HOUSE ',NAME ',HOUSING)
     (PUSHNEW ',NAME *RESTR-LIST*)
     (defun ,name ()  ,newbody))))

(defmacro defsubstmt (name body)
  (DECLARE (SPECIAL *SUBSTMT-LIST*))
  (LET ((NAME (IF (GET NAME 'GLOBAL) NAME
		(INTERN (CONCATENATE 'STRING
				     (STRING RNAME)
				     (STRING NAME))))))
    `(PROGN
       (defun ,name () ,(add-rname RNAME body))
       (PUSHNEW ',NAME *SUBSTMT-LIST*))))

(defmacro defroutine (routine-name formals body)
  (DECLARE (SPECIAL HERE))
  `(progn (setq rname ',routine-name)
	  (defun ,routine-name (here ,@formals)  
	    (and here ,(ADD-RNAME RNAME BODY)))))


(defun verb-func (&key root 3psing past pastpart prespart objlist 
		       attributes Xn)
  (let ((active_objlist (make_plist objlist))
	(passive_objlist (passivate (make_plist objlist)))
	(past2 (or past (concat (strip_e root) 'ed)))
        (attrs (make_plist_1 attributes))
	(trans (or Xn root)))
    (let ((pastpart2 (or pastpart past2)))
      (defword root
	       `(V (t SINGULAR (t) Xn ,trans OBJLIST ,active_objlist ,@attrs)
		   TV (t PLURAL (t) Xn (present ,trans)
			 OBJLIST ,active_objlist ,@attrs)))
      (defword (or 3psing (concat root 's))
	       `(TV (t SINGULAR (t) Xn (present ,trans)
		       OBJLIST ,active_objlist ,@attrs)))
      (cond ((equal past2 pastpart2)
	     (defword past2
		      `(TV (t Xn (past ,trans) OBJLIST ,active_objlist ,@attrs)
			   VEN (t Xn ,trans OBJLIST ,active_objlist
				  POBJLIST ,passive_objlist ,@attrs))))
	    (t
	     (defword past2
	      `(TV (t Xn (past ,trans) OBJLIST ,active_objlist ,@attrs)))
	     (defword pastpart2
		      `(VEN (t Xn ,trans OBJLIST ,active_objlist
			       POBJLIST ,passive_objlist ,@attrs)))))
      (defword (or prespart (concat (strip_e root) 'ing))
	       `(VING (t Xn (prog ,trans)
			 OBJLIST ,active_objlist ,@attrs))))))


(defun verb-idiom-func (&key root 3psing past pastpart prespart objlist 
		       attributes Xn left right)
  (let* ((active_objlist (make_plist objlist))
	 (passive_objlist (passivate (make_plist objlist)))
	 (past2 (or past (concat (strip_e root) 'ed)))
	 (attrs (make_plist_1 attributes))
	 (wordlist (append left (list root) right))
	 (string (substitute #\- #\Space (format nil "~A" wordlist)))
	 (trans (or Xn (intern (subseq string 1 (1- (length string)))))))
    (let ((pastpart2 (or pastpart past2)))
      (foreach word in wordlist do (defword word nil))
      (defword (or 3psing (concat root 's)) nil)
      (defword past2 nil)
      (if (not (equal past2 pastpart2))(defword pastpart2 nil))
      (defword (or prespart (concat (strip_e root) 'ing)) nil)
      (defidiomword wordlist
	       `(V (t SINGULAR (t) Xn ,trans OBJLIST ,active_objlist ,@attrs)
		   TV (t PLURAL (t) Xn (present ,trans)
			 OBJLIST ,active_objlist ,@attrs)))
      (defidiomword (append left (list (or 3psing (concat root 's))) right)
	       `(TV (t SINGULAR (t) Xn (present ,trans)
		       OBJLIST ,active_objlist ,@attrs)))
      (cond ((equal past2 pastpart2)
	     (defidiomword (append left (list past2) right)
		      `(TV (t Xn (past ,trans) OBJLIST ,active_objlist 
			      ,@attrs)
			   VEN (t Xn ,trans OBJLIST ,active_objlist
				  POBJLIST ,passive_objlist ,@attrs))))
	    (t
	     (defidiomword (append left (list past2) right)
	       `(TV (t Xn (past ,trans) OBJLIST ,active_objlist ,@attrs)))
	     (defidiomword (append left (list pastpart2) right)
	       `(VEN (t Xn ,trans OBJLIST ,active_objlist
			POBJLIST ,passive_objlist ,@attrs)))))
      (defidiomword (append left 
			    (list (or prespart (concat (strip_e root) 'ing)))
			    right)
	`(VING (t Xn (prog ,trans)
		  OBJLIST ,active_objlist ,@attrs))))))
