;; qx.lisp,v 1.2 2003/07/01 20:36:21 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   "state"
		   ))

(in-package nlp)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (cl-user::confirm-modules "nlp/funtran/qx"
			    ))


(defmacro tell (theme)
  `(let* ((*be-polite-now* nil)		; must set to T when appropriate
	  (pos-set ,theme))
     (if (stringp pos-set)
	 (say-statement pos-set)
       (let* (
	  (de-set pos-set)
	  (orig-set (if (eq (first ',theme) 'SETOF)
			(eval (third ',theme))
		      ,theme))
	  (neg-set (set-difference orig-set pos-set))
	  (semclass (if (consp ',theme)(third (third ',theme))))
	  (response (cond ((null pos-set) ; no cases
			   (case semclass
				 ((thing P-THING) "Nothing.") ; WHQ-N "what"
				 ((agent P-AGENT) "No one.") ; WHQ-N "who"
				 (t       "None."))) ; other WH(N)Q-N
			  ((and (null neg-set) ; no exceptions
				(cdr pos-set)) ; more than one case
			   (cond ((consp (first pos-set))
				  ;; attributive
				  (format nil "~A." (format-answer pos-set)))
				 ((eq (predicate-of ',theme) 'P-EQUAL)
				  ;; WH-BE (who are the fighters?): enumerate
				  (format nil "~A." (format-answer pos-set)))
				 ;; extensional
				 (t (case semclass
					  ((thing P-THING) "Everything.")
					  ((agent P-AGENT) "Everyone.")
					  (t       "All.")))))
			  ;; more cases than exceptions
			  ((and neg-set (> (length pos-set)(length neg-set)))
;;; 10/1/93: Exceptions become focus only in TELLIFALL
;;;			   (setq de-set neg-set)
			   (if (consp (first neg-set))
			       (format t "~A." (format-answer neg-set))
			     (format nil "~A but ~A."
				     (case semclass
					   ((thing P-THING) "Everything")
					   ((agent P-AGENT) "Everyone")
					   (t       "All"))
				     (format-answer neg-set))))
			  ;; otherwise enumerate the cases
			  ((stringp pos-set) (format nil "~A." pos-set))
			  ((symbolp pos-set)
			   (format nil "~A."
				   (format-answer (list pos-set))))
			  (t (format nil "~A."
				     (format-answer pos-set))))))
	 (parser-answer response)
	 (generate-de-for-set de-set)))
     ))

; (defmacro tell (theme)
;   `(let* ((pos-set ,theme)
; 	  (de-set pos-set)
; 	  (orig-set (if (eq (first ',theme) 'SETOF)
; 			(eval (third ',theme))
; 		      ,theme))
; 	  (neg-set (set-difference orig-set pos-set))
; 	  (semclass (if (consp ',theme)
; 			(third (third ',theme))))
; 	  (response (cond ((null pos-set) ; no cases
; 			   (case semclass
; 				 (THING "Nothing.") ; WHQ-N "what"
; 				 (AGENT "No one.") ; WHQ-N "who"
; 				 (t       "None."))) ; other WH(N)Q-N
; 			  ((and (null neg-set) ; no exceptions
; 				(cdr pos-set)) ; more than one case
; 			   (cond ((consp (first pos-set))
; 				  ;; attributive
; 				  (format nil "~A." (format-answer pos-set)))
; 				 ((eq (predicate-of ',theme) 'P-EQUAL)
; 				  ;; WH-BE (who are the fighters?): enumerate
; 				  (format nil "~A." (format-answer pos-set)))
; 				 ;; extensional
; 				 (t (case semclass
; 					  (THING "Everything.")
; 					  (AGENT "Everyone.")
; 					  (t       "All.")))))
; 			  ;; more cases than exceptions
; 			  ((and neg-set (> (length pos-set)(length neg-set)))
; ;;; 10/1/93: Exceptions become focus only in TELLIFALL
; ;;;			   (setq de-set neg-set)
; 			   (if (consp (first neg-set))
; 			       (format t "~A." (format-answer neg-set))
; 			     (format nil "~A but ~A."
; 				     (case semclass
; 					   (THING "Everything")
; 					   (AGENT "Everyone")
; 					   (t       "All"))
; 				     (format-answer neg-set))))
; 			  ;; otherwise enumerate the cases
; 			  ((stringp pos-set)(format nil "~A." pos-set))
; 			  ((symbolp pos-set)
; 			   (format nil "~A."
; 				   (format-answer (list pos-set))))
; 			  (t (format nil "~A."
; 				     (format-answer pos-set))))))
;      (parser-answer response)
;      (generate-de-for-set de-set)))

(defmacro tellifall (theme)
  `(let* ((*be-polite-now* nil)		; must set to T when appropriate
	  (raw-pos-set ,theme)
	  (pos-set (if (consp (first raw-pos-set))
		       (mapcar #'first raw-pos-set)
		     raw-pos-set))
	  (de-set pos-set)
	  (orig-set (if (eq (first ',theme) 'SETOF)
			(eval (third ',theme))
		      ,theme))
	  (neg-set (set-difference orig-set pos-set))
	  (response (cond ((null pos-set) 
			   (if (cdr orig-set) ;Are there 2 or more things?-SCT
			       "No, none." 
			     ;;(if (and *be-polite* *be-polite-now*)
			     ;;"No thanks"
			     "No."))
			  ((null neg-set) 
			   ;;(if (and *be-polite* *be-polite-now*)
			   ;;"Yes, thank you"
			   "Yes.")
			  ((stringp pos-set)(format nil "~A." pos-set))
			  ((<= (length pos-set)(length neg-set))
			   (format nil "No, only ~A." (format-answer pos-set)))
			  ((> (length pos-set)(length neg-set))
;;; 10/1/93: Exceptions become focus only in TELLIFALL
			   (setq de-set neg-set)
			   (format nil "No, not ~A."
				   (format-answer neg-set))))))
     (parser-answer response)
     (generate-de-for-set de-set)))

; Not sure we need this -SCT
;(defmacro collect (var set test &key command)
;  `(let ((,var ,set))
;     (declare (special ,var))
;     ,(if command
;	  (append test (list :command command))
;	test)))
