;;; Release: CMUCL_standalone_port (1.3)
;;; File: record.lisp,v
;;; File date: 2003/07/09 14:38:13 (UTC)
;;; Author: SCT

;;; 

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "general/util"
		   ;; "packages"
		   "macros"
		   ))

(in-package nlp)

(defstruct mesg-and-response mesg lf trans actions)

#|(defstruct object 
  label
  nearest-x
  nearest-y
  distance
  bearing
  description
  ;; surroundedness			;not proximity?
  )
|#

(defparameter *current-mesg-and-response* (make-mesg-and-response))

(defun mesg-and-resp () *current-mesg-and-response*)
  
(defun save-new-mesg (sent)
  (setq *current-mesg-and-response* 
	(make-mesg-and-response :mesg (list sent))))

(defun save-mesg (sent)
  (push sent (mesg-and-response-mesg *current-mesg-and-response*)))

(defun save-speech-response (string)
  (push string (mesg-and-response-actions *current-mesg-and-response*)))

(defun save-action (action)
  (push action (mesg-and-response-actions *current-mesg-and-response*)))

(defun save-lf (lf)
  (setf (mesg-and-response-lf *current-mesg-and-response*) lf))

(defun save-trans (trans)
  (setf (mesg-and-response-trans *current-mesg-and-response*) trans))

(defun record (string)
  ;; (format t "~%[sentence: ~a]~%" string)
  (format t
   "~%;;------------------------------------------------------------------~%~%"
   )
  (with-context (current-context)
	(trim-and-process string) ;;  (process-mesg string nil)
	)
  (mesg-and-resp))

(defun tee (out1 out2 &rest r)
  (apply 'format out1 r)
  (apply 'format out2 r))

(defun batch-test 
  (&key
   (just-grammar nil)
   (input-name "data/test.input")
   (output-name 
    (format nil 
	    "/tmp/~{~s.~2,,,'0@s.~2,,,'0@s.~2,,,'0@s.~2,,,'0@s.~2,,,'0@s.~}~s.~s"
	    ;; (cl-user::prefix input-name ".")
	    (cdddr (nreverse
		    (multiple-value-list 
		     (decode-universal-time (get-universal-time)))))
	    (if (nth-value 7 (decode-universal-time (get-universal-time)))
		t 'f)
	    (nth-value 8 (decode-universal-time (get-universal-time))))))
  (let ((strings? t)
	(input-count 0)
	(matches 0)
	(mismatch-str "Previous mesg/response")
	(*readtable* (copy-readtable nil)))
    (with-open-file (in input-name)
     (handler-case (if (mesg-and-response-p (read in))
		       (setq strings? nil))
		   (error () (format t "Error: Couldn't read ~s" in))))
    (with-open-file (out output-name 
			 :direction :output
			 :if-exists :supersede)
     (cond ((not strings?)		    
	    (format out "; Comparing with ~s~%" input-name)
	    (format out "; Search on '~a' for mismatches~%" mismatch-str)))
     (cl-user::maps 
      #'(lambda (input)
	  (let ((line (if strings?
			  (string-trim
			   '(#\space #\tab #\newline) input)
			(find-if 'stringp (mesg-and-response-mesg input))))
		(*current-gesture*
		 (if (not strings?)
		     (find-if #'(lambda (elt)
				  (and (consp elt)
				       (eq (car elt) 'gesture)))
			      (mesg-and-response-mesg input)))))
	    (cond ((not (or (null line)
			    (equal line "")
			    (eq #\; (elt line 0))))
		   (let ((m+r (record line)))
		     (setf (mesg-and-response-mesg m+r)
			   (reverse (mesg-and-response-mesg m+r)))
		     (setf (mesg-and-response-actions m+r)
			   (reverse (mesg-and-response-actions m+r)))
		     (pprint m+r out)
		     (cond ((not strings?)
			    (incf input-count)
			    (cond ((cl-user::set-equal
				    (mesg-and-response-actions m+r)
				    (mesg-and-response-actions input))
				   (incf matches)
				   (format t "~%; Match~%")
				   (cond
				    ((and 
				      just-grammar
				      (null (mesg-and-response-lf m+r))
				      (null (mesg-and-response-lf input)))
				     (format out "~&;;; Still no LF: ~s"
					     (mesg-and-response-mesg input)))))
				  (t
				   (format t "~%; No match~%")
				   (if (or (not just-grammar)
					   (null (mesg-and-response-lf m+r)))
				       (tee t out (if just-grammar 
						      "~%;; ~a:"
						    "~%; ~a:") mismatch-str))
				   (if (or (not just-grammar)
					   (null (mesg-and-response-lf m+r)))
				       (tee t out
					    (cl-user::comment-with
					     (if just-grammar ";; " "; ")
					     nil "~s~%"
					     (mesg-and-response-mesg input))))
				   (if (null (mesg-and-response-lf m+r))
				       (tee t out "~a"
					    (cl-user::comment-with 
					     (if just-grammar ";; " "; ")
					     nil 
					     "~s~%"
					     (mesg-and-response-lf input))))
				   (if (or (not just-grammar)
					   (null (mesg-and-response-lf m+r)))
				       (tee t out "~a"
					    (cl-user::comment-with 
					     (if just-grammar ";; >" "; ")
					     nil 
					     "~s~%"
					     (mesg-and-response-actions 
					      input))))))
			    (finish-output out))))))))
      input-name
      :reader (if strings? 'read-line 'read))
     (format t "; ~s/~s matches~%" matches input-count) 
     (if (not strings?)
	 (format out "~%~%; ~s/~s matches against ~a~%" 
		 matches input-count input-name)))))
