import java.io.*;
import java.util.*;

/**
 * gesture simulator with IPC messages
 */

public class GestureSim {
    public static String moduleName = "GestureSim";
    public static String Timestamp_FORMAT  = "{double, string}";
    public static String Timestamp_FORMAT_NAME = "Timestamp_FORMAT";
    public static String point3d_FORMAT_NAME = "point3d_FORMAT";
    public static String point3d_FORMAT = "{Meters,Meters,Meters}";
    public static String gestureFormat = "{point3d_FORMAT,point3d_FORMAT,Timestamp_FORMAT}";

    public static String BVS_Sim_3DVector_Gesture_FORMAT_NAME = "BVS_Sim_3DVector_Gesture_FORMAT";
    public static String BVS_Sim_3DVector_Gesture_FORMAT = "{point3d_FORMAT,point3d_FORMAT,Timestamp_FORMAT}";
    public static String BVS_Send_Sim_3DVector_Gesture_Msg = "SendSim3DVector";

    //  static {
    //      System.loadLibrary("libipc_java.so");
    //  }

    GestureSim () {
	IPC.connect(moduleName);
	IPC.defineFormat ("Meters","double");
	IPC.defineFormat(Timestamp_FORMAT_NAME,Timestamp_FORMAT);
	IPC.defineFormat(point3d_FORMAT_NAME,point3d_FORMAT);
	IPC.defineFormat(BVS_Sim_3DVector_Gesture_FORMAT_NAME,
			 BVS_Sim_3DVector_Gesture_FORMAT);
	IPC.defineMsg ("sendtime",Timestamp_FORMAT);
	IPC.defineMsg (BVS_Send_Sim_3DVector_Gesture_Msg,
		       BVS_Sim_3DVector_Gesture_FORMAT);
	IPC.subscribeHandlerChange(BVS_Send_Sim_3DVector_Gesture_Msg,
				   new handlerChangeHnd());
	IPC.subscribeFD(0, new stdinHnd(moduleName));
    }

  

    class stdinHnd implements IPC.FD_HANDLER_TYPE {
	String clientData;
	String [] examples = {"-0.1 -0.2 2.1    -0.2 -0.8 0.1", 
			      "-0.2  0.8 1.5    -0.5  2.1 0.7"};
	double [] [] origins;
	double [] [] destinations;

	void parseExamples () {
	    int len = examples.length;
	    origins = new double[len][3];
	    destinations = new double[len][3];
	    for (int i=0;i<examples.length;i++) {
		StringTokenizer str = new StringTokenizer (examples[i]);
		for (int j=0;j<3;j++) {
		    String token = str.nextToken();
		    origins[i][j] = new Double(token).doubleValue();
		}
		
		for (int j=0;j<3;j++) {
		    String token = str.nextToken();
		    destinations[i][j] = new Double(token).doubleValue();
		}
	    }
	}

	stdinHnd (String moduleName) {
	    parseExamples();
	    presentMenu();
	}

	/**
	 * presents gesture choices
	 * (will need some sort of gui later)
	 */

	void presentMenu () {
	    System.out.println ("---- origin ------   -- destination --");
	    for (int i=0;i<examples.length;i++) 
		System.out.println (i+". " + examples[i]);

	    System.out.println ("Select a gesture number or q to quit:");
	}

	String makeGesture (int gestureIndex) {
	    System.err.println (origins.length + " " + destinations.length + " " + gestureIndex);
	    Gesture gesture = new Gesture();
	    gesture.origin = new Point3d (origins[gestureIndex][0],
					  origins[gestureIndex][1],
					  origins[gestureIndex][2]);
	    gesture.destination = new Point3d (destinations[gestureIndex][0],
					       destinations[gestureIndex][1],
					       destinations[gestureIndex][2]);
	    return gesture.toString();
	}

	/**
	 * read from System.in right now
	 */
	void readFromMenu ()  {
	    //	    int in = System.in.read();
	    //	    System.err.println ("received: " + (char) in);
	    //	    int gestureIndex = Character.getNumericValue((char) in);
	    //  System.out.println ("Gesture: " + gestureIndex);
	    //	    if ( (char) in == 'q' || (char) in == 'Q') {
	    //		IPC.disconnect();
	    //		System.exit(0);
	    //	    }
	    // maybe check for gesture index
	    //	    IPC.publishData (BVS_Send_Sim_3DVector_Gesture_Msg,
	    //			     makeGesture (gestureIndex));

	    try {
		int in = System.in.read();
		if (in == 'q' || in == 'Q') {
		    IPC.disconnect();
		    System.exit(-1);
		} else {
		    int gestureInd = Character.getNumericValue((char) in);
		    System.out.println("stdinHnd ["+ clientData +"]: Received "+ 
			       (char)in + " " + gestureInd);
		    System.out.println (makeGesture(gestureInd));
		    IPC.publishData (BVS_Send_Sim_3DVector_Gesture_Msg,
	    			     makeGesture (gestureInd));
		}
	  // Read in any extra bytes
		while (System.in.available() > 0) System.in.read();
      } catch (Exception e) { e.printStackTrace(); }
	}

	  
	public void handle (int fd) {
	    try {
		while (true) {
		    readFromMenu ();
		    presentMenu ();
		}
	    }
	    catch (Exception e) {
		e.printStackTrace();
		IPC.disconnect();
		System.exit(0);
	    }
	}
    }

  private static class handlerChangeHnd implements IPC.CHANGE_HANDLE_TYPE {
    public void handle (String msgName, int num) {
      System.err.println ("Handler Change: " + msgName + " : " + num);
    }
  }


    
    public class Point3d {
      public double x;
      public double y;
      public double z;

      public Point3d (double x, double y, double z) {
	  this.x = x;
	  this.y = y;
	  this.z = z;
      }

	public String toString () {
	  return  "{ " + x + "," + y + "," + z + " }";
	}
	    
    }

    public class Gesture {
	public Point3d origin;
	public Point3d destination;
	public TimeStamp timestamp;
      public Gesture () {
	    timestamp = new TimeStamp();
	}

	public String toString () {
	  return "{" + origin + "," + destination + "," + timestamp + "}";
	}
	
    }

    public static void main (String args[]) throws Exception {
	new GestureSim();
	IPC.dispatch();
	IPC.disconnect();
    }
}
