import java.util.*;
import java.net.*;


public class TimeStamp {
    public double time;
    public static String hostname;

    static {
	hostname = setHostName();
    }
    
    TimeStamp () {
	time = (new Date()).getTime() / 1000000;
    }

    public String toString() {
      return "{ " + time + ",\"" + hostname + "\" }";
    }

    public static String setHostName () {
	InetAddress localHost = null;
	String host;
	StringBuffer hostbuf;
	try {
	    localHost =  InetAddress.getLocalHost();
	} catch (UnknownHostException e) {     //error message
	}
	host = new String(localHost.getHostName());
	hostbuf = new StringBuffer(host);
	while (hostbuf.length() < 10) 
	    hostbuf.append(" ");
	return hostbuf.toString();
    }


  public static void main (String args[]) throws Exception {
      String Timestamp_FORMAT  = "{double, string}";
      String Timestamp_FORMAT_NAME = "Timestamp_FORMAT";
      IPC.connect("TimeStamp");
      IPC.defineMsg ("sendtime",Timestamp_FORMAT);
      TimeStamp test = new TimeStamp();
      System.err.println (test.toString());
      IPC.publishData("sendtime",test);
    }

}



