;;; Release: CMUCL_standalone_port (1.2)
;;; File: robotalk.lisp,v
;;; File date: 2003/07/14 17:13:51 (UTC)
;;; Author: SCT

;; Note: *HISTORY* and CONTEXT in myrobots.lisp not used here.
;; They should probably be merged in, to the extent they are functional.

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules 
   "packages"
   "config"
   "state"
   ;; "environment"
   "speech-types"
   ;;	   "ff"
   "record"
   ))

(in-package nlp)

(defvar *discourse-stack* nil)	

(defun discourse-top () (car *discourse-stack*))

(defun discourse-pop () (pop *discourse-stack*))

(defun extend-discourse (value) (push value *discourse-stack*))

(defparameter *phony-utterance* 
  (make-instance 'utterance :string "[string not saved]"))

(labels ((say-it (speakbuf)
          (cond ((and (or *evaluate* *talkative*)
		      (or *attention-var* *temporarily-attentive*)
		      (not (eql #\[ (elt speakbuf 0))))
		 (format t "~%~A will say: ~A~%" *robot-name* speakbuf)
		 (setq *have-spoken* t)
		 (save-speech-response speakbuf)
		 (talk (string-trim '(#\[ #\] #\space) speakbuf)))))

	 (say-it-knowingly (speakbuf utterance)
          (extend-discourse utterance)
	  (say-it speakbuf)))

  (defun say-it-unknowingly (speakbuf)
    "Bypasses the discourse stack"
    (say-it speakbuf))

  (defmethod talk-and-echo ((speakbuf null) &key by)
    (declare (ignore by)))

  (defmethod talk-and-echo ((speakbuf string) &key by)
    (declare (ignore by))
    (format t "~%Note: TALK-AND-ECHO speech-type unspecified~%")
    (say-it-knowingly speakbuf *phony-utterance*))

  (defmethod talk-and-echo ((speakbuf utterance) &key by)
    (declare (ignore by))
    (extend-discourse speakbuf)		;TODO shouldn't do this if
					;attention is off
    (say-it-knowingly (string-value speakbuf) speakbuf)))

;;; Call the following instead of TALK-AND-ECHO

(defun ask-question (str &key by)
  (declare (ignore by))
  (talk-and-echo (make-instance 'question :string str)))

(defun ask-what (str &key by)
  (declare (ignore by))
  (talk-and-echo (make-instance 'wh-question :string str)))

(defun ask-where (str predicate &key by)
  (declare (ignore by))
  (talk-and-echo 
   (make-instance 'where-question 
		  :string str :predicate predicate)))

(defun ask-did-you (str &key by)
  (declare (ignore by))
  (talk-and-echo (make-instance 'did-you-question :string str)))

(defun ask-did-you-say (str parse &key by)
  (declare (ignore by))
  (let ((question (make-instance 'did-you-say-question 
				 :string str :parse parse)))
    (talk-and-echo question)))

(defun say-statement (str &key by)
  (declare (ignore by))
  (talk-and-echo (make-instance 'statement :string str)))

(defun crack-joke (str &key by)
  (declare (ignore by))
  (talk-and-echo (make-instance 'little-joke :string str)))

(defun ask-jokingly (str &key by)
  (declare (ignore by))
  (talk-and-echo (make-instance 'joking-question :string str)))

(defun say-answer (str &key by)
  (declare (ignore by))
  "Message relayed from parser (deprecated)"
  (talk-and-echo (make-instance 'answer :string str)))

(defun say-message (str &key by)
  (declare (ignore by))
  "Message relayed from parser (deprecated)"
  (talk-and-echo (make-instance 'message :string str)))
