;; SCT 2/03: added plural form to root plist

(in-package nlp)

(defun defword (word defn &key plural)
  (declare (special *wordlist*))
  (setf (get word 'word-defn)
	(append defn (get word 'word-defn)))
  (setf (get word 'defined-word) t)
  (if plural				;SCT
      (setf (get word 'plural) plural))
  (pushNEW word *wordlist*))

(defun plural (plural? root collective?) ;SCT
  (cond (plural? (if (atom plural?) 
		     (list plural?)
		   plural?))
	(collective? (if (atom root)
			 (list root)
		       root))
	(t
	 (list (concat root 's)))))	;TODO (other general plural forms)

(defun noun-func (&key root plural attributes class Xn)
  (let ((attrs (make_plist_1 attributes))
	(trans (or Xn root)))
    (WHEN CLASS 
	  (setf (get trans 'semantic-classes)
		(IF (CONSP CLASS) CLASS (list class))))
    (defword root
      `(N (t Xn (,trans singular) SINGULAR (t) ,@attrs))
      :plural (plural plural root (member 'collective attributes))) ;SCT
    (defword (or plural
		 (concat root 's))
      `(N (t Xn (,trans plural) PLURAL (t) ,@attrs)))))
