;;; Release: CMUCL_standalone_port (1.2)
;;; File: speech-types.lisp,v
;;; File date: 2003/07/14 17:13:00 (UTC)
;;; Author: SCT

;;; The speech types to which TALK-AND-ECHO may be applied

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   ))

(in-package nlp)

(defclass utterance () ((string :initarg :string
				:accessor string-value)))

(defmethod print-object ((u utterance) stream)
  (format stream "#<~s ~s>"
	  (class-name (class-of u)) 
	  (string-value u)))

(defclass statement (utterance) ())

(defclass little-joke (statement) ())

(defclass message (utterance) ())	;from parser---deprecated

(defclass answer (utterance) ())	;from parser---deprecated

(defclass question (utterance) ())

(defclass joking-question (little-joke question) ())

(defclass wh-question (question) ())

(defclass where-question (wh-question)
  ((predicate :initarg :predicate
	      :accessor predicate-value)))

(defclass yes-no-question (question) ())

(defclass did-you-question (yes-no-question) ())

(defclass did-you-say-question (did-you-question) 
  ((parse :initarg :parse
	  :accessor parse-value)))
