;;; Release: CMUCL_standalone_port (1.5)
;;; File: standalone.lisp,v
;;; File date: 2003/07/16 18:45:04 (UTC)
;;; Author: SCT

;; Call RUN-NAUTILUS to run the system without any interface modules
;; other than the tty.

;; These environment variables should be set:
;;
;;  ROBOTS_HOME = directory where this file is found (default: startup dir)
;;  ROBOT_NAME = one of grace, magneto, coyote, george, etc (default: coyote)
;;
;; The following variables should *not* be set, or set to the empty
;; string, so that no interface module-loads succeed:
;;
;;  GESTURE_C_HOME, CHALLENGE_ROOT, IPC_DIR, IPC_LIBRARY_DIR


(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (export '(run-nautilus			;probably should be elsewhere
	    ))
  (push 'standalone *features*)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   "extract-code"
		   "challenge-wrap"))		   

(defpackage "IPC")

(in-package ipc)

;; Define some dummy macros in place of the real IPC system. (The real one 
;; being the one at: 
;;   http://www-2.cs.cmu.edu/afs/cs/project/TCA/www/ipc/ipc.html)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (export '(ipc_defstruct
	    ipc_defun_handler
	    IPC_ISMSGDEFINED
	    IPC_queryResponseData
	    IPC_PublishData
	    IPC_disconnect
	    IPC_MSGINSTANCENAME
	    IPC_isconnected
	    IPC_connect
	    IPC_SUBSCRIBEFD
	    IPC_listenClear
	    IPC_setverbosity
	    IPC_subscribe)))

(defmacro ipc_defstruct (&rest r))
(defmacro ipc_defun_handler (&rest r))
(defmacro IPC_ISMSGDEFINED(&rest r))
(defmacro IPC_queryResponseData(&rest r))
(defmacro IPC_PublishData(&rest r))
(defmacro IPC_disconnect(&rest r))
(defmacro IPC_subscribe(&rest r))
(defmacro IPC_MSGINSTANCENAME (&rest r))
(defmacro IPC_connect (&rest r))
(defmacro IPC_isconnect (&rest r))
(defmacro IPC_SUBSCRIBEFD (&rest r))
(defmacro IPC_listenClear (&rest r))
;; (defun IPC_setverbosity (&rest r))

(in-package nlp)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (find-package "SYSTEM"))
      (defpackage "SYSTEM"))
  (let ((*package* (find-package "SYSTEM")))
    (export (intern "GETENV")))    
  (cl-user::confirm-modules "proteus"
			    "nlp/proteus/basics/foreach"
			    "nlp/nautilus/src/nautilus"
			    "nlp/proteus/enhance/ptop-core"
			    "nlp/proteus/enhance/semchart"
			    "nlp/funtran/qx"
			    "nlp/tinsel/np-handler" ;shouldn't be needed here
			    "nlp/tinsel/init"       ; "
			    "nlp/tinsel/specify" ;    "
			    "nlp/focal/init"   ;    "
			    "nlp/focal/krdisc"   ;    "
			    "nlp/focal/focalg" ;      "
			    ;;"nlp/funtran/funtran" ;   "
			    ;;"nlp/funtran/qx" ;"
			    ))

(defun make-generic ())

(defun run-nautilus (&optional args)
  (setq *demand-ipc* nil)
  (setq *mmi* nil)
  ;; (cl-user::load-nlp)
  (load-interrob args)
  (run-interrob args '(progn (trace no-mesgs)
			     (trace-parses)
			     (load "nlp/funtran/funtran")
			     (load "nlp/funtran/qx")))
  )


