;; state.lisp,v 1.5 2003/07/14 16:08:54 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
	   (if (not (fboundp 'confirm-modules))
	       (load "general/modules"))
	   (confirm-modules "packages"
			    "environment"
			    ))

(in-package nlp)

(defvar *spatial-init* nil)		;from myrobots.lisp

(defvar *attention-var* t) ;toggled for attention in eg P-LISTEN
(defvar *temporarily-attentive* nil)	;set only when you must
					;talk in spite of *ATTENTION-VAR*u
(defvar *have-spoken* nil)		;set at every utterance
(defvar *yet-to-say* nil)		;things to say as a last resort
(defvar *also-say* nil)			;additional things to say 

(defvar *addressee-is-me* nil)

(defvar *current-goals* '(change-floor))

(defvar *be-polite* t)

(defvar *be-polite-now* nil)	;for eg 'thanks' after a particular reply

(defvar *kb* nil)			;temp

(define-condition bad-utterance (error) ())
(define-condition bad-command (bad-utterance) ())
(define-condition bad-coords (error) ())
(define-condition does-not-parse (error) ())
(define-condition ambiguity (error) ())

(defvar *current-speech-source* nil)	;ME or SOMEBODY-ELSE

(defun who-is-talking ()
  (case *current-speech-source*
	(me *self*)
	(somebody-else 'somebody)
	(t nil)))

(let ((I-addressed nil)
      (somebody-else-addressed nil))
  (defun last-named-addressee (&key (by *current-speech-source*))
    (cond ((eq by 'me) I-addressed)
	  ((eq by 'somebody-else) somebody-else-addressed)
	  (t (list (cons :by 'me) I-addressed
		   (cons :by 'somebody-else) somebody-else-addressed))))
  (defun set-named-addressee (&key (by *current-speech-source*)
				   to)
    (cond ((eq by 'me) (setq I-addressed to))
	  ((eq by 'somebody-else) (setq somebody-else-addressed to))
	  (t nil)))			;TODO internal error
  )
	   
