;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;translatelf.lisp,v 1.4 2003/07/08 18:28:33 thomas Exp
(in-package :NLP)


(defun querify (qx &key not)
  (cond ((consp qx)
	 (case (first qx)
	       (NOT (querify (second qx) :not (not not)))
	       ((SETOF FORALL EXISTS EXISTS!)
		(list (first qx)
		      (second qx)(third qx)
		      (querify (fourth qx) :not not)))
	       (t (append qx (list :query t)(if not (list :not t))))))
	(t qx)))

(defun tellify (form)
  (if (and (listp form)
	   (string= 'tell (car form) :end2 4))
      (list (first form) (querify (second form)))
    form))

(defun simplify-qx (qx)
  (let ((nlist *alt-foc-list*))		;TODO: NLIST is in qx. 
    (declare (special nlist))		;  Check: what's the right method here?
    (cond ((atom qx) qx)
	  ((member (car qx) '(forall exists exists! setof))
	   (let ((set (eval (third qx))))
	     (cond ((and set (null (cdr set)))
		    (simplify-qx
		     (subst (list 'quote (car set)) (second qx) (fourth qx))))
		   (t (list (first qx) (second qx) (third qx)
			    (simplify-qx (fourth qx)))))))
	  ((member (car qx) '(not))	;TODO: Check negation. Sometimes wrong
	   (list 'not (simplify-qx (second qx))))
	  (t qx))))			;TODO simplify other forms

(defun quantify-simplify (lf &rest r)
  (simplify-qx (apply 'quantify lf r)))

(defun translate-lf (lf &key wh object you)
  (declare (special current-context))
  (when lf
	(transform-identity lf)
	(case (first lf)
	      (AND 
		   (list 'PROGN
			 (translate-lf (second lf) :wh wh :object object :you you)
			 ;;if the first command didn't succeed, don't continue
			 (list 'and (list 'context-success 'current-context)
			 (translate-lf (third lf) :wh wh :object object :you you))
			 ))
	      (ADDRESS (let ((you (second lf)))
			 (setf (fourth you) 'YOU)
			 (translate-lf (third lf) :you you)))
	      (ASKWH (tellify
		      (add-performative (case (first (second lf))
					      (WHICH 'ASKWH)
					      (where-at-which 'askwh) ;SCT
					      (MANY  'ASKCOUNT)
					      (MUCH  'ASKQUANT)
					      (t     'ASKWH))
					(quantify-simplify
					 (third lf)
					 :you you
					 :wh (second lf)))))
	      ((REQUEST IMPER)
	       (tellify
		(add-performative (first lf) (quantify-simplify
					      (cdr lf) :you you))))
	      (t (quantify-simplify lf :wh wh :object object :you you)))))


(defun more-than-one-exists (tr)
  (cond ((and (consp tr)
	      (eq (car tr) 'setof))
	 (let ((nlist *alt-foc-list*)) ;TODO: NLIST is in qx. 
	   (declare (special nlist)) ;  Check: what's the right method?
	   (let ((set (eval tr)))
	     (cdr set))))
	(t (format t "Warning: internal error, expecting SETOF")
	   nil)))

(defun nice-translation (tr)
  (case (car tr)
	(tellif
	 (case (car (second tr))
	       (exists!
		(if (more-than-one-exists (third (second tr)))
		    (list 'tellifany 
			  (cons 'setof (cdr (second tr))))))
	       (t tr)))
	(exists!
	 (if (more-than-one-exists (third tr))
	     (list 'tell (format nil "There exists more than one ~(~s~)"
				 (third (third tr))))))
	(t tr)))  

(defun process-lf-helper (trans)
  (let ((trans2 (nice-translation trans)))
    (display-tr trans)
    (if (not (equal trans trans2))
	(display-tr trans2 "Re-translation"))
    (setq trans trans2)
    (setf *previous-qx* trans)
    (save-trans trans)
    (display-des)
    (process-translation trans *alt-foc-list*)))

(defun performatives-p (tr)
  (declare (special *performatives*))
  (and (consp tr)
       (every #'(lambda (tr1)
                  (and (consp tr1)
                       (member (car tr1) (cons 'FORALL *performatives*))))
              tr)))

(defun process-lf (lf &aux tr)
  (declare (special *alt-foc-list* *previous-qx*))
  (display-lf lf)
  (save-lf lf)
  (setq tr (translate-lf lf))
  (if (performatives-p tr)
      (mapc #'(lambda (trans)
                (process-lf-helper trans)) tr)
    (process-lf-helper tr)))



