;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package NLP)

(defun vv-uncertain-parse-p (voice-string)
  (and (char= (aref voice-string 0) #\?)
       (char= (aref voice-string 1) #\?)))

(defun listify-mesg (mesg)
  (let ((*readtable* (copy-readtable nil)))
    (set-readtable)
    (listify mesg)))

(defun viavoice-parse (mesg)
  (let* ((vmesg (string-left-trim '(#\?) mesg))
         (lexlkup (lexical-lookup (append1 (listify-mesg vmesg) '|.|)))
         (parse (parse 'SENTENCE (car lexlkup) (cadr lexlkup) 'english-parser)))
    (if parse
        (talk-and-echo (format nil "Did you say ~A?" vmesg))
      (talk-and-echo "What?"))))

;; general pattern capability

(defparameter *viavoice-rules*
  '(((?* ?x) hundred (?* ?y))
    ((?* ?x) hundred (?* ?y))))

(defun convert-100s-1 (listified-mesg)
  ;;1 hundred 12
  (let ((hundredpos (position 'hundred listified-mesg))
	 (precededbynum))
    (when (and hundredpos
	       (numberp (setf precededbynum (nth (1- hundredpos) listified-mesg))))
      ;;assume the preceding word is a number
      (return-from convert-100s-1
       (append (subseq listified-mesg 0  (1- hundredpos))
	      (cons (* precededbynum 100) nil)
	      (subseq listified-mesg (1+ hundredpos)))))
    listified-mesg))

(defun convert-100s-2 (listified-mesg)
  ;;1 hundred 12
  (let ((hundredpos (position 'hundred listified-mesg))
	(precededbynum )
	(followedbynum  ))
    (when (and hundredpos
	       (numberp (setf precededbynum (nth (1- hundredpos) listified-mesg)))
	       (numberp (setf followedbynum (nth (1+ hundredpos) listified-mesg))))
      ;;assume the preceding word is a number
      (return-from convert-100s-2
       (append (subseq listified-mesg 0  (1- hundredpos))
	      (cons (+  (* precededbynum 100) followedbynum) nil)
	      (subseq listified-mesg (+ hundredpos 2)))))
    listified-mesg))
      

(defun convert-100s-3 (listified-mesg)
  ;; 1 hundred and 5 
   (let ((hundredpos (position 'hundred listified-mesg))
	  (precededbynum)
	  (followedbynum))
    (when (and hundredpos
	       (numberp (setf precededbynum
			      (nth (1- hundredpos) listified-mesg)))
	       (eql (nth (1+ hundredpos) listified-mesg) 'and)
	       (numberp (setf followedbynum
			      (nth (+ hundredpos 2) listified-mesg))))
      ;;assume the preceding word is a number
      (return-from convert-100s-3
       (append (subseq listified-mesg 0  (1- hundredpos))
	      (cons (+  (* precededbynum 100) followedbynum) nil)
	      (subseq listified-mesg (+ hundredpos 3)))))
    listified-mesg))

  
;; bandaid function
;; in the meantime that will do		     

(defun convert-100s (mesg)
  (restringify (convert-100s-1
		(convert-100s-2
		 (convert-100s-3 (listify-mesg mesg))))))

;; 
;; 
;; from old transfun
;;
;(defun convert-100s (mesg)
;  (let ((listified-sentstring (listify-mesg mesg))
;        (new-number-for-sentstring))
;    (setf listified-sentstring
;          (cond 
;           ((and (eq (fifth listified-sentstring) 'hundred)
;                 (numberp (sixth listified-sentstring)))     
;            (progn
;              (setf new-number-for-sentstring (+ (* (fourth listified-sentstring) 100)
;                                                 (sixth listified-sentstring)))
;              (nsubstitute new-number-for-sentstring
;                           (fourth listified-sentstring) listified-sentstring)
;              (dotimes (x 2)
;                (delete (fifth listified-sentstring) listified-sentstring)
;                (incf x))))
;           ((and (eq (fifth listified-sentstring) 'hundred)
;                 (and (eq (sixth listified-sentstring) 'and)
;                      (numberp (seventh listified-sentstring))))
;            (progn
;              (setf new-number-for-sentstring (+ (* (fourth listified-sentstring) 100)
;                                                 (seventh listified-sentstring)))
;              (nsubstitute new-number-for-sentstring
;                           (fourth listified-sentstring) listified-sentstring)
;              (let ((x 0))
;                (while (< x 3)
;                  (delete (fifth listified-sentstring) listified-sentstring)
;                  (incf x)))))
;                
;           ((and (eq (fifth listified-sentstring) 'hundred)
;                 (not (numberp (sixth listified-sentstring))))
;            (progn
;              (setf new-number-for-sentstring 
;                    (* (fourth listified-sentstring) 100))
;              (nsubstitute new-number-for-sentstring
;                           (fourth listified-sentstring) listified-sentstring)
;              (delete 'hundred listified-sentstring)))
;               
;           ((and (eq (fourth listified-sentstring) 'hundred)
;                 (numberp (fifth listified-sentstring))) 
;            (progn
;              (setf new-number-for-sentstring (+ (* (third listified-sentstring) 100)
;                                                 (fifth listified-sentstring)))
;              (nsubstitute new-number-for-sentstring
;                           (third listified-sentstring) listified-sentstring)
;              (delete 'hundred listified-sentstring)
;              (delete (fourth listified-sentstring) listified-sentstring)))
;               
;           ((and (eq (fourth listified-sentstring) 'hundred)
;                 (and (eq (fifth listified-sentstring) 'and)
;                      (numberp (sixth listified-sentstring))))
;            (progn
;              (setf new-number-for-sentstring (+ (* (third listified-sentstring) 100)
;                                                 (sixth listified-sentstring)))
;              (nsubstitute new-number-for-sentstring
;                           (third listified-sentstring) listified-sentstring)
;              (delete 'hundred listified-sentstring)
;              (let ((x 0))
;                (while (< x 2)
;                  (delete (fourth listified-sentstring) listified-sentstring)
;                  (incf x))))) 
;           ((and (eq (fourth listified-sentstring) 'hundred)
;                 (not (numberp (fifth listified-sentstring))))
;            (progn
;              (setf new-number-for-sentstring
;                    (* (third listified-sentstring) 100))
;              (nsubstitute new-number-for-sentstring
;                           (third listified-sentstring) listified-sentstring)
;              (delete 'hundred listified-sentstring)))))
;    (restringify new-number-for-sentstring)))
;
;
;
;  
;  
