#!/usr/bin/python
# -*- coding: utf-8 -*-


import Image, ImageSequence
import os
import re
import sys

chineseNumerals = [
#financial, normal
[u"零", u"〇"],
[u"壹", u"一"], 
[u"贰", u"二"],
[u"叁", u"三"],
[u"肆", u"四"], 
[u"伍", u"五"], 
[u"陆", u"六"],
[u"柒", u"七"],
[u"捌", u"八"],
[u"玖", u"九"],
]

chineseTen = [u"拾", u"十"]
chineseHundred = [u"佰", u"百"]

#What do I do with this image?
image = Image.open("puzzle.gif")

palette = image.getpalette()
i = 0
while palette[i*3] != i:
    print chr(palette[i*3]), chr(palette[i*3+1]), chr(palette[i*3+2])
    i += 1
print

#OK, give me the pixels:

pixels = image.getdata()
utf8 = "".join(chr(c) for c in pixels)
unicodedata = utf8.decode("utf-8")

# What do they look like?
print "unicode looks like:"
print unicodedata[:10]

#chinese numbers separated by spaces, apparently.  Let's parse them.
def parseChineseDigit(digit):
    for i, (f, n) in enumerate(chineseNumerals):
        if f == digit or n == digit:
            return i
    print "could not parse", digit

def parseChineseNumber(number):
    out = 0
    i= 0
    for c in number:
        digit = parseChineseDigit(c)
        out *= 10
        out += digit
    return out

chineseNumbers = unicodedata.strip().split(" ")
numbers = map(parseChineseNumber, chineseNumbers)

print "numbers look like"
print numbers[:10]
#I bet they're unicode again
data = "".join(map(chr, numbers))
try:
    out = data.decode("utf-8")
except Exception, e:
    print e
    print "could not parse as utf-8"
    print 
    out = data

print out[:10]
print "hey, that doesn't look like utf-8 -- that looks like animated GIF. Let's see it."

f = open("output-from-chinese.gif", "w")
f.write(data)
f.close()

print "now you want to view output-from-chinese.gif.  I'll wait until you press enter."

raw_input()

print """Looks like Hebrew letters, which are also Hebrew numbers.  We'll
have to identify each letter.  I'm going to write each unique frame to
a separate file, called hebrew-unidentified-N.gif, where N is the order
in which they appear in this file.  Then you will rename them to 
hebrew-red-M.gif, where M is the value of the letter (use blank.gif for
the blank frame).  We'll ignore the colors for now since we do not know
what to do with them."""

image = Image.open("output-from-chinese.gif")

def withFrames(image, fn):
    try:
        while 1:
            fn(image)
            image.seek(image.tell()+1)        
    except EOFError:
        pass # end of sequence

seenImages = set()
def saveUnidentifiedImage(image):
    def redden(p):
        if p > 0:
            return 1
        else:
            return 0
    newImage = image.point(redden)
    imageDataAsString = "".join(map(chr,newImage.getdata()))

    if not imageDataAsString in seenImages:
        seenImages.add(imageDataAsString)
        newImage.save("hebrew-unidentified-%d.gif" % len(seenImages))
withFrames(image, saveUnidentifiedImage)

print "When you're done renaming, press enter"
raw_input()

print "Loading hebrew mapping"
imageDataToNumberMap = {}

name_re = re.compile("hebrew-red-(\d+).gif")
for file in os.listdir('.'):
    match = name_re.match(file)
    if match:
        n = int(match.group(1))
        image = Image.open(file)
        imageDataAsString = "".join(map(chr,image.getdata()))
        imageDataToNumberMap[imageDataAsString] = n
    elif file == "blank.gif":
        image = Image.open(file)
        imageDataAsString = "".join(map(chr,image.getdata()))
        imageDataToNumberMap[imageDataAsString] = -1

if len(imageDataToNumberMap) < len(seenImages):
    print "didn't read enough files -- got %d, expected %d" % (len(imageDataToNumberMap), len(seenImages))
    sys.exit(1)

print "Now we'll interpret the hebrew..."
image = Image.open("output-from-chinese.gif")

hebrew_numbers = []
n = 0

def convertImageToNumber(image):
    global n
    def redden(p):
        if p > 0:
            return 1
        else:
            return 0
    newImage = image.point(redden)

    imageDataAsString = "".join(map(chr,newImage.getdata()))

    digit = imageDataToNumberMap[imageDataAsString]
    if digit == -1:
        hebrew_numbers.append(n)
        n = 0
    else:
        n += digit

image = Image.open("output-from-chinese.gif")
withFrames(image, convertImageToNumber)

print hebrew_numbers[:10]

print "looks like another gif"


data = "".join(chr(x % 256) for x in hebrew_numbers)
f = open("output-from-hebrew.gif", "w")
f.write(data)
f.close()

print "now, examine output-from-hebrew.gif (press enter when done)"
raw_input()

print "oh, so that's what the colors were about."

#now we will analyze the hebrew in term of colors
hebrew_colors = []
last = "eof"
def getHebrewColors(image):
    global last
    for x in image.getdata():
        if x == 1: #blue -- we learned this from the palette of the gif
            if last == "eof" or last == 1:
                hebrew_colors.append(0)
                last = 0
            return
        elif x == 2: #red
            if last == "eof" or last == 0:
                hebrew_colors.append(1)
                last = 1
            return

    last = "eof"
    return

image = Image.open("output-from-chinese.gif")
withFrames(image, getHebrewColors)


#and we will handle the even/odd rule
hebrew_colors = [color ^ (hebrew_numbers[i] % 2) for i, color in enumerate(hebrew_colors)]

def makeBytes(bits):
    out = []
    for i in range(0, len(bits), 8):
        byte = 0
        for j in range(8):
            byte *= 2
            byte += bits[i+j]
        out.append(byte)
    return out

assert "".join(map(chr, makeBytes(map(int, '0110010101011001')))) == 'eY'

chars_from_hebrew = map(chr, makeBytes(hebrew_colors))
print "hebrew letters start with:"
print chars_from_hebrew[:10]

print "looks like utf-8.  Let's see the whole thing:"

hebrew_decoded = "".join(chars_from_hebrew).decode("utf-8")
print hebrew_decoded

print "OK, now we know how to decode the Chinese"

def normalOrFinancial(number):
    digit = number[0]
    for i, (f, n) in enumerate(chineseNumerals):
        if f == digit:
            return 1
        elif n == digit:
            return 0
    print "could not parse", digit


bits = map(normalOrFinancial, chineseNumbers)
#even / odd
numbers = [color ^ (numbers[i] % 2) for i, color in enumerate(bits)]
chinese_decoded = makeBytes(numbers)

out = "".join(map(chr, chinese_decoded))

print "decoded chinese starts with"
print out[:10]

print "another gif!"

f = open("final.gif", "w")
f.write(out)
f.close()

print "saved as final.gif"
