/************************************************************************/
/*                                                                      */
/* Takes a completed ps array and writes a dummy A-file record to the   */
/* specified file for each instance of an unprocessed colour code in    */
/* psarray in memory.  Used to generate reprocessing lists.             */
/* based PS file.                                                       */
/*                                                                      */
/*      Inputs:         psarray         Complete with pointers and qc's */
/*                                                                      */
/*      Output:         filename        created on disk                 */
/*                      return value    0=good, 1=bad                   */
/*                                                                      */
/* Created 29 January 2001 by CJL                                       */
/*                                                                      */
/************************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>
#include <time.h>
#include "summary.h"
#include "adata.h"
#include "psplot.h"
#include "aedit.h"
#include "mk4_afio.h"

int write_reproc (struct ps_array *psarray, char *filename)
    {
    fringesum fdatum;
    int bnd, scn, bsl, nbase, nbands, nscan;
    char band;
    time_t now;
    FILE *fp;
    struct psplot_cell *cell;
    struct stat statbuf;
    extern struct datasumm fsumm;
                                        /* Check out requested filename */
    if (stat (filename, &statbuf) == 0)
	    {
	    if (statbuf.st_size != 0)
	        if (! confirm ("File exists and contains data.  Proceed?")) return (1);
	    }
    else if (errno != ENOENT)
	    {
	    msg ("problem %d with output file %s", 2, errno, filename);
	    return (1);
	    }
                                        /* Open file and insert header info */
    if ((fp = fopen (filename, "w")) == NULL)
	    {
	    msg ("Could not open file for output", 2);
	    return (1);
	    }

    now = time (NULL);
    fprintf(fp,"* This file generated by AEDIT, %s", ctime (&now));

                                        /* Loop over all cells in psarray */
    nbase = psarray->nbaselines;
    nbands = strlen (psarray->subgroups);
    nscan = psarray->nscans;
    for (scn=0; scn<nscan; scn++)
        {
        for (bsl=0; bsl<nbase; bsl++)
            {
                                        /* Now loop over bands and get baseline qcodes */
            for (bnd=0; bnd<nbands; bnd++)
                {
                band = psarray->subgroups[bnd];

                cell = psarray->baseline[bsl].scan + scn;
                if (cell->colour_index[bnd] != UNPROC) continue;
                                        /* Fill up a dummy A-file structure */
                clear_fsumm (&fdatum);
                strcpy (fdatum.root_id, "aaaaaa");
                strcpy (fdatum.source, "anysource");
                strcpy (fdatum.scan_id, psarray->time[scn].scan_name);
                fdatum.baseline[0] = psarray->baseline[bsl].id[0];
                fdatum.baseline[1] = psarray->baseline[bsl].id[1];
                fdatum.baseline[2] = '\0';
                fdatum.freq_code = psarray->subgroups[bnd];
                fdatum.expt_no = fsumm.experiments[0];
                                        /* And write it out */
                if (write_fsumm (&fdatum, fp) != 0)
                    {
                    msg ("Error writing fake data to reprocessing list", 2);
                    return (1);
                    }
                }
            }
        }

    fclose (fp);
    return (0);
    }
