#!/bin/sh
#  environment setup -- HOPS_SETUP is not set or false
#
# ${HOPS_SETUP-'false'} || . $srcdir/chk_env.sh

hops=../../hops.bash
tste=$bindir/env_check
verb=false
[ -n "$testverb" ] && verb=true && HOPS_QUIET='' || HOPS_QUIET=true

$verb &&
    echo srcdir is $srcdir &&
    echo bindir is $bindir

# normal setup
[ -n "$bindir" -a -d "$bindir" -a -x "$tste" -a -x $hops ] && {
    . $hops
    $verb && echo path set up using $hops
    true
} || {
    rm -rf ./path
    mkdir ./path
    cd ./path
    for e in adump aedit alist average bispec calamp cofit \
	     coterp fold fourfit fourmer fplot fringex \
	     linkdata pratio search
    do
	[ -x ../../../postproc/$e/$e ] && ln -s ../../../postproc/$e/$e .
    done
    export PATH=`pwd`:$PATH
    [ -z "$LD_LIBRARY_PATH" ] && LD_LIBRARY_PATH=/dev/null
    export LD_LIBRARY_PATH LD_LIBRARY_PATH=$PGPLOT_DIR:$LD_LIBRARY_PATH
    export DEF_CONTROL=/dev/null
    $verb &&
	echo make links in `pwd` &&
	echo PATH is $PATH &&
	echo LD_LIBRARY_PATH is $LD_LIBRARY_PATH &&
	echo DEF_CONTROL is /dev/null
    cd ..
}

#
# eof
#
