/************************************************************************/
/*									*/
/* Deals with everything on the command line.				*/
/*									*/
/*	Inputs:		argc, argv	command line args		*/
/*									*/
/*	Output:		fpout		output file pointer		*/
/*			display		For graphical output		*/
/*			return value	0=OK, 1=BAD			*/
/*									*/
/* Created October 5 1995 by CJL					*/
/*									*/
/************************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "cpgplot.h"
#include "search.h"

int
parse_cmdline (argc, argv, fpout, plot)
int argc;
char **argv;
FILE **fpout;
int *plot;
    {
    char c, outfile[100], device[100];
    int i;
    extern char *optarg;
    extern int optind, msglev;
					/* Defaults */
    *fpout = stdout;
    *plot = FALSE;
                                        /* parse command line and read in */
                                        /* filename */
    while ((c = getopt (argc, argv, "d:m:o:x")) != -1)
        {
        switch (c)
            {
					/* File away the display string */
	    case 'd':
		strcpy (device, optarg);
		*plot = TRUE;
		break;
					/* Verbosity control */
            case 'm':
                if (sscanf (optarg, "%d", &msglev) != 1)
                    {
                    msg ("Invalid -m flag argument '%s'", 2, optarg);
                    msg ("Message level remains at %d", 2, msglev);
                    }
                if (msglev > 3) msglev = 3;
                if (msglev < -3) msglev = -3;
                break;
					/* Output override, default stdout above */
            case 'o':
                strcpy (outfile, optarg);
		if ((*fpout = fopen (outfile, "w")) == NULL)
                    {
                    msg ("Could not open output file '%s'", 3, outfile);
                    return (1);
                    }
                break;

	    case 'x':
		strcpy (device, "/XW");
                *plot = TRUE;
                break;

            case '?':
            default:
                syntax();
                return (1);
            }
        }
					/* Input files on command line handled */
					/* in main routine.

					/* Open plot device */
    if (plot)
	{
	if (cpgbeg (0, device, 1, 1) != 1)
	    {
	    msg ("Could not open pgplot device '%s', abort.", 3, device);
	    exit (1);
	    }
	cpgsubp (2, 2);
	}

    return (0);
    }


