/************************************************************************/
/*									*/
/* AVERAGE - program to determine averages of A-format data.  Typical	*/
/* input is an A-file of short data segments generated by program	*/
/* "fringex".  The output is another A-file with one line per scan.   	*/
/* See the documentation file for details.				*/
/*									*/
/* Created March 1994 by AEER/SSD					*/
/* Integrated into MkIV software system by CJL, April 1994		*/
/* Redesigned from the ground up, CJL September 1994 and February 1995	*/
/*									*/
/************************************************************************/
#include <stdio.h>  
#include <math.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <errno.h>
#include "average.h"
#include "mk4_util.h"

char progname[8] = "average";
int msglev = 1;
int datatype = 0;
int space = 500;

int
main (int argc,
      char *argv[])
    {
    int id, src, nseg, nout, new_avg, nsrc, read_return;
    seg_data *data;
    summary dsumm[MAXSRC], *srcsum;
    tbsumm *idsum;
    FILE *fp, *fpout;
    struct stat statbuf;
    struct config configuration;
    extern int optind;

    account ("!BEGIN");
					/* Allocate some space to start */
    data = (seg_data *) calloc (space, sizeof (seg_data));
    if (data == NULL)
	{
	perror ("calloc");
	msg ("Could not allocate memory for main data array.", 3);
	exit (1);
	}
					/* Interpret command line */
    if (parse_cmdline (argc, argv, &fpout, &configuration) != 0) 
	exit (1);
					/* After parse_cmdline, optind points */
					/* at the argument following command */
					/* line flags.  Open the file */
					/* If no files specified, uses stdin */
    if (optind == argc) fp = stdin;
    else if (stat (argv[optind], &statbuf) != 0)
        {
        if (errno == ENOENT) msg ("File '%s' does not exist", 3, argv[optind]);
        else msg ("Problem accessing file '%s'", 3, argv[optind]);
        return (-1);
        }
    else if ((fp = fopen (argv[optind],"r")) == NULL)
        {
        msg ("Problem opening '%s'", 3, argv[optind]);
        return (-1);
        }
    if (configuration.account) account ("Get inputs");
					/* Read the data in pieces delimited */
					/* by special *endofscan comments in */
					/* order to support automated modes */
    nout = 0;
    read_return = ENDOFSCAN;
    while (read_return == ENDOFSCAN)
	{
	nseg = 0;
	read_return = read_data (&data, fp, configuration, &nseg);
	if (read_return == -1) break;
	if (configuration.account) account ("read data");
					/* Zero records means terminate */
	if (nseg == 0) break;
					/* Sort data into proper order */
	if (sort_data (data, nseg) != 0)
	    break;
	if (configuration.account) account ("sort data");
					/* Figure out what we have */
	if ((nsrc = assess_data (data, nseg, configuration, dsumm)) <= 0)
	    {
	    msg ("No valid data.", 3);
	    break;
	    }
	if (configuration.account) account ("assess data");
					/* Loop over sources */
	for (src=0; src<nsrc; src++)
	    {
	    srcsum = dsumm + src;
					/* This source flagged? */
	    if (! srcsum->valid) continue;
					/* Loop over baselines/triangles */
	    for (id=0; id<srcsum->nid; id++)
		{
		idsum = srcsum->tribase + id;
					/* This baseline/triangle flagged? */
		if (! idsum->valid) continue;

		new_avg = 0;
		if (datatype == 2)
		    new_avg = baseline_avg (data, idsum, configuration, fpout);
		else if (datatype == 3)
		    new_avg = triangle_avg (data, idsum, configuration, fpout);
		nout += new_avg;
		}
	    }
	if (configuration.account) account ("average data");
	}

    if (nout > 0)
	msg ("Wrote %d averaged output records", 1, nout);

    if (configuration.account) account ("!REPORT");

    exit(0);
    }
