/************************************************************************/
/*									*/
/* Corrects the incoherent SNR values generated by average to the value	*/
/* they would have if the peak SNR was close to the incoherent		*/
/* detection threshold.  Since the shape of the SNR/segtime curve is	*/
/* a function of SNR, we must recalculate the SNRs for the marginal	*/
/* detection case in order to fit the peak for the optimal segmentation */
/* time for weak sources.						*/
/*									*/
/*	Inputs:		codatum		1 baseline/scan, many segtimes	*/
/*			npt		Number of segtimes present	*/
/*									*/
/*	Output:		codatum		duly normalized SNR values	*/
/*			return value	0=OK, else bad			*/
/*									*/
/* Created January 10, 1996 by CJL					*/
/*									*/
/************************************************************************/
#include <math.h>
#include "cofit.h"

int
normalize_snr (codatum, npt)
struct cosummary *codatum;
int npt;
    {
    int i;
    double snrseg[50], s, snra, n, s5, ratio, maxratio, maxsnra;

    maxratio = maxsnra = 0.0;
    for (i=0; i<npt; i++)
	{
					/* Calculate the SNR per segment */
					/* Remember peak SNRA */
	snra = codatum->snr[i];
	if (snra > maxsnra) maxsnra = snra;
	if ((n = codatum->navg[i]) == 0.0) 
	    {
	    msg ("Zero weight in input datum", 2);
	    return (1);
	    }
	snrseg[i] = sqrt ((2.0 / n) * (snra*snra + snra * sqrt(snra*snra + n)));
					/* Calculate segment SNR needed to */
					/* get SNRA of 5.0, and keep track of */
					/* max normalization ratio for all seglens */
	s5 = sqrt ((2.0 / n) * (25.0 + 5.0 * sqrt(25.0 + n)));
	ratio = snrseg[i] / s5;
	if (ratio > maxratio) maxratio = ratio;
	}
					/* Now recalculate the snra values, */
					/* based on peak SNRA of 5.0, but */
					/* renormalizing back to original peak */
					/* SNRA value */
    for (i=0; i<npt; i++)
	{
	n = codatum->navg[i];
	s = snrseg[i] / maxratio;
	printf("datum=%d   old_snr = %f",i,codatum->snr[i]);
	codatum->snr[i] = (maxsnra/5.0) * (sqrt(n)/2.0) * s*s / sqrt(1.0 + s*s);
	printf("  new_snr = %f\n",codatum->snr[i]);
	}

    return (0);
    }
