#define FALSE 0
#define TRUE  1

#include "adata.h"

#define MAX_BNO 66 			/* 20 telescopes */
#define MAX_NRATE 300			/* Reasonable maximums */
#define MAX_NDELAY 50

typedef struct
    {
    int		order;
    int		lastorder;
    int		keyval;
    fringesum	fdata;
    } avg_data;

struct srchsummary
    {
    fringesum	*datum;			/* Data structure ptr for this scan */
    int		nd;
    fringesum   *darray[MAX_NRATE * MAX_NDELAY];
    int		nrate;
    int		ndelay;
    float	min_rate;
    float	max_rate;
    float	min_delay;
    float	max_delay;
    float	snr[MAX_NRATE][MAX_NDELAY];
    };
