// abstract.cpp - class function definitions for abstract mechanical components

#include "abstract.h"

CrossAxle::CrossAxle(WithHole &comp, Measure ilen) {
  axis = comp.getAxis();
  loc = comp.getLoc() - ilen * axis;  // adjust for position

  Through(comp, ilen);

  width = dr;
  color = 0;

  fixed = false;
}

CrossAxle::CrossAxle(Vector nloc, Vector naxis) {
  axis = naxis.unit();
  loc = nloc;

  width = dr;
  color = 0;

  fixed = true;
}

void CrossAxle::Draw() const {
  SystemNode *currnode;
  AxleComponent *currcomp;
  Measure toplen = 0, botlen = 0;

  for (currnode = &axlesys; currnode && currcomp = currnode->getContact();
       currnode = currnode->getNext()) {
    if (currnode->ilen > toplen)
      toplen = currnode->ilen;
    if (currnode->ilen < botlen)
      botlen = currnode->ilen;
  }

  CDrawLine(loc + axis * toplen, loc + axis * botlen, width, color);
}

void CrossAxle::Info() const {}

Measure CrossAxle::updateSystem(Measure dt) {
  SystemNode *currnode;
  AxleComponent *currcomp;

  Measure testdt;

  for (currnode = &axlesys; currnode && currcomp = currnode->getContact();
       currnode = currnode->getNext())
    if ((testdt = currcomp->Update(uptime)) < uptime)
      uptime = testdt;

  return uptime;
}

Measure CrossAxle::dtneeded() const {
  return largeval;
}

void CrossAxle::makeChanges(Measure dt) {}

void CrossAxle::Through(AxleComponent &ngear, Measure ilen) {
  if (axlesys.AddContact(ngear, ilen))
    ngear.Along(*this, ilen);
}

void CrossAxle::Rotate(Measure nomega) {
  SystemNode *currnode;
  Gear *currcomp;

  if (nomega != omega) {
    omega = nomega;

    for (currnode = &axelsys; currnode && currcomp = currnode->getContact();
	 currnode = currnode->getNext()) {
      currcomp->Rotate(omega);
    }
  }
}

Vector CrossAxle::getLoc() const {
  return loc;
}

Vector CrossAxle::getAxis() const {
  return axis;
}

AxleComponent::AxleComponent {
  axle = 0;
}

void AxleComponent::Along(CrossAxle &naxle, Measure nilen) {
  if (!axle) {
    axle = &naxle;
    ilen = nilen;
    naxle.Through(*this, ilen);
  }
}

IdealGear::IdealGear(unsigned nteeth) {
  teeth = max(nteeth, 3);
  axle = 0;
  radius = .1;
  color = 0;
}

void IdealGear::Draw() const {
  Vector axis = axle->getAxis();
  CFillCircle(axle->getLoc() + axis * ilen, axis, radius, color)
}

void IdealGear::Info() const {
  cout << omega;
}

Measure updateSystem(Measure dt) {
  SystemNode *currnode;
  IdealGear *currcomp;

  Measure testdt;

  if ((testdt = axle->Update(uptime)) < uptime)
    uptime = testdt;

  for (currnode = &meshsys; currnode && currcomp = currnode->getContact();
       currnode = currnode->getNext())
    if ((testdt = currcomp->Update(uptime)) < uptime)
      uptime = testdt;

  return uptime;
}

Measure IdealGear::dtneeded() const {
  return largeval;
}

void makeChanges(Measure dt) {}

void IdealGear::Rotate(Measure nomega) {
  SystemNode *currnode;
  Ideal *currcomp;

  if (nomega != omega) {
    omega = nomega;

    axle->Rotate(nomega);

    for (currnode = &meshsys; currnode && currcomp = currnode->getContact();
	 currnode = currnode->getNext()) {
      currcomp->Rotate(omega * (double) teeth / (double) currcomp->getTeeth());
    }
  }
}

unsigned IdealGear::getTeeth() const {
  return teeth;
}

void IdealGear::Mesh(Gear &ngear, Measure ilen) {
  if (meshsys.AddContact(ngear, ilen %= Pi))
    ngear.Mesh(*this, (Pi - ilen) % Pi);
}

HelicalSpring::HelicalSpring(ElementalComponent &nrightcontact,
			     Vector nrightpoint,
			     ElementalComponent &nleftcontact,
			     Vector nleftpoint,
			     Measure nspringk, Measure nequilibrium) {
  rightcontact = &nrightcontact;
  rightpoint = nrightpoint;
  leftcontact = &nleftcontact;
  leftpoint = nleftpoint;

  springk = nspringk;
  equilibrium = nequilibrium;

  radius = .01;
  color = 0;
  loops = 6.0;
}

void HelicalSpring::Draw() const {
  CDrawSpiral(leftpoint, (rightpoint - leftpoint).unit(), radius, 0,
	      (rightpoint - leftpoint).magnitude() / loops, dr, color);
}

void HelicalSpring::Info() const {
  cout << "Helical Spring" << endl
       << "  Endpoints: " << rightpoint << leftpoint;
}

Measure updateSystem(Measure dt) {
  Measure testdt;

  testdt = max(rightcontact->Update(uptime), leftcontact(Update(uptime)));
  uptime = max(testdt, uptime);
}

Measure dtneeded() const {
  return largeval;
}

// use equilibrium to scale
void makeChanges(Measure dt) {
  Measure newlength = (leftpoint - rightpoint).magnitude();
  Measure deltalength = newlength - oldlength;

  
}

// The relative vector assumes axis along the z-axis and theta of 0.
Vector ToConnection(Vector relative, ElementalComponent &contact) {
  Vector result;

  // First, make theta changes
  result = relative[2] + theta;

  // Next, change to reflect axis
  

  // Finally, consider translation
  return result.ToCartesian(contact.getLoc());
}
