// arbitrary.h - Header file to make entirely general components
#ifndef ARBITRARY_H
#define ARBITRARY_H

// Worry about for loops that wrap around without end
class ShapedPiece : public ElementalComponent {
public:
  ShapedPiece(Shape &nshape, Measure nmass, Vector nloc, Vector nvel
	      Measure nmoment, Measure ntheta, Measure nomega, Vector naxis);

  virtual void Draw() const;
  virtual void Info() const;

  virtual Measure dtneeded() const;
  virtual Vector Normal(Vector iloc, Vector dloc);
  virtual bool Within(Vector iloc);
private:
  Shape *shape;

  int color
};

class MasslessString : public ElementalComponent {
public:
  MasslessString(ElementalComponent &nrightcontact, Vector nrightpoint,
		 ElementalComponent &nleftcontact, Vector nleftpoint);

  virtual void Draw() const;
  virtual void Info() const;

  virtual Measure dtneeded() const;
  virtual Vector Normal(Vector iloc, Vector dloc);
  virtual bool Within(Vector iloc);
private:
  Shape *shape;

  int color
};

class Shape {
public:
  Shape(Measure nwidth = 0);

  Shape &Start(Point pt);
  Shape &To(Point pt);
  Shape &To(Point pt, Measure curve);
  Shape &From(Point pt);
  Shape &From(Point pt, Measure curve);
  Shape &Return(Measure curve);

  Vertex *GetFirst() const;
  Vertex *GetLast() const;

  Shape &setColor(int ncolor);
  Shape &setWidth(Measure nwidth);
private:
  Vertex *first;
  Vertex *last;

  Measure width;
  int color;
};

class Vertex {
public:
  Vertex(Point npt);

  Edge &SetNext(Measure ncurve);
  Edge &SetNext(Edge &nedge);
  Edge &SetPrev(Measure ncurve);
  Edge &SetPrev(Edge &nedge);

  Point GetPoint() const;
  Edge *GetPrev() const;
  Edge *GetNext() const;
private:
  Vector pt;

  Edge *prev;
  Edge *next;
};

class Edge {
public:
  Edge(Measure ncurve);

  Vertex &SetNext(Point npt);
  Vertex &SetNext(Vertex &nvertex);
  Vertex &SetPrev(Point npt);
  Vertex &SetPrev(Vertex &nvertex);

  Measure GetCurve() const;
  Point GetCenter() const;
  bool Within(Point iloc) const;

  Vertex *GetPrev() const;
  Vertex *GetNext() const;
private:
  Measure curve;  /* defined as the distance from the midpoint of the edge to
		    the center of the circle, except 0 for a straight line  */
  Vertex *prev;
  Vertex *next;
};

typedef Point {
  Measure x;
  Measure y;
}

Vector TwoToThree(Point twod, Vector axis, Measure theta);
Point ThreeToTwo(Vector threed, Vector axis, Measure theta);

#endif
