// drawing.cpp -- definitions for functions for drawing 3-D objects to screen

// 3-D view is determined by i, j, and k vectors as defined in the screen plane
// Initially, a right-hand system, assuming origin at lower left
// Note: no perspective!  But not a problem at this level-- can make the clock
// appear to move away (shortenning), but I need no difference within the clock
// I can look at it from a different angle by switching components
// I should inforce that these come from vectors in a sphere to make other
//  things easier (radius -> # pixels) -- need not be a unit sphere (magnify)
// Note: I need a "DrawAll" function to take care of objects covering eachother

#include "drawing.h"
#include "vector.h"
#include "xwin.h"

double ix = -sqrt(2);
double iy = -sqrt(2);

double jx = 1.0;
double jy = 0.0;

double kx = 0.0;
double ky = 1.0;

double drad = 1.0;

// Sphere seems to be a circle at the appropriate point
void CFillSphere(DrawTablet &tablet, const Vector &loc,
		 double radius, int color) {
  unsigned pixradius;
  XSetForeground(tablet.display, tablet.my_gc, my_pix[color]);
  XFillArc(tablet.display, tablet.win, tablet.my_gc,
	   getpixelx(loc), getpixely(loc),
	   pixradius = (unsigned) ceil(drad * radius), pixradius, 0, 360 * 64);
}

void CDrawLine(DrawTablet &tablet, const Vector &locA, const Vector &locB,
	       double width, int color) {
  XSetForeground(tablet.display, tablet.my_gc, my_pix[color]);
  XSetLineAttributes(tablet.display, tablet.my_gc,
		     (unsigned) ceil(width * drad),
		     LineSolid, CapRound, JoinRound);
  XDrawLine(tablet.display, tablet.win, tablet.my_gc,
	    getpixelx(locA), getpixely(locA),
	    getpixelx(locB), getpixely(locB));
}

// MESSED THIS UP-- FIX!
// A filled rectangle can look like any parallelagram at any slant
void CFillRectangle(DrawTablet &tablet, int x1, int y1, int x2, int y2,
		    int color) {
  XPoint corners[4] = {{x1, y1}, {x2, y1}, {x2, y2}, {x1, y2}};
  XSetForeground(tablet.display, tablet.my_gc, my_pix[color]);
  XFillPolygon(tablet.display, tablet.win, tablet.my_gc,
	       corners, 4, Convex, CoordModeOrigin);
}

// Should be about 4 arcs but we don't want to spend that much time right now
// Would be perfect circle except that axis not perfect facing out
void CFillCircle(DrawTablet &tablet, const Vector &loc, const Vector &axis,
		 double radius, int color) {
  double outwardx = drad - ((double) getpixelx(axis * 100.0)) / 100.0;
  double outwardy = drad - ((double) getpixely(axis * 100.0)) / 100.0;
  XSetForeground(tablet.display, tablet.my_gc, my_pix[color]);
  XFillArc(tablet.display, tablet.win, tablet.my_gc,
	   getpixelx(loc), getpixely(loc),
	   (unsigned) ceil(drad * outwardx * radius),
	   (unsigned) ceil(drad * outwardy * radius), 0, 360 * 64);
}

// For now, ignore width
void CFillPolygon(DrawTablet &tablet, const Vector &loc, const Vector &axis,
		  Point *points, int count, double width, int color) {
  double outwardx = drad - ((double) getpixelx(axis * 100.0)) / 100.0;
  double outwardy = drad - ((double) getpixely(axis * 100.0)) / 100.0;
  XPoint *vertices = new XPoint[count];

  XSetForeground(tablet.display, tablet.my_gc, my_pix[color]);
  for (int i = 0; i < count; i++) {
    vertices[i].x = (unsigned) (points[i].x * outwardx * drad
				+ getpixelx(loc));
    vertices[i].y = (unsigned) (points[i].y * outwardy * drad
				+ getpixely(loc));
  }
  XFillPolygon(tablet.display, tablet.win, tablet.my_gc,
	       vertices, count, Convex, CoordModeOrigin);

  delete[] vertices;
}

// return the pixel column (the x screen coordinate) for a given 3-D location
int getpixelx(const Vector &loc) {
  return (int) (loc.xm() * ix + loc.ym() * jx + loc.zm() * kx)();
}

// return the pixel row (the y screen coordinate) for a given 3-D location
int getpixely(const Vector &loc) {
  return (int) (loc.xm() * iy + loc.ym() * jy + loc.zm() * ky)();
}
