// drawing.h -- header file for projected 3-D drawn objects to the screen

#include "vector.h"
#include "point.h"
#include "xwin.h"

// perhaps this is the natural place to use functions-- for drawing
void CFillSphere(DrawTablet &tablet, const Vector &loc,
		 double radius, int color);
void CDrawLine(DrawTablet &tablet, const Vector &locA, const Vector &locB,
	       double width, int color);
void CFillRectangle(DrawTablet &tablet, const Vector &locNW,
		    const Vector &locNE, const Vector &locSE,
		    const Vector &locSW, int color);
void CFillCircle(DrawTablet &tablet, const Vector &loc, const Vector &axis,
		 double radius, int color);
void CFillPolygon(DrawTablet &tablet, const Vector &loc, const Vector &axis,
		  Point *points, int count, double width, int color);
void CDrawSprial(DrawTablet &tablet, const Vector &base, const Vector &axis,
		 double initrad, double deltar, double deltab, double width,
		 int color);

// represents two possible approaches:
//   screen stores info on my draw calls
//   clock calls draw on each component
void RedrawScreen();
void RedrawClock();

int getpixelx(const Vector &loc);
int getpixely(const Vector &loc);
