#include "friction.h"

void setup() {
  insert(STEEL, STEEL, .8, .16);
  insert(STEEL, COPPER_LEAD, .22, 0);
  insert(STEEL, PHOSPHOR_BRONZE, .35, 0);
  insert(STEEL, ALUMINUM_BRONZE, .45, 0);
  insert(STEEL, BRASS, .35, .19);
  insert(STEEL, CAST_IRON, .4, .21);
  insert(STEEL, BRONZE, 0, .16);
  insert(STEEL, SINTERED_BRONZE, 0, .13);
  insert(STEEL, HARD_CARBON, .14, .125);
  insert(STEEL, GRAPHITE, .8, .1);
  insert(STEEL, TUNGSTEN_CARBIDE, .5, .15);
  insert(STEEL, PLEXIGLAS, .45, .45);
  insert(STEEL, POLYSTYRENE, .325, .325);
  insert(STEEL, PLYTHENE, .2, .2);
  insert(STEEL, TEFLON, .04, .04);
  insert(ALUMINUM, ALUMINUM, 1.35, .3);
  insert(CADMIUM, CADMIUM, .5, .05);
  insert(CHROMIUM, CHROMIUM, .41, .34);
  insert(COPPER, COPPER, 1.0, .08);
  insert(IRON, IRON, 1.0, .175);
  insert(MAGNESIUM, MAGNESIUM, .6, .08);
  insert(NICKEL, NICKEL, .7, .28);
  insert(PLATINUM, PLATINUM, 1.2, .25);
  insert(SILVER, SILVER, 1.4, .55);
  insert(ZINC, ZINC, .6, .04);
  insert(GLASS, GLASS, .95, .35);
  insert(GLASS, METAL, .6, .25);
  insert(DIAMOND, DIAMOND, .1, .075);
  insert(DIAMOND, METAL, .125, .1);
  insert(SAPPHIRE, SAPPHIRE, .2, .2);
  insert(HARD_CARBON, HARD_CARBON, .16, .13);
  insert(GRAPHITE, GRAPHITE, .1, .1);
  insert(TUNGSTEN_CARBIDE, TUNGSTEN_CARBIDE, .225, .12);
  insert(PLEXIGLAS, PLEXIGLAS, .8, .8);
  insert(POLYSTYRENE, POLYSTYRENE, .5, .04);
  insert(TEFLON, TEFLON, .04, 0);
  insert(NYLON, NYLON, .2, 0);
  insert(RUBBER, ANY, 2.5, 0);
  insert(WOOD, WOOD, .375, 0);
  insert(WOOD, METAL, .4, 0);
  insert(BRICK, WOOD, .6, 0);
  insert(LEATHER, WOOD, .35, 0);
  insert(LEATHER, METAL, .6, 0);
  insert(BRAKE_MATERIAL, CAST_IRON, .4, 0);
}

void insert(int num1, int num2, float co1, float co2) {
  switch (num2) {
  case (ANY):
    for (int i = STEEL, i < ANY; i++)
      insert(num1, i, co1, co2);
    break;
  case (METAL):
    for (int i = STEEL, i <= ZINC, i++)
      insert(num1, i, co1, co2);
    break;
  default:
    muStatic[num1][num2][0] = co1;
    muStatic[num1][num2][1] = co2;
    muStatic[num2][num1][0] = co1;
    muStatic[num2][num1][1] = co2;
  }
}
