// interface.cpp - Functions for interfacing with the program

#include <stdio.h>
#include <stdlib.h>
#include "interface.h"
#include "xwin.h"
#include "drawing.h"

/* Front Door: Openning Program */
int
main(int argc, char *argv[]) {
  int c;

  extern char *optarg;
  extern int optind;
  int errflg = false;

  idlecnt = 0;

  while ((c = getopt(argc, argv, "dC:")) != EOF)
    switch (c) {
    case 'C':  // Create clock
      CreateClock(optarg);
      break;
    case 'd':  // Display component
      DisplayComponent();
      break;
    case '?':
      errflg = true;
    }

  if (errflg) {
    fprintf(stderr, "usage: \n");
    exit(2);
  }

  while (optind < argc) {
    optind++;
  }

  return 0;
}

// Clock creation GUI -- Saves series of object calls in file as implements
void CreateClock(char *output) {
}

// Just display a component-- for testing for now
void DisplayComponent() {
  ClockGUI();
}

void InitActions(DrawTablet &tablet) {
  CDrawLine(tablet, Vector(0.0 * m, 100 * m, 100 * m),
	    Vector(0.0 * m, 2.0 * 100 * m, 2.0 * 100 * m), 2, 2);
}

void HandleClick(DrawTablet &tablet, int a, int b, int c) {
  CDrawLine(tablet, Vector(0.0 * m, a * m, b * m),
	    Vector(0.0 * m, 2.0 * a * m, 2.0 * b * m), 2, 2);
}

void IdleActions(DrawTablet &tablet) {
  idlecnt++;
  /*  if (!idlecnt)
    CDrawLine(tablet, Vector(0.0 * m, 100 * m, 100 * m),
    Vector(0.0 * m, 2.0 * 100 * m, 2.0 * 100 * m), 2, 2);*/
}

void RedrawWindow() {}
