#include "component.h"
#include "drawing.h"

class MasslessRod : public ElementalComponent {
public:
  MasslessRod(const Vector &nloc, const Vector &nvel,
	      const Measure &ntheta, const Measure &nomega,
	      const Vector &naxis, const Measure &nlength);

  virtual void Draw(DrawTablet &tablet) const;
  virtual void Info() const;

  virtual void Impulse(const Vector &iloc, const Vector &force);
  virtual Measure dtneeded() const;
  virtual Vector Normal(const Vector &iloc, const Vector &dloc) const;
  virtual bool Within(const Vector &iloc) const;
  virtual bool myCollisions(ElementalComponent &collcomp) const;

  virtual Vector ClosestToPoint(const Vector &iloc) const;
  virtual Vector ClosestToLine(const Vector &iloc, const Vector &along) const;
  virtual Vector ClosestToPlane(const Vector &iloc, const Vector &axis) const;

  Vector endpoint1() const;
  Vector endpoint2() const;

  void setColor(int ncolor);
protected:
  Measure length;

  int color;
};

class StaticPlane : public ElementalComponent {
public:
  StaticPlane(const Vector &nloc, const Measure &ntheta, const Vector &naxis,
	      const Measure &nlength, const Measure &nwidth);

  virtual void Draw(DrawTablet &tablet) const;
  virtual void Info() const;

  virtual void Impulse(const Vector &iloc, const Vector &force);
  virtual Measure dtneeded() const;
  virtual Vector Normal(const Vector &iloc, const Vector &dloc) const;
  virtual bool Within(const Vector &iloc) const;
  virtual bool myCollisions(ElementalComponent &collcomp) const;

  virtual Vector ClosestToPoint(const Vector &iloc) const;
  virtual Vector ClosestToLine(const Vector &iloc, const Vector &along) const;
  virtual Vector ClosestToPlane(const Vector &iloc, const Vector &axis) const;

  Vector midpointN() const;
  Vector midpointE() const;
  Vector midpointS() const;
  Vector midpointW() const;
  Vector cornerNW() const;
  Vector cornerNE() const;
  Vector cornerSE() const;
  Vector cornerSW() const;

  void setColor(int ncolor);
private:
  int color;

  Measure length;
  Measure width;
};
