// system.h -- defines the list structure used for systems
#ifndef SYSTEM_H
#define SYSTEM_H

template <class T>
class SystemNode {
public:
  SystemNode();

  // Seek functions
  // Add functions -- do not allow same contact multiple times
  SystemNode<T> *AddContact(T &ncontact, double nilen = 0.0);

  // Set functions
  void SetILen(double nilen);

  // Get functions
  T *getContact() const;
  double GetILen() const;
  SystemNode<T> *getNext() const;
private:
  T *contact;
  double ilen;

  SystemNode<T> *next;
};

// system.cpp -- function definitions for the main system list structure

template <class T>
SystemNode<T>::SystemNode() {
  contact = NULL;
  next = 0;
}

// does not allow same component multiple times at the same contact point
template <class T>
SystemNode<T> *SystemNode<T>::AddContact(T &ncontact, double nilen) {
  if (!contact) {
    contact = &ncontact;
    ilen = nilen;
  } else {
    if (contact == &ncontact && ilen == nilen)
      return 0;
    if (!next)
      next = new SystemNode<T>;
    next->AddContact(ncontact);
  }
  return this;
}

template <class T>
void SystemNode<T>::SetILen(double nilen) {
  ilen = nilen;
}

template <class T>
T *SystemNode<T>::getContact() const {
  return contact;
}

template <class T>
double SystemNode<T>::GetILen() const {
  return ilen;
}

template <class T>
SystemNode<T> *SystemNode<T>::getNext() const {
  return next;
}

#endif

