// vector.h - class declarations for vector class and accessories
#ifndef VECTOR_H
#define VECTOR_H

#include <math.h>
#include <stdlib.h>
#include <iostream.h>
#include "measure.h"

/* I want to be able to say:
   Vector x = 3.0 * m * _i;
   Vector y = 4.0 * m * _j;
   Vector z = x + y;
   cout << z.magnitude(); // 5 m
*/

class Vector {
  friend const Vector Cross(const Vector &, const Vector &);
  friend const Measure Dot(const Vector &, const Vector &);
  friend const Vector Proj(const Vector &, const Vector &);
  friend const Vector operator*(const Measure &, const Vector &);

  friend ostream &operator<<(ostream &, const Vector &);
public:
  Vector();
  Vector(const Measure &, const Measure &, const Measure &);
  Vector(const Vector &, const Vector &, const Vector &);

  const Vector operator+(const Vector &) const;
  const Vector operator-(const Vector &) const;
  const Vector operator*(const Measure &) const;
  const Vector operator/(const Measure &) const;
  const Vector operator-() const;

  const Vector operator+=(const Vector &);
  const Vector operator-=(const Vector &);
  const Vector operator*=(const Measure &);
  const Vector operator/=(const Measure &);

  bool operator==(const Vector &) const;
  bool operator!=(const Vector &) const;

  const Vector x() const;
  const Vector y() const;
  const Vector z() const;
  const Vector zc() const;     // cylindrical z
  const Vector r() const;
  const Vector rho() const;
  const Vector theta() const;
  const Vector thetac() const; // cylindrical theta
  const Vector phi() const;

  const Measure xm() const;
  const Measure ym() const;
  const Measure zm() const;
  const Measure rm() const;
  const Measure rhom() const;
  const Measure thetam() const;
  const Measure phim() const;

  const Measure magnitude() const;
  const Measure mag() const;
  const Vector unit() const;
private:
  Measure one;  // x or r or rho
  Measure two;  // y or theta
  Measure thr;  // z or phi
};

#endif
