/*
 * xwin.c -- general setup for XWindows graphics derived from:
 *   Impl.c - Ben Vandiver - Jun '96
 *
 * #define-customized for ClockMaker
 */

#include "xwin.h"

#define WINDOW_NAME "ClockMaker"
#define ICON_NAME   "ClockMaker"
#define RES_CLASS   "ClockMaker"
#define PROGNAME    "/mit/jrising/clockmaker"
#define WIN_WIDTH   550
#define WIN_HEIGHT  550
#define WIN_TOPX    50
#define WIN_TOPY    50
#define WIN_BORDER  4

/* General form of drawing functions:
   XSetForeground(display, my_gc, my_pix[XXX]);
   XDrawLine(display, win, my_gc, X1, Y1, X2, Y2);
*/

char DONE = 0;

Display *display;
int screen;
Window win;
GC my_gc;

int ClockGUI() {
  XGCValues xgcv;
  XEvent eve;
  int wincheck;

  /* Initialize Window */
  display = XOpenDisplay(0);
  if (display == NULL) {
    printf("Error opening display!\n");
    exit(1);
  }

  screen = DefaultScreen(display);
  win = XCreateSimpleWindow(display, RootWindow(display, screen), 
			    WIN_TOPX, WIN_TOPY, WIN_WIDTH, WIN_HEIGHT, 
			    WIN_BORDER, BlackPixel(display, screen),
			    WhitePixel(display, screen));
  XMapWindow(display, win);

  wm_stuff();

  xgcv.foreground = BlackPixel(display, screen);
  xgcv.background = WhitePixel(display, screen);
  my_gc = XCreateGC(display, win, GCForeground | GCBackground, &xgcv);

  /* Put color allocations here */
  my_pix[0] = BlackPixel(display, screen);
  my_pix[1] = WhitePixel(display, screen);
  my_pix[2] = getColor("red");
  my_pix[3] = getColor("green");
  my_pix[4] = getColor("blue");

  /* Now use window: event loop */
  XSelectInput(display, win, ExposureMask | ButtonPressMask);

  DrawTablet tablet = {display, win, my_gc};

  InitActions(tablet);

  while (!DONE) {
    if ((wincheck = XPending(display))) {
      XNextEvent(display, &eve);
      switch (eve.type) {
      case Expose:
	RedrawWindow();
	break;
      case ButtonPress:
	HandleClick(tablet, eve.xbutton.x, eve.xbutton.y, eve.xbutton.button);
	break;
      }
    } else
      IdleActions(tablet);
  }

  return 0;
}

/* Function extracts information about a named color from the default colors */
int getColor(const char colorname[]) {
  Colormap cmap;
  XColor col;

  cmap = DefaultColormap(display, screen);

  XParseColor(display, cmap, colorname, &col);
  XAllocColor(display, cmap, &col);
  return col.pixel;
}

void wm_stuff() {
  char *win_name = (char *) WINDOW_NAME;
  char *icon_name = (char *) ICON_NAME;
  XSizeHints sh;
  XWMHints wmh;
  XClassHint clh;
  XTextProperty wName,iName;

  sh.flags = PPosition | PSize | PMinSize;
  sh.min_width = WIN_WIDTH;
  sh.min_height = WIN_HEIGHT;
  if (XStringListToTextProperty(&win_name, 1, &wName) == 0) {
    fprintf(stderr,"Cannot alloc for Window name!\n");
    exit(-1);
  }
  if (XStringListToTextProperty(&icon_name, 1, &iName) == 0) {
    fprintf(stderr,"Cannot alloc for icon name!\n");
    exit(-1);
  }
  wmh.initial_state = NormalState;
  wmh.input = True;
  wmh.flags = StateHint | InputHint;
  clh.res_name = (char *) PROGNAME;
  clh.res_class = (char *) RES_CLASS;
  XSetWMProperties(display, win, &wName, &iName, NULL, 0, &sh, &wmh, &clh);
}
