// defield.h - class declarations for stuff derived from SpaceField class
#ifndef DEFIELD_H
#define DEFIELD_H

#include "diffeq.h"

/* ----- Third Level ----- Fields ----- */

// 3-D vector field defined by explicit definition
class SpaceFieldByEquation : public SpaceField {
public:
  SpaceFieldByEquation();                   // Default Constructor: do nothing
  SpaceFieldByEquation(SpaceField &);       // Copy Constructor
  ~SpaceFieldByEquation();                  // Destructor - release memory

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *Equation;
};

// 3-D function stored as the coefficients of a Fourier series in exponential
// form, in file of doubles and data
class SpaceFieldByFouriers : public SpaceField, public SpaceDiffEqByFouriers {
public:
  SpaceFieldByFouriers(char *);              // Constructor; passed file name
  ~SpaceFieldByFouriers();                   // Destructor - close file
  
  void d(SpaceField &);                      // Define derivative

  void Inc(double);                          // Change using given time
  SpaceFieldByFouriers operator++();         // Change, prefix operator
  SpaceFieldByFouriers operator++(int);      // Change, postfix operator

  void SetCoeffCount(long);                  // Change number of Fourier coeffs
  long GetCoeffCount() const;                // Return number of Fourier coeffs

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *ddt;                           // equation for time changes field

  fstream *Fouriers;                         // File of Fourier coefficients

  long coeffcount;                           // Locations of Fourier starts
};

// Constant class - saves a SpaceVector
class SpaceFieldConstant : public SpaceField {
public:
  SpaceFieldConstant(SpaceVector);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceVector constant;
};

// Variable class - saves a reference to a SpaceVector that may be changed
class SpaceFieldVariable : public SpaceField {
public:
  SpaceFieldVariable(SpaceVector &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceVector *constant;
};

/* ----- Fourth Level ----- Field Functions ----- */

// Sum of two 3-D vector fields
class SpaceFieldAdd : public SpaceField {
public:
  SpaceFieldAdd(SpaceField &, SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *left;
  SpaceField *right;
};

// Difference between two 3-D vector fields
class SpaceFieldSub : public SpaceField {
public:
  SpaceFieldSub(SpaceField &, SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *left;
  SpaceField *right;
};

// Cross product between two 3-D vector fields
class SpaceFieldCrs : public SpaceField {
public:
  SpaceFieldCrs(SpaceField &, SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *left;
  SpaceField *right;
};

// Product between a vector field and a scalar
class SpaceFieldScl : public SpaceField {
public:
  SpaceFieldScl(SpaceFunction &, SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceFunction *scalar;
  SpaceField *field;
};

// Quotient between a vector field and a scalar
class SpaceFieldISc : public SpaceField {
public:
  SpaceFieldISc(SpaceFunction &, SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceFunction *scalar;
  SpaceField *field;
};

// Curl of a vector field
class SpaceFieldCrl : public SpaceField {
public:
  SpaceFieldCrl(SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *field;
};

// Change the sign of a vector field
class SpaceFieldMns : public SpaceField {
public:
  SpaceFieldMns(SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceField *field;
};

// Gradient of a function
class SpaceFunctionGrd : public SpaceField {
public:
  SpaceFunctionGrd(SpaceFunction &);
  
  virtual SpaceVector operator()(double x, double y, double z) const;
private:
  SpaceFunction *function;
};

#endif
