// diffeq.h - Class declarations for Differential Equations Class
#ifndef DIFFEQ_H
#define DIFFEQ_H

#include <iostream.h>
#include <fstream.h>
#include <math.h>

/* ----- Highest Level ----- */

#define DVAL   .00001
#define pi     4*atan(1)

// Pure virtual 3-D Differential Class
class SpaceDifferentialEquation {
public:
private:
};

// Classes and function declared later which may need prototypes
class SpaceFieldCrs;
class SpaceFieldCrl;
class SpaceFieldDvg;
class SpaceFunctionDot;
class SpaceFieldAdd;
class SpaceFieldSub;
class SpaceFieldMns;
class SpaceFieldScl;
class SpaceFieldISc;
class SpaceFunctionPow;
class SpaceFunctionGrd;
class SpaceFunctionAdd;
class SpaceFunctionSub;
class SpaceFunctionMul;
class SpaceFunctionDiv;
class SpaceFunctionMns;
class SpaceField;
class SpaceFunction;
class Complex;
class SpaceVector;

Complex *MakeFouriers(double *, long);

/* ----- Second Level ----- */

// 3-D vector field base class
class SpaceField : public SpaceDifferentialEquation {
  friend SpaceFieldCrs &Cross(SpaceField &, SpaceField &);
  friend SpaceFieldCrl &Curl(SpaceField &);
  friend SpaceFieldDvg &Div(SpaceField &);
  friend SpaceFunctionDot &Dot(SpaceField &, SpaceField &);
public:
  SpaceFieldAdd &operator+(SpaceField &);
  SpaceFieldSub &operator-(SpaceField &);
  SpaceFieldScl &operator*(SpaceFunction &);
  SpaceFieldISc &operator/(SpaceFunction &);
  SpaceFieldMns &operator-();
  SpaceFunctionDot &operator*(SpaceField &);

  virtual SpaceVector operator()(double x, double y, double z) const = 0;
};

// 3-D Function base class
class SpaceFunction : public SpaceDifferentialEquation {
  friend SpaceFunctionPow &Pow(SpaceFunction &, double);
  friend SpaceFunctionGrd &Grad(SpaceFunction &);
public:
  SpaceFunctionAdd &operator+(SpaceFunction &);
  SpaceFunctionSub &operator-(SpaceFunction &);
  SpaceFunctionMul &operator*(SpaceFunction &);
  SpaceFunctionDiv &operator/(SpaceFunction &);
  SpaceFunctionMns &operator-();
  SpaceFieldScl &operator*(SpaceField &);

  virtual double operator()(double x, double y, double z) const = 0;
};

// 3-D Equation by Fouriers base class
class SpaceDiffEqByFouriers : public SpaceDifferentialEquation {
public:
  static double GetInc();
  static void SetInc(double);

  static double GetDomain();
  static void SetDomain(double);
protected:
  static double inc;

  static double domain;
};

/* ----- Accessory Classes ----- */

// 3-D vector class
class SpaceVector : public SpaceDifferentialEquation {
  friend SpaceVector Cross(const SpaceVector &, const SpaceVector &);
  friend double Dot(const SpaceVector &, const SpaceVector &);
public:
  SpaceVector(double i = 0.0, double j = 0.0, double k = 0.0);

  SpaceVector operator+(const SpaceVector &) const;
  SpaceVector operator-(const SpaceVector &) const;
  SpaceVector operator*(double) const;
  SpaceVector operator/(double) const;
  SpaceVector operator-() const;

  double &operator[](char);              // Allows assignment
private:
  double i;
  double j;
  double k;
};

// Quick Complex class
class Complex {
friend Complex cexp(const Complex &);
friend Complex cnum(double, double);
friend fstream &operator>>(fstream &, Complex);
friend fstream &operator<<(fstream &, Complex);
public:
  Complex(double = 0.0, double = 0.0);
  
  Complex operator+(const Complex &) const;
  Complex operator-(const Complex &) const;
  Complex operator*(const Complex &) const;
  Complex operator/(double) const;
  Complex operator-() const;

  double re;
  double im;
};

#endif
