// Copied, with modifications, from disk included with "Numerical Analysis" by
// Richard L. Burden and J. Douglas Faires.

/*
 * FAST FOURIER TRANSFORM ALGORITHM 8.3
 *
 * To compute the coefficients in the discrete approximation
 * for data (x(J), y(J)), 0 <= J <= 2m - 1 where m = 2**p and
 * x(J) = -pi + J * pi / m for 0 <= J <= 2m - 1
 *
 * INPUT: m; y(0), y(1), ..., y(2m-1)
 *
 * OUTPUT: complex numbers c(0), ..., c(2m-1);
 *         real numbers a(0), ..., a(m), b(1), ..., b(m-1).
 *
 * NOTE: The multiplication by EXP(-K * PI * i) is done within
 *       the program.
 */

#include "diffeq.h"
#include <stdio.h>
#include <math.h>

#define log2   log(2.0)

int revbit(int, int);

// Calculate Fourier complex coefficients, given 2M double precision points
//   assumed to be equally spaced between -pi and pi - pi / M.
// The output is complex numbers for which the real and imaginary parts can be
//   immediately multiplied against cos and sin as Fourier coefficients.
// Steps are from page 534 of Numerical Analysis
Complex *MakeFouriers(double *points, long M) {
  const long n = 2 * M;
  const int p = (int) (log((double) n) / log2 + .5);

  Complex c[n], xi[n + 1];
  Complex zeta, eta, temp, x, y;
  long k, np, q, m;

  Complex *newcoeffs;

  if (M < 0)
    return 0;       // Error - no data points

  // Step 1
  m = M;
  q = p - 1;
  zeta = cexp(cnum(0.0, 2.0 * pi / (double) n));

  // Step 2
  for (long j = 0; j < n; j++)
    c[j] = cnum(points[j], 0.0);

  // Step 3
  for (long j = 1; j <= m; j++) {
    xi[j] = zeta;
    for (long i = 1; i < j; i++)
      xi[j] = xi[j] * zeta;
    xi[m + j] = -xi[j];
  }

  // Step 4
  xi[0] = cnum(1.0, 0.0);
  k = 0;

  // Step 5
  for (int l = 1; l <= p; l++) {
    // Step 6
    while (k < n - 1) {
      // Step 7
      for (long j = 1; j <= m; j++) {
	// Step 8
	np = revbit((int) (k / exp(q * log2)), p);
	eta = c[k + m];
	
	// Step 9
	if (np != 0)
	  eta = eta * xi[np - 1];
	c[k + m] = c[k] - eta;
	c[k] = c[k] + eta;

	// Step 10
	k++;
      }

      // Step 11
      k = k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 / Step 19
  return newcoeffs;
}

int revbit(int j, int nu) {
  int k, j2, j1;

  j1 = j;
  k = 0;
  for (int i = 1; i <= nu; i++) {
    j2 = j1 / 2;
    k = 2 * k + (j1 - 2 * j2);
    j1 = j2;
  }

  return k;
}
