// Goal: to implement the following function as this:
// Note: I have removed the gravitational force for simplicity.
#include "defield.h"
#include "defuncn.h"
#include <iostream.h>

// General definitions for useful vectors - these should go elsewhere
SpaceVector __i(1, 0, 0);
SpaceVector __j(0, 1, 0);
SpaceVector __k(0, 0, 1);

SpaceFieldConstant _i(__i);
SpaceFieldConstant _j(__j);
SpaceFieldConstant _k(__k);

PositionVariable _phi(SpaceVector(1, 0, 0));
PositionVariable _theta(SpaceVector(0, 1, 0));
PositionVariable _rho(SpaceVector(0, 0, 1));

main () {
  double screen[20][72];
  int r, c;

  SpaceFunctionConstant one = 1.0;       // The Value of 1
  SpaceFunctionConstant E9 = 1.0E9;      // Value 10^9 for scientific notation
  SpaceFunctionConstant mu = 12.5664E-7; // Magnetic Permeability (Hm-1)
  SpaceFunctionConstant R = 8.3E3;       // Ideal Gas Constant (J*K-1*kg-1)
  SpaceFunctionConstant gamma = 5/3;     // Ratio of Specific Heats (cp/cv)
  SpaceFunctionConstant G = 6.672E-11;   // Universal Gravitation Constant
  SpaceFunctionConstant M = 1.99E30;     // Mass of the Sun (kg)
  SpaceFieldByEquation E;                // Electric Field
  SpaceFieldByFouriers v("vel.dat");     // Plasma Velocity
  SpaceFieldByFouriers B("mag.dat");     // Magnetic Field / Magnetic Induction
  SpaceFieldByEquation j;                // Current Density
  SpaceFieldByEquation g;                // Gravitational Field
  SpaceFunctionByEquation sigma;         // Electrical Conductivity (mho*m-1)
  SpaceFunctionByEquation T;             // Plasma Temperature
  SpaceFunctionByFouriers p("prs.dat");  // Pressure
  SpaceFunctionByFouriers rho("dns.dat");// Charge Density
  double gasFactor;                      // Ideal Gas Law Factor (2 for pure
  SpaceFunctionVariable f = gasFactor;   //   hydrogen, 1.67 in solar corona)

  g = (-G * M / (_rho * _rho)) * _k;     // Newton's Law of Gravity
  E = Cross(v, B) - (one / mu) * j;      // Ohm's Law
  sigma = Pow(T, 3/2) / (mu * E9);       // From Braginski
  T = p / (f * rho * R);                 // Ideal Gas Law
  j = Curl(B) / mu;                      // Ampere's Law simplifed for MHD
  B.d(-Curl(E));                         // Faraday's Law of magnetic induction
  v.d(-Grad(p) + Cross(j, B) + rho * g - rho * Div(v) * v);
                                         // Newton's Second Law of motion
  rho.d(-Div(rho * v));                  // Mass Continuity
  p.d(-gamma * p * Div(v) - v * Grad(p));// Simplified Energy Equation

  SpaceDiffEqByFouriers::SetInc(1.0);    // Increment time 1 sec each iteration
  SpaceDiffEqByFouriers::SetDomain(6.96E8); // Radius of the Sun

  for (r = 0; r < 20; r++)
    for (c = 0; c < 72; c++)
      screen[r][c] = 0.0;

  while (1) {
    for (double theta = -pi; theta < pi; theta += .1)
      for (double phi = -pi; phi < pi; phi += .1) {
	r = 10 + 10 * (int) sin(theta);
	c = 36 + 10 * (int) cos(phi);
	screen[r][c] = T(phi, theta, 1E8);
      }

    for (r = 0; r < 20; r++) {
      for (c = 0; c < 72; c++)
	cout << ((int) (screen[r][c])) % 10;
      cout << endl;
    }

    ++B;
    ++v;
    ++rho;
    ++p;
  }
}
