/****************************************************************************
 * GausImage -- Pyramid of images, successively reduced by Gaussian filters *
 ****************************************************************************
 *                                                                          *
 ****************************************************************************/

#ifndef PYRAMID_H
#define PYRAMID_H

class GausImage;
class GausImageLevel;

#include "mystd.h"
#include "image.h"

class GausImage : public GausStructure<GausImageLevel> {
public:
  GausImage(Image &img);
  GausImage(unsigned k);
  virtual ~GausImage();

  CArray<Pattern *, Pattern *> *MakePatterns() const;
  CArray<LocPattern *, LocPattern *> *MakeLocPatterns() const;

private:
  Image &source;
};

class GausImageLevel : public GausStructureLevel<GausImageLevel> {
public:
  GausImageLevel(Image &img);

  Image &GetImage() const;

private:
  Image &image;
};

#endif
