/****************************************************************************
 * HistFile -- Defines globals for generating histogram files               *
 ****************************************************************************
 * Format: In binary (type in parenthesis):                                 *
 *     Header: Comments: { '#' ("...") '\n' }                               *
 *             File Type: ("...") '\n'                                      *
 *             Version: (char.char)                                         *
 *             Pattern Type: ("...") '\n'                                   *
 *             Pattern Defs: { role (unsigned char), type (unsigned char),  *
 *                             count (unsigned char) } 0 (unsigned char)    *
 *             Pattern Globals: { varies (as defined in header) }           *
 *             Cluster Type: ("...") '\n'                                   *
 *             Cluster Defs: { role (unsigned char), type (unsigned char),  *
 *                             count (unsinged char) } 0 (unsigned char)    *
 *             Cluster Globals: { varies (as defined in header) }           *
 *             Cluster Count: (unsigned long)                               *
 *       Bins: Cluster Data: { varies (as defined in header) }              *
 *                                                                          *
 * Pattern definitions can recurse in which case definition and global data *
 * appear, right after role, type, count of type HR_TYPE_PATTERN.  Location *
 * within the pattern data is up to the pattern designer.                   *
 ****************************************************************************/

// Cluster data file type is "Viola Parent Vector 1.0"
#define CLUSTER_PROGRAM "Viola Parent Vector"
#define CLUSTER_PRGVER1 2
#define CLUSTER_PRGVER2 1

// Data type specifications
#define HF_ROLE_COUNT 0x0C // C => C-ount
#define HF_ROLE_AVERG 0x0A // A => A-verage (Mean)
#define HF_ROLE_VARNC 0x07 // 7 => V-ariance

#define HF_ROLE_UNDEF 0x77 // 77 => ?? Unknown role

#define HF_ROLE_GLEVC 0x61 // 61 => G-aussian l-evels count
#define HF_ROLE_PNSET 0x95 // 95 => P-attern S-et
#define HF_ROLE_PDIMC 0x9D // 9D => P-attern D-imension count
#define HF_ROLE_PRESP 0x98 // 98 => P-attern R-esponse
#define HF_ROLE_PNLOC 0x91 // 91 => P-attern l-ocation

#define HF_TYPE_SCHAR 0xA1 // Signed char (1 byte)
#define HF_TYPE_UCHAR 0xA5 // Unsigned char (1 byte)
#define HF_TYPE_SNINT 0xA2 // Signed integer (2 bytes)
#define HF_TYPE_UNINT 0xA6 // Unsigned integer (2 bytes)
#define HF_TYPE_SLONG 0xA4 // Signed long integer (4 bytes)
#define HF_TYPE_ULONG 0xA8 // Unsigned long integer (4 bytes)
#define HF_TYPE_DOUBL 0xAD // Double
#define HF_TYPE_FLOAT 0xAF // Float

#define HF_TYPE_PATRN 0xB9 // Pattern (as defined in the file)
#define HF_TYPE_ULPNA 0xC9 // Unsigned long followed by as many patterns

// Other defines
#define CORRUPT_FILE_ERR   -1
#define BAD_VERSION_ERR    -2
