/****************************************************************************
 * Histogram -- an array of clusters, used for probability models           *
 ****************************************************************************
 * Every cluster forms a bin in the histogram.                              *
 *                                                                          *
 * A bin is like a cluster location                                         *
 ****************************************************************************/

// TODO: Ability to combine histograms, or add additional images?

#ifndef HISTOGRAM_H
#define HISTOGRAM_H

class Histogram;

#include "mystd.h"
#include "cluster.h"
#include "image.h"
#include "pattern.h"
#include "histfile.h"
#include "clustree.h"

#define HistBin        POSITION   // translation between CList and my interface

class Histogram {
public:
  Histogram();
  Histogram(Image &img);
  Histogram(const char *filename);
  Histogram(Histogram &copy);                    // copy and duplicate clusters
  Histogram(CArray<Pattern *, Pattern *> &pats,  // make cluster for each pixel
	    bool del = false);

  ~Histogram();

  unsigned GetDimensions() const;
  unsigned long GetCount() const;  // count = bin count
  unsigned long GetPatternCount() const;

  Cluster &GetCluster(HistBin m) const;
  void SetCluster(HistBin m, Cluster &newcls);
  HistBin GetFirstBin() const;
  HistBin GetNextBin(HistBin m) const;
  void IncrementBin(HistBin &m) const;
  HistBin RemoveBin(HistBin m); // returns position of previous bin
  void RemoveAllBins();

  Cluster &AddCluster(Cluster &newcls);
  Cluster &AddCluster(Pattern &newpat);
  Cluster &AddCluster(Cluster *newcls);
  Cluster &AddCluster(Pattern *newpat);

  void AddClusters(CArray<Pattern *, Pattern *> &pats, bool del = false);
  void AddClusters(const char *filename);

  int LoadClusters(const char *filename);
  int SaveClusters(const char *filename) const;

  void PrintHistogram() const;

  Cluster *NormalCluster() const;
  float NormalFactor() const;

  // TODO: Consider having all return new histograms
  void SelfCluster();           // Cluster by comparing bins to eachother
  Histogram *TestHistogram(const CArray<Pattern *, Pattern *> &pats);
  void LBGCluster(CArray<Pattern *, Pattern *> &pats);
  void GraphCluster(CArray<LocPattern *, LocPattern *> &pats, double dist);

  void EliminateBins(const CArray<Pattern *, Pattern *> &pats);
  unsigned long RemoveSingles();      // Eliminate Clusters with only 1 pattern

  double ProbByPattern(Pattern &pattern) const;
  double EntropyByClass(Histogram &test) const;
  double ChiSqrByClass(Histogram &test) const;
  double MultipleChiSqrByClass(Histogram &test, double scale) const;

  double NormalizeProb() const;

private:
  CList<Cluster *, Cluster *> bins;
  unsigned dims;  // Copies from first cluster
  unsigned long patterncount;
};

#endif
