/*****************************************************************************
 * Image -- functions for using images (ppm files) in Viola's algorithm      *
 *****************************************************************************
 *                                                                           *
 *****************************************************************************/

#ifndef IMAGE_H
#define IMAGE_H

class Image;

#include "mystd.h"
#include "pattern.h"

#define Pixel unsigned char

// TODO: more thouroughly convert to C++
class Image {
public:
  Image(char *filename);
  Image(unsigned nrows, unsigned ncols);
  ~Image();

  unsigned GetRowCount() const;
  unsigned GetColumnCount() const;
  unsigned long GetPixelCount() const;
  int SaveImage(const char *filename) const;

  Pixel GetPixel(unsigned r, unsigned c) const;
  void SetPixel(unsigned r, unsigned c, Pixel pix);

  Image *Reduce() const;
  Image *Expand() const;
  Pixel GaussianAt(unsigned r, unsigned c) const;
  float CalcFeatureAt(unsigned r, unsigned c, float filter[3][3]) const;

private:
  unsigned rows;
  unsigned cols;

  Pixel **pixels;
};

#endif
