/****************************************************************************
 * Main -- Interface, test functions, and main function                     *
 ****************************************************************************
 *                                                                          *
 ****************************************************************************/

// Figure out what to do with GraphCluster's EliminatePatterns

#include "system.h"
#include "model.h"
#include "histogram.h"
#include "gausimage.h"
#include "image.h"

#define CMDLINE_ERR 2
#define SUCCESS     0

// Function prototypes
void HistogramRequest(const char *prompt, Histogram &hist);
int minor();

int main(int argc, char **argv) {
  extern char *optarg;
  extern int optind;

  int c;
  int errflg = 0;

  System system;

  while ((c = getopt(argc, argv, "i:o:u:")) != EOF)
    switch (c) {
      // *** Options to add new images
    case 'i': // This image is in-class
      // filename is in optarg
      system.GetStandardModel().AddHistogram(new Histogram(optarg));
      break;
    case 'o': // This image is out-of-class (new model)
      // filename is in optarg
      system.AddModel(new Model);
      system.GetContrastModel().AddHistogram(new Histogram(optarg));
      break;
    case 'u': // This image is out-of-class (same model)
      // filename is in optarg
      system.GetContrastModel().AddHistogram(new Histogram(optarg));
      break;
    case '?':
      errflg++;
    }

  if (errflg) {
    fprintf(stderr,
	    "usage: viola [-i <filename>] [-o <filename>] [-u <filename]\n");
    exit(CMDLINE_ERR);
  }

  exit(SUCCESS);
}

int GeneratePatternImages() {
  Histogram test;
  HistogramRequest("Provide a test image: ", test);

  unsigned n = 0;
  for (HistBin m = test.GetFirstBin(); m; test.IncrementBin(m)) {
    printf("%ld\n", n);
    Pattern &pat = test.GetCluster(m).GetMean();
    GausPattern *gpat = (GausPattern *) &pat;
    Image *img = gpat->InferImage();
    char filename[128];
    sprintf(filename, "test%d.ppm", n);
    img->SaveImage(filename);
    delete img;
    n++;
  }
}
/*
int minor() {
  long i = -1, j = -1;
  FILE *fp;
  char filename[128];
  Model model;
  clock_t startt;
  char choice = 0;

  HistogramRequest("Model Image (.ppm) or Clusters (.cls): ",
		   model.GetModelHistogram());
  printf("  %ld\n", model.GetModelHistogram().GetCount());
  HistogramRequest("Constrast Image (.ppm) or Clusters (.cls): ",
		   model.GetContrastHistogram());
  printf("  %ld\n", model.GetContrastHistogram().GetCount());

  do {
    printf("\nTest Image (.ppm): ");
    scanf("%s", filename, 128);
  } while (strcmp(filename + strlen(filename) - 4, ".ppm") ||
	   !(fp = fopen(filename, "rb")));

  Image img3(filename);
  GausImage testhist(img3);
  CArray<Pattern *, Pattern *> *pats = testhist.MakePatterns();

  while (choice != 'q' && choice != 'Q') {
    printf("\nSelect a \"probability\" function (or (Q)uit)? [1, 2, 3, Q] ");
    fflush(NULL);
    choice = getchar();

    if (choice > '0' && choice < '4')
      printf("Please wait; this may take a while...\n");

    startt = clock();

    switch (choice) {
    case '1':
      printf("\n\nPaper Probability: %g\n",	     
	     model.PatternProb(*pats));
      break;
    case '2':
      printf("\n\nChi-Square Probability: %g\n",
	     model.ChiSqrProb(*pats));
      break;
    case '3':
      printf("\n\nEntropy Probability: %g\n",
	     model.EntropyProb(*pats));
      break;
    case 'q':
    case 'Q':
      printf("\n\nBye!\n");
      break;
    default:
      printf("\nInvalid option (%c)\n", choice);
    }

    if (choice > '0' && choice < '4')
      printf("  (Elapsed Time: %d seconds)\n",
	     (clock() - startt) / CLOCKS_PER_SEC);
  }

  puts("\nDone.\n");

  fclose(fp);

  return 0;
}
*/

// Gets a histogram, by hook or by crook
void HistogramRequest(const char *prompt, Histogram &hist) {
  FILE *fp;
  char filename[128];
  //CArray<Pattern *, Pattern *> *pats;
  CArray<LocPattern *, LocPattern *> *pats;
  unsigned long i;

  printf("\n");

  do {
    printf(prompt);
    scanf("%s", filename, 128);
  } while ((strcmp(filename + strlen(filename) - 4, ".ppm") &&
	    strcmp(filename + strlen(filename) - 4, ".cls")));

  /* Image File */
  if (!strcmp(filename + strlen(filename) - 4, ".ppm")) {
    printf("\n> Generate Clusters for %s...\n\n", filename);
    Image modelimg(filename);          // Open file

    printf("Enter a image file path to refine the clusters: ");
    scanf("%s", filename, 128);        // Contrast Image

    puts("\nAnalyzing image (this will take a couple minutes)...");
    puts("0");
    GausImage modelgimg(modelimg);
    //pats = modelgimg.MakePatterns();   // Create clustered histogram
    //hist.AddClusters(*pats, true);
    //hist.SelfCluster();
    puts("1");
    pats = modelgimg.MakeLocPatterns();
    puts("2");
    hist.GraphCluster(*pats, 10.0);
    puts("3");

    /*if (fopen(filename, "rb")) {
      Image antimg(filename);
      GausImage antgimg(antimg);
      pats = antgimg.MakePatterns();
      
      puts("Eliminating Clusters...");
      hist.EliminateBins(*pats);
      delete pats;
      }*/

    printf("  Clusters: %ld\n\n", hist.GetCount());

    printf("Enter a filename to save the clusters to a file: ");
    scanf("%s", filename, 128);

    if (filename)
      hist.SaveClusters(filename);
  } else {
    printf("\n> Read Clusters from %s...\n\n", filename);

    hist = (Histogram) filename;

    printf("  Clusters: %ld\n", hist.GetCount());
  }
}
