/****************************************************************************
 * Model -- All the information for a complete probability model            *
 ****************************************************************************
 * A probability model may be composed of multiple histograms from a single *
 * class.                                                                   *
 *                                                                          *
 ****************************************************************************/

#ifndef MODEL_H
#define MODEL_H

class Model;

#include "mystd.h"
#include "histogram.h"
#include "pattern.h"

class Model {
public:
  Model();
  Model(Histogram *in);
  ~Model();

  Histogram &GetModelHistogram(); // Creates histogram if doesn't exist

  unsigned GetHistogramCount();
  void SetHistogramCount(unsigned count);
  Histogram &GetHistogram(unsigned id);
  void AddHistogram(Histogram *newhist);
  void AddHistogram();

  // Final Image Classification Probabilities
  double CalcEntropy(const CArray<Pattern *, Pattern *> &pats);
  double CalcChiSqr(const CArray<Pattern *, Pattern *> &pats);
  double CalcPattern(const CArray<Pattern *, Pattern *> &pats);

private:
  CList<Histogram *, Histogram *> hists;
};

#endif
